/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.api.exceptions;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.aether.repository.RemoteRepository;
import org.wildfly.channel.ArtifactCoordinate;
import org.wildfly.channel.Repository;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.prospero.api.RepositoryUtils;
import org.wildfly.prospero.api.exceptions.OperationException;

public class ArtifactResolutionException
extends OperationException {
    private static final Set<String> OFFLINE_REPOSITORIES = Set.of("file".split(","));
    private Collection<RemoteRepository> repositories;
    private boolean offline;

    public ArtifactResolutionException(String msg, UnresolvedMavenArtifactException e) {
        super(msg, e);
    }

    public ArtifactResolutionException(String msg) {
        super(msg);
    }

    public ArtifactResolutionException(UnresolvedMavenArtifactException e) {
        super(e);
    }

    public ArtifactResolutionException(UnresolvedMavenArtifactException e, Collection<RemoteRepository> repositories, boolean offline) {
        super(e.getLocalizedMessage(), e);
        this.repositories = repositories;
        this.offline = offline;
    }

    public Set<Repository> attemptedRepositories() {
        return this.repositories.stream().filter(r -> !this.offline || this.isOfflineRepo((RemoteRepository)r)).map(RepositoryUtils::toChannelRepository).collect(Collectors.toSet());
    }

    public Set<Repository> offlineRepositories() {
        return this.repositories.stream().filter(r -> this.offline && !this.isOfflineRepo((RemoteRepository)r)).map(RepositoryUtils::toChannelRepository).collect(Collectors.toSet());
    }

    private boolean isOfflineRepo(RemoteRepository r) {
        for (String offlineProtocol : OFFLINE_REPOSITORIES) {
            if (!r.getUrl().startsWith(offlineProtocol)) continue;
            return true;
        }
        return false;
    }

    public Set<ArtifactCoordinate> failedArtifacts() {
        return Set.copyOf(((UnresolvedMavenArtifactException)this.getCause()).getUnresolvedArtifacts());
    }
}

