/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.galleon;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.text.StringSubstitutor;
import org.jboss.logging.Logger;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifestCoordinate;
import org.wildfly.prospero.Messages;
import org.wildfly.prospero.api.exceptions.MetadataException;

public class ChannelManifestSubstitutor {
    private static final Logger logger = Logger.getLogger(ChannelManifestSubstitutor.class);

    public static Channel substitute(Channel channel) throws MetadataException {
        URL substitutedURL;
        String substitutedFromSystemProperty;
        String substituted;
        ChannelManifestCoordinate channelManifestCoordinate = channel.getManifestCoordinate();
        if (channelManifestCoordinate.getUrl() == null) {
            return channel;
        }
        String url = channelManifestCoordinate.getUrl().toString();
        String string = substituted = !url.equals(substitutedFromSystemProperty = StringSubstitutor.replaceSystemProperties((Object)url)) ? substitutedFromSystemProperty : StringSubstitutor.replace((Object)url, System.getenv());
        if (url.equals(substituted)) {
            return channel;
        }
        try {
            substitutedURL = new URL(substituted);
        }
        catch (MalformedURLException e) {
            throw Messages.MESSAGES.invalidPropertySubstitutionValue(substituted, url);
        }
        logger.debug((Object)("Channel's manifest URL " + url + " is substituted by " + substituted));
        ChannelManifestCoordinate substitutedChannelManifestCoordinate = new ChannelManifestCoordinate(substitutedURL);
        if (channel.getSchemaVersion().isEmpty()) {
            return new Channel(channel.getName(), channel.getDescription(), channel.getVendor(), channel.getRepositories(), substitutedChannelManifestCoordinate, channel.getBlocklistCoordinate(), channel.getNoStreamStrategy());
        }
        return new Channel(channel.getSchemaVersion(), channel.getName(), channel.getDescription(), channel.getVendor(), channel.getRepositories(), substitutedChannelManifestCoordinate, channel.getBlocklistCoordinate(), channel.getNoStreamStrategy());
    }
}

