/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.galleon;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.layout.ProvisioningLayoutFactory;
import org.jboss.galleon.spec.FeaturePackPlugin;
import org.wildfly.channel.Channel;
import org.wildfly.channel.MavenArtifact;
import org.wildfly.prospero.galleon.ArtifactCache;
import org.wildfly.prospero.galleon.GalleonEnvironment;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

public class GalleonArtifactExporter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheGalleonArtifacts(List<Channel> channels, MavenSessionManager mavenSessionManager, Path installedDir, ProvisioningConfig provisioningConfig) throws Exception {
        Path tempInstallationPath = Files.createTempDirectory("temp", new FileAttribute[0]);
        try {
            ArrayList fps = new ArrayList();
            GalleonEnvironment galleonEnv = GalleonEnvironment.builder(tempInstallationPath, channels, mavenSessionManager).setConsole(null).setResolvedFpTracker(fps::add).build();
            ProvisioningManager pm = galleonEnv.getProvisioningManager();
            ProvisioningLayoutFactory layoutFactory = pm.getLayoutFactory();
            ProvisioningLayout layout = layoutFactory.newConfigLayout(provisioningConfig);
            HashSet<String> pluginGavs = new HashSet<String>();
            for (FeaturePackLayout fp : layout.getOrderedFeaturePacks()) {
                for (FeaturePackPlugin plugin : fp.getSpec().getPlugins().values()) {
                    pluginGavs.add(plugin.getLocation());
                }
            }
            ArtifactCache artifactCache = ArtifactCache.getInstance(installedDir);
            for (String pluginGav : pluginGavs) {
                String[] pluginLoc = pluginGav.split(":");
                MavenArtifact jar = galleonEnv.getChannelSession().resolveMavenArtifact(pluginLoc[0], pluginLoc[1], "jar", null, null);
                artifactCache.cache(jar);
            }
            for (String fp : fps) {
                String[] fpLoc = fp.split(":");
                MavenArtifact mavenArtifact = galleonEnv.getChannelSession().resolveMavenArtifact(fpLoc[0], fpLoc[1], "zip", null, null);
                artifactCache.cache(mavenArtifact);
            }
        }
        finally {
            FileUtils.deleteQuietly((File)tempInstallationPath.toFile());
        }
    }
}

