/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.galleon;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.layout.ProvisioningLayoutFactory;
import org.jboss.logging.Logger;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.ChannelSession;
import org.wildfly.channel.maven.VersionResolverFactory;
import org.wildfly.channel.spi.MavenVersionsResolver;
import org.wildfly.prospero.actions.Console;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.galleon.CachedVersionResolverFactory;
import org.wildfly.prospero.galleon.ChannelManifestSubstitutor;
import org.wildfly.prospero.galleon.ChannelMavenArtifactRepositoryManager;
import org.wildfly.prospero.galleon.GalleonUtils;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

public class GalleonEnvironment {
    private final ProvisioningManager provisioningManager;
    private final ChannelMavenArtifactRepositoryManager repositoryManager;
    private final ChannelSession channelSession;
    private final List<Channel> channels;
    private static final Logger logger = Logger.getLogger(GalleonEnvironment.class);

    private GalleonEnvironment(Builder builder) throws ProvisioningException, MetadataException {
        CachedVersionResolverFactory factory;
        Optional<Console> console = Optional.ofNullable(builder.console);
        Optional<ChannelManifest> restoreManifest = Optional.ofNullable(builder.manifest);
        this.channels = builder.channels;
        ArrayList<Channel> substitutedChannels = new ArrayList<Channel>();
        System.setProperty("installation.home", builder.installDir.toString());
        for (Channel channel : this.channels) {
            substitutedChannels.add(ChannelManifestSubstitutor.substitute(channel));
        }
        RepositorySystem system = builder.mavenSessionManager.newRepositorySystem();
        DefaultRepositorySystemSession session = builder.mavenSessionManager.newRepositorySystemSession(system);
        Path sourceServerPath = builder.sourceServerPath == null ? builder.installDir : builder.sourceServerPath;
        try {
            factory = new CachedVersionResolverFactory(new VersionResolverFactory(system, (RepositorySystemSession)session), sourceServerPath, system, session);
        }
        catch (IOException e) {
            logger.debug((Object)"Unable to read artifact cache, falling back to Maven resolver.", (Throwable)e);
            factory = new VersionResolverFactory(system, (RepositorySystemSession)session);
        }
        this.channelSession = new ChannelSession(this.channels, (MavenVersionsResolver.Factory)factory);
        this.repositoryManager = restoreManifest.isEmpty() ? new ChannelMavenArtifactRepositoryManager(this.channelSession) : new ChannelMavenArtifactRepositoryManager(this.channelSession, restoreManifest.get());
        this.provisioningManager = GalleonUtils.getProvisioningManager(builder.installDir, this.repositoryManager, builder.fpTracker);
        ProvisioningLayoutFactory layoutFactory = this.provisioningManager.getLayoutFactory();
        if (console.isPresent()) {
            layoutFactory.setProgressCallback("LAYOUT_BUILD", console.get().getProgressCallback("LAYOUT_BUILD"));
            layoutFactory.setProgressCallback("PACKAGES", console.get().getProgressCallback("PACKAGES"));
            layoutFactory.setProgressCallback("CONFIGS", console.get().getProgressCallback("CONFIGS"));
            layoutFactory.setProgressCallback("JBMODULES", console.get().getProgressCallback("JBMODULES"));
        }
    }

    public ProvisioningManager getProvisioningManager() {
        return this.provisioningManager;
    }

    public ChannelMavenArtifactRepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public ChannelSession getChannelSession() {
        return this.channelSession;
    }

    public List<Channel> getChannels() {
        return this.channels;
    }

    public static Builder builder(Path installDir, List<Channel> channels, MavenSessionManager mavenSessionManager) {
        Objects.requireNonNull(installDir);
        Objects.requireNonNull(channels);
        Objects.requireNonNull(mavenSessionManager);
        return new Builder(installDir, channels, mavenSessionManager);
    }

    public static class Builder {
        private final Path installDir;
        private final List<Channel> channels;
        private final MavenSessionManager mavenSessionManager;
        private Console console;
        private ChannelManifest manifest;
        private Consumer<String> fpTracker;
        private Path sourceServerPath;

        private Builder(Path installDir, List<Channel> channels, MavenSessionManager mavenSessionManager) {
            this.installDir = installDir;
            this.channels = channels;
            this.mavenSessionManager = mavenSessionManager;
        }

        public Builder setConsole(Console console) {
            this.console = console;
            return this;
        }

        public Builder setRestoreManifest(ChannelManifest manifest) {
            this.manifest = manifest;
            return this;
        }

        public Builder setResolvedFpTracker(Consumer<String> fpTracker) {
            this.fpTracker = fpTracker;
            return this;
        }

        public GalleonEnvironment build() throws ProvisioningException, OperationException {
            return new GalleonEnvironment(this);
        }

        public Builder setSourceServerPath(Path sourceServerPath) {
            this.sourceServerPath = sourceServerPath;
            return this;
        }

        public Path getSourceServerPath() {
            return this.sourceServerPath;
        }
    }
}

