/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.installation.git;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.Stream;
import org.wildfly.prospero.Messages;
import org.wildfly.prospero.api.ArtifactChange;
import org.wildfly.prospero.api.ChannelChange;
import org.wildfly.prospero.api.SavedState;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.model.ManifestYamlSupport;
import org.wildfly.prospero.model.ProsperoConfig;

public class GitStorage
implements AutoCloseable {
    public static final String GIT_HISTORY_USER = "Wildfly Installer";
    private final Git git;
    private Path base;

    public GitStorage(Path base) throws MetadataException {
        this.base = base.resolve(".installation");
        try {
            this.git = this.initGit();
        }
        catch (IOException | GitAPIException e) {
            throw Messages.MESSAGES.unableToCreateHistoryStorage(base, (Exception)e);
        }
    }

    public List<SavedState> getRevisions() throws MetadataException {
        try {
            Iterable call = this.git.log().call();
            ArrayList<SavedState> history = new ArrayList<SavedState>();
            for (RevCommit revCommit : call) {
                history.add(new SavedState(revCommit.getName().substring(0, 8), Instant.ofEpochSecond(revCommit.getCommitTime()), SavedState.Type.valueOf(revCommit.getShortMessage().toUpperCase(Locale.ROOT))));
            }
            return history;
        }
        catch (GitAPIException e) {
            throw Messages.MESSAGES.unableToAccessHistoryStorage(this.base, (Exception)((Object)e));
        }
    }

    public void record() throws MetadataException {
        try {
            SavedState.Type commitType;
            PersonIdent author;
            this.git.add().addFilepattern("manifest.yaml").call();
            if (this.isRepositoryEmpty(this.git)) {
                this.git.add().addFilepattern("installer-channels.yaml").call();
                author = this.adjustCommitDateToCreationDate(this.getCommitter());
                commitType = SavedState.Type.INSTALL;
            } else {
                author = this.getCommitter();
                commitType = SavedState.Type.UPDATE;
            }
            this.git.commit().setAuthor(author).setCommitter(author).setMessage(commitType.name()).call();
        }
        catch (IOException | GitAPIException e) {
            throw Messages.MESSAGES.unableToAccessHistoryStorage(this.base, (Exception)e);
        }
    }

    private PersonIdent getCommitter() {
        return new PersonIdent(GIT_HISTORY_USER, "");
    }

    private PersonIdent adjustCommitDateToCreationDate(PersonIdent committer) throws IOException {
        FileTime fileTime = Files.readAttributes(this.base, BasicFileAttributes.class, new LinkOption[0]).creationTime();
        return new PersonIdent(committer, fileTime.toMillis(), committer.getTimeZone().getRawOffset());
    }

    public void recordConfigChange() throws MetadataException {
        try {
            this.git.add().addFilepattern("installer-channels.yaml").call();
            PersonIdent author = this.getCommitter();
            this.git.commit().setAuthor(author).setCommitter(author).setMessage(SavedState.Type.CONFIG_CHANGE.name()).call();
        }
        catch (GitAPIException e) {
            throw Messages.MESSAGES.unableToAccessHistoryStorage(this.base, (Exception)((Object)e));
        }
    }

    public void revert(SavedState savedState) throws MetadataException {
        try {
            this.git.checkout().setStartPoint(savedState.getName()).addPath("manifest.yaml").call();
            this.git.add().addFilepattern("manifest.yaml").call();
            PersonIdent author = this.getCommitter();
            this.git.commit().setAuthor(author).setCommitter(author).setMessage(SavedState.Type.ROLLBACK.name()).call();
        }
        catch (GitAPIException e) {
            throw Messages.MESSAGES.unableToAccessHistoryStorage(this.base, (Exception)((Object)e));
        }
    }

    public List<ArtifactChange> getArtifactChanges(SavedState savedState) throws MetadataException {
        Parser parser = path -> {
            ChannelManifest parseOld = ManifestYamlSupport.parse(path.resolve("manifest.yaml").toFile());
            ChannelManifest parseCurrent = ManifestYamlSupport.parse(this.base.resolve("manifest.yaml").toFile());
            Map<String, Artifact> oldArtifacts = this.toMap(parseOld.getStreams());
            Map<String, Artifact> currentArtifacts = this.toMap(parseCurrent.getStreams());
            ArrayList<ArtifactChange> artifactChanges = new ArrayList<ArtifactChange>();
            for (String ga : currentArtifacts.keySet()) {
                if (!oldArtifacts.containsKey(ga)) {
                    artifactChanges.add(ArtifactChange.added(currentArtifacts.get(ga)));
                    continue;
                }
                if (currentArtifacts.get(ga).getVersion().equals(oldArtifacts.get(ga).getVersion())) continue;
                artifactChanges.add(ArtifactChange.updated(oldArtifacts.get(ga), currentArtifacts.get(ga)));
            }
            for (String ga : oldArtifacts.keySet()) {
                if (currentArtifacts.containsKey(ga)) continue;
                artifactChanges.add(ArtifactChange.removed(oldArtifacts.get(ga)));
            }
            return artifactChanges;
        };
        return this.getChanges(savedState, "manifest.yaml", parser);
    }

    public List<ChannelChange> getChannelChanges(SavedState savedState) throws MetadataException {
        Parser parser = path -> {
            List<Channel> oldChannels = ProsperoConfig.readConfig(path.resolve("installer-channels.yaml")).getChannels();
            List<Channel> currentChannels = ProsperoConfig.readConfig(this.base.resolve("installer-channels.yaml")).getChannels();
            ArrayList<ChannelChange> channelChanges = new ArrayList<ChannelChange>();
            for (Channel current2 : currentChannels) {
                Optional<Channel> oldChannel = oldChannels.stream().filter(old -> current2.getName().equals(old.getName())).findFirst();
                if (oldChannel.isEmpty()) {
                    channelChanges.add(ChannelChange.added(current2));
                    continue;
                }
                ChannelChange change = ChannelChange.modified(oldChannel.get(), current2);
                if (change.getChildren().isEmpty()) continue;
                channelChanges.add(change);
            }
            for (Channel old2 : oldChannels) {
                Optional<Channel> currentChannel = currentChannels.stream().filter(current -> current.getName().equals(old2.getName())).findFirst();
                if (!currentChannel.isEmpty()) continue;
                channelChanges.add(ChannelChange.removed(old2));
            }
            return channelChanges;
        };
        return this.getChanges(savedState, "installer-channels.yaml", parser);
    }

    public <T> List<T> getChanges(SavedState savedState, String manifestFileName, Parser<T> parser) throws MetadataException {
        Path hist = null;
        try {
            hist = this.checkoutPastState(savedState, manifestFileName);
            List<T> list = parser.parse(hist);
            return list;
        }
        catch (GitAPIException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw Messages.MESSAGES.unableToParseConfiguration(hist, e);
        }
        finally {
            try {
                if (hist != null) {
                    FileUtils.deleteDirectory((File)hist.toFile());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Map<String, Artifact> toMap(Collection<Stream> artifacts) {
        HashMap<String, Artifact> map = new HashMap<String, Artifact>();
        for (Stream stream : artifacts) {
            DefaultArtifact artifact = new DefaultArtifact(stream.getGroupId(), stream.getArtifactId(), "jar", stream.getVersion());
            map.put(stream.getGroupId() + ":" + stream.getArtifactId(), (Artifact)artifact);
        }
        return map;
    }

    private boolean isRepositoryEmpty(Git git) throws IOException {
        return git.getRepository().resolve("HEAD") == null;
    }

    private Git initGit() throws GitAPIException, IOException {
        Git git;
        if (!this.base.resolve(".git").toFile().exists()) {
            git = Git.init().setDirectory(this.base.toFile()).call();
            StoredConfig config = git.getRepository().getConfig();
            config.setBoolean("commit", null, "gpgsign", false);
            config.setString("user", null, "name", GIT_HISTORY_USER);
            config.setString("user", null, "email", "");
            config.save();
        } else {
            git = Git.open((File)this.base.toFile());
        }
        return git;
    }

    @Override
    public void close() throws Exception {
        if (this.git != null) {
            this.git.close();
        }
    }

    public boolean isStarted() throws IOException {
        return !this.isRepositoryEmpty(this.git);
    }

    private Path checkoutPastState(SavedState savedState, String fileName) throws GitAPIException, IOException {
        Path hist = Files.createTempDirectory("hist", new FileAttribute[0]);
        try (Git temp = Git.cloneRepository().setDirectory(hist.toFile()).setRemote("origin").setURI(this.base.toUri().toString()).call();){
            temp.checkout().setStartPoint(savedState.getName()).addPath(fileName).call();
            Path path = hist;
            return path;
        }
    }

    private static interface Parser<T> {
        public List<T> parse(Path var1) throws IOException, MetadataException;
    }
}

