/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.spi;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.wildfly.channel.ChannelManifestCoordinate;
import org.wildfly.channel.MavenCoordinate;
import org.wildfly.channel.Repository;
import org.wildfly.installationmanager.ArtifactChange;
import org.wildfly.installationmanager.Channel;
import org.wildfly.installationmanager.ChannelChange;
import org.wildfly.installationmanager.HistoryResult;
import org.wildfly.installationmanager.InstallationChanges;
import org.wildfly.installationmanager.MavenOptions;
import org.wildfly.installationmanager.spi.InstallationManager;
import org.wildfly.prospero.Messages;
import org.wildfly.prospero.actions.InstallationExportAction;
import org.wildfly.prospero.actions.InstallationHistoryAction;
import org.wildfly.prospero.actions.MetadataAction;
import org.wildfly.prospero.actions.UpdateAction;
import org.wildfly.prospero.api.SavedState;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.updates.UpdateSet;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

public class ProsperoInstallationManager
implements InstallationManager {
    private final ActionFactory actionFactory;

    public ProsperoInstallationManager(Path installationDir, MavenOptions mavenOptions) throws Exception {
        MavenSessionManager mavenSessionManager = new MavenSessionManager(Optional.ofNullable(mavenOptions.getLocalRepository()), mavenOptions.isOffline());
        this.actionFactory = new ActionFactory(installationDir, mavenSessionManager);
    }

    protected ProsperoInstallationManager(ActionFactory actionFactory) {
        this.actionFactory = actionFactory;
    }

    public List<HistoryResult> history() throws Exception {
        InstallationHistoryAction historyAction = this.actionFactory.getHistoryAction();
        List<SavedState> revisions = historyAction.getRevisions();
        ArrayList<HistoryResult> results = new ArrayList<HistoryResult>();
        for (SavedState savedState : revisions) {
            results.add(new HistoryResult(savedState.getName(), savedState.getTimestamp(), savedState.getType().toString()));
        }
        return results;
    }

    public InstallationChanges revisionDetails(String revision) throws MetadataException {
        Objects.requireNonNull(revision);
        InstallationHistoryAction historyAction = this.actionFactory.getHistoryAction();
        org.wildfly.prospero.api.InstallationChanges changes = historyAction.compare(new SavedState(revision));
        if (changes.isEmpty()) {
            return new InstallationChanges(Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        }
        List artifacts = changes.getArtifactChanges().stream().map(ProsperoInstallationManager::mapArtifactChange).collect(Collectors.toList());
        List channels = changes.getChannelChanges().stream().map(ProsperoInstallationManager::mapChannelChange).collect(Collectors.toList());
        return new InstallationChanges(artifacts, channels);
    }

    public void prepareRevert(String revision, Path targetDir, List<org.wildfly.installationmanager.Repository> repositories) throws Exception {
        Objects.requireNonNull(revision);
        Objects.requireNonNull(targetDir);
        InstallationHistoryAction historyAction = this.actionFactory.getHistoryAction();
        historyAction.prepareRevert(new SavedState(revision), this.actionFactory.mavenSessionManager, ProsperoInstallationManager.map(repositories, ProsperoInstallationManager::mapRepository), targetDir);
    }

    public void prepareUpdate(Path targetDir, List<org.wildfly.installationmanager.Repository> repositories) throws Exception {
        try (UpdateAction prepareUpdateAction = this.actionFactory.getUpdateAction(ProsperoInstallationManager.map(repositories, ProsperoInstallationManager::mapRepository));){
            prepareUpdateAction.buildUpdate(targetDir);
        }
    }

    public List<ArtifactChange> findUpdates(List<org.wildfly.installationmanager.Repository> repositories) throws Exception {
        try (UpdateAction updateAction = this.actionFactory.getUpdateAction(ProsperoInstallationManager.map(repositories, ProsperoInstallationManager::mapRepository));){
            UpdateSet updates = updateAction.findUpdates();
            List<ArtifactChange> list = updates.getArtifactUpdates().stream().map(ProsperoInstallationManager::mapArtifactChange).collect(Collectors.toList());
            return list;
        }
    }

    public Collection<Channel> listChannels() throws OperationException {
        try (MetadataAction metadataAction = this.actionFactory.getMetadataAction();){
            Collection collection = metadataAction.getChannels().stream().map(ProsperoInstallationManager::mapChannel).collect(Collectors.toList());
            return collection;
        }
    }

    public void removeChannel(String channelName) throws OperationException {
        try (MetadataAction metadataAction = this.actionFactory.getMetadataAction();){
            metadataAction.removeChannel(channelName);
        }
    }

    public void addChannel(Channel channel) throws OperationException {
        try (MetadataAction metadataAction = this.actionFactory.getMetadataAction();){
            metadataAction.addChannel(ProsperoInstallationManager.mapChannel(channel));
        }
    }

    public void changeChannel(String channelName, Channel newChannel) throws OperationException {
        try (MetadataAction metadataAction = this.actionFactory.getMetadataAction();){
            metadataAction.changeChannel(channelName, ProsperoInstallationManager.mapChannel(newChannel));
        }
    }

    public Path createSnapshot(Path targetPath) throws Exception {
        String timestamp;
        Path snapshotPath;
        if (!Files.exists(targetPath, new LinkOption[0])) {
            if (targetPath.endsWith(".zip")) {
                snapshotPath = targetPath.toAbsolutePath();
            } else {
                timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                snapshotPath = targetPath.resolve("im-snapshot-" + timestamp + ".zip").toAbsolutePath();
            }
        } else if (Files.isDirectory(targetPath, new LinkOption[0])) {
            timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            snapshotPath = targetPath.resolve("im-snapshot-" + timestamp + ".zip").toAbsolutePath();
        } else {
            throw Messages.MESSAGES.fileAlreadyExists(targetPath);
        }
        InstallationExportAction installationExportAction = this.actionFactory.getInstallationExportAction();
        installationExportAction.export(snapshotPath);
        return snapshotPath;
    }

    private static Channel mapChannel(org.wildfly.channel.Channel channel) {
        if (channel.getManifestCoordinate() == null) {
            return new Channel(channel.getName(), ProsperoInstallationManager.map(channel.getRepositories(), ProsperoInstallationManager::mapRepository));
        }
        if (channel.getManifestCoordinate().getUrl() != null) {
            return new Channel(channel.getName(), ProsperoInstallationManager.map(channel.getRepositories(), ProsperoInstallationManager::mapRepository), channel.getManifestCoordinate().getUrl());
        }
        if (channel.getManifestCoordinate().getMaven() != null) {
            return new Channel(channel.getName(), ProsperoInstallationManager.map(channel.getRepositories(), ProsperoInstallationManager::mapRepository), ProsperoInstallationManager.toGav(channel.getManifestCoordinate().getMaven()));
        }
        return new Channel(channel.getName(), ProsperoInstallationManager.map(channel.getRepositories(), ProsperoInstallationManager::mapRepository));
    }

    private static String toGav(MavenCoordinate coord) {
        String ga = coord.getGroupId() + ":" + coord.getArtifactId();
        if (coord.getVersion() != null && !coord.getVersion().isEmpty()) {
            return ga + ":" + coord.getVersion();
        }
        return ga;
    }

    private static org.wildfly.channel.Channel mapChannel(Channel channel) {
        return new org.wildfly.channel.Channel(channel.getName(), null, null, ProsperoInstallationManager.map(channel.getRepositories(), ProsperoInstallationManager::mapRepository), ProsperoInstallationManager.toManifestCoordinate(channel), null, null);
    }

    private static ChannelManifestCoordinate toManifestCoordinate(Channel c) {
        if (c.getManifestUrl().isPresent()) {
            return new ChannelManifestCoordinate((URL)c.getManifestUrl().get());
        }
        if (c.getManifestCoordinate().isPresent()) {
            String[] coordinate = ((String)c.getManifestCoordinate().get()).split(":");
            return new ChannelManifestCoordinate(coordinate[0], coordinate[1]);
        }
        return null;
    }

    private static <T, R> List<R> map(List<T> subject, Function<T, R> mapper) {
        if (subject == null) {
            return Collections.emptyList();
        }
        return subject.stream().map(mapper::apply).collect(Collectors.toList());
    }

    private static Repository mapRepository(org.wildfly.installationmanager.Repository repository) {
        return new Repository(repository.getId(), repository.getUrl());
    }

    private static org.wildfly.installationmanager.Repository mapRepository(Repository repository) {
        return new org.wildfly.installationmanager.Repository(repository.getId(), repository.getUrl());
    }

    private static ArtifactChange mapArtifactChange(org.wildfly.prospero.api.ArtifactChange change) {
        if (change.isInstalled()) {
            return new ArtifactChange(null, change.getNewVersion().get(), change.getArtifactName(), ArtifactChange.Status.INSTALLED);
        }
        if (change.isRemoved()) {
            return new ArtifactChange(change.getOldVersion().get(), null, change.getArtifactName(), ArtifactChange.Status.REMOVED);
        }
        return new ArtifactChange(change.getOldVersion().get(), change.getNewVersion().get(), change.getArtifactName(), ArtifactChange.Status.UPDATED);
    }

    private static ChannelChange mapChannelChange(org.wildfly.prospero.api.ChannelChange change) {
        Channel oldChannel = change.getOldChannel() == null ? null : ProsperoInstallationManager.mapChannel(change.getOldChannel());
        Channel newChannel = change.getNewChannel() == null ? null : ProsperoInstallationManager.mapChannel(change.getNewChannel());
        switch (change.getStatus()) {
            case ADDED: {
                return new ChannelChange(oldChannel, newChannel, ChannelChange.Status.ADDED);
            }
            case REMOVED: {
                return new ChannelChange(oldChannel, newChannel, ChannelChange.Status.REMOVED);
            }
        }
        return new ChannelChange(oldChannel, newChannel, ChannelChange.Status.MODIFIED);
    }

    protected static class ActionFactory {
        private final Path server;
        private final MavenSessionManager mavenSessionManager;

        private ActionFactory(Path server, MavenSessionManager mavenSessionManager) {
            this.server = server;
            this.mavenSessionManager = mavenSessionManager;
        }

        protected InstallationHistoryAction getHistoryAction() {
            return new InstallationHistoryAction(this.server, null);
        }

        protected UpdateAction getUpdateAction(List<Repository> repositories) throws OperationException {
            return new UpdateAction(this.server, this.mavenSessionManager, null, repositories);
        }

        protected MetadataAction getMetadataAction() throws MetadataException {
            return new MetadataAction(this.server);
        }

        protected InstallationExportAction getInstallationExportAction() {
            return new InstallationExportAction(this.server);
        }
    }
}

