/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.prospero.api.exceptions.ArtifactPromoteException;
import org.wildfly.prospero.api.exceptions.ArtifactResolutionException;
import org.wildfly.prospero.api.exceptions.InvalidUpdateCandidateException;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.NoChannelException;
import org.wildfly.prospero.api.exceptions.ProvisioningRuntimeException;

@MessageBundle(projectCode="PRSP")
public interface Messages {
    public static final Messages MESSAGES = (Messages)org.jboss.logging.Messages.getBundle(Messages.class);

    @Message(value="Given path '%s' is a regular file. An empty directory or a non-existing path must be given.")
    public IllegalArgumentException dirMustBeDirectory(Path var1);

    @Message(value="Can't install into a non empty directory '%s'. Use `update` command if you want to modify existing installation.")
    public IllegalArgumentException cannotInstallIntoNonEmptyDirectory(Path var1);

    @Message(value="Installation dir '%s' doesn't exist")
    public IllegalArgumentException installationDirDoesNotExist(Path var1);

    @Message(value="Installation dir '%s' already exists")
    public ProvisioningException installationDirAlreadyExists(Path var1);

    @Message(value="Artifact [%s:%s] not found")
    public ArtifactResolutionException artifactNotFound(String var1, String var2, @Cause UnresolvedMavenArtifactException var3);

    @Message(value="Given configuration doesn't reference any channel or channel manifest.")
    public NoChannelException noChannelReference();

    @Message(value="Invalid channel: Channel '%s' doesn't reference a manifest.")
    public NoChannelException noChannelManifestReference(String var1);

    @Message(value="Pre-defined FPL [%s] doesn't specify any channels and no explicit channels were given.")
    public NoChannelException fplDefinitionDoesntContainChannel(String var1);

    @Message(value="Channel '%s' is already present.")
    public MetadataException channelExists(String var1);

    @Message(value="Channel with name [%s] cannot be found.")
    public MetadataException channelNotFound(String var1);

    @Message(value="Channel name cannot be empty.")
    public MetadataException emptyChannelName();

    @Message(value="Promoting artifacts to %s:")
    public String promotingArtifacts(URL var1);

    @Message(value="Provided FPL has invalid format `%s`.")
    public String invalidFpl(String var1);

    @Message(value="Unable to parse server configuration at '%s'")
    public MetadataException unableToParseConfiguration(Path var1, @Cause Throwable var2);

    @Message(value="Unable to parse server configuration at '%s'")
    public MetadataException unableToParseConfigurationUri(URI var1, @Cause Throwable var2);

    @Message(value="Unable to save server configuration at '%s'")
    public MetadataException unableToSaveConfiguration(Path var1, @Cause Exception var2);

    @Message(value="Unable to close the update store.")
    public MetadataException unableToCloseStore(@Cause Exception var1);

    @Message(value="Path `%s` does not contain a server installation provisioned by prospero.")
    public IllegalArgumentException invalidInstallationDir(Path var1);

    @Message(value="Unable to create history store at [%s]")
    public MetadataException unableToCreateHistoryStorage(Path var1, @Cause Exception var2);

    @Message(value="Unable to access history store at [%s]")
    public MetadataException unableToAccessHistoryStorage(Path var1, @Cause Exception var2);

    @Message(value="Unable to read file at [%s]")
    public MetadataException unableToReadFile(Path var1, @Cause Exception var2);

    @Message(value="Unable to download file from [%s]")
    public MetadataException unableToDownloadFile(URL var1, @Cause IOException var2);

    @Message(value="Unable to write file at [%s]")
    public MetadataException unableToWriteFile(Path var1, @Cause Exception var2);

    @Message(value="Unable to create temporary cache for provisioning cache folder.")
    public ProvisioningException unableToCreateCache(@Cause Exception var1);

    @Message(value="Failed to initiate maven repository system")
    public ProvisioningRuntimeException failedToInitMaven(@Cause Throwable var1);

    @Message(value="Invalide URL [%s]")
    public IllegalArgumentException invalidUrl(String var1, @Cause Exception var2);

    @Message(value="Incomplete configuration: If the FPL is not one of predefined names (%s) a channel must be given.")
    public IllegalArgumentException predefinedFplOrChannelRequired(String var1);

    @Message(value="Incomplete configuration: neither FPL nor Galleon provisioning config was given.")
    public IllegalArgumentException fplNorGalleonConfigWereSet();

    @Message(value="Provided metadata bundle [%s] is missing one or more entries")
    public IllegalArgumentException incompleteMetadataBundle(Path var1);

    @Message(value="Found unexpected artifact [%s]")
    public ProvisioningRuntimeException unexpectedArtifact(String var1);

    @Message(value="Unable to resolve [%s]")
    public MavenUniverseException unableToResolve(String var1);

    @Message(value="File already exists [%s]")
    public IllegalArgumentException fileAlreadyExists(Path var1);

    @Message(value="Promoting to non-file repositories is not currently supported")
    public IllegalArgumentException unsupportedPromotionTarget();

    @Message(value="Wrong format of custom channel version [%s]")
    public IllegalArgumentException wrongVersionFormat(String var1);

    @Message(value="Custom channel version exceeded limit [%s]")
    public IllegalArgumentException versionLimitExceeded(String var1);

    @Message(value="Cannot create bundle without artifacts.")
    public IllegalArgumentException noArtifactsToPackage();

    @Message(value="Channel reference has to use Maven GA.")
    public IllegalArgumentException nonMavenChannelRef();

    @Message(value="Unable to promote artifacts to [%s].")
    public ArtifactPromoteException unableToPromote(URL var1, @Cause Exception var2);

    @Message(value="Unable to parse the customization bundle [%s].")
    public ArtifactPromoteException unableToParseCustomizationBundle(Path var1, @Cause Exception var2);

    @Message(value="At least one repository must be set when using the manifest option.")
    public IllegalArgumentException repositoriesMustBeSetWithManifest();

    @Message(value="Out file [%s] exists already!")
    public IllegalArgumentException outFileExists(Path var1);

    @Message(value="Installation metadata is exported to [%s].")
    public String installationExported(Path var1);

    @Message(value="The file: [%s] to be restored does not exist.")
    public String restoreFileNotExisted(Path var1);

    @Message(value="Installation meta was restored from: [%s] to [%s].")
    public String installationMetaRestored(Path var1, Path var2);

    @Message(value="Malformed URL in substituted value : %s from %s")
    public MetadataException invalidPropertySubstitutionValue(String var1, String var2);

    @Message(value="The installation at %s is not a valid update for %s")
    public InvalidUpdateCandidateException invalidUpdateCandidate(Path var1, Path var2);

    @Message(value="The installation at %s is not a valid rollback for %s")
    public InvalidUpdateCandidateException invalidRollbackCandidate(Path var1, Path var2);

    @Message(value="The requested state %s does not exist in server's history.")
    public MetadataException savedStateNotFound(String var1);

    @Message(value="Unable to create temporary directory")
    public ProvisioningException unableToCreateTemporaryDirectory(@Cause Throwable var1);
}

