/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.jboss.galleon.util.HashUtils;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifestCoordinate;
import org.wildfly.channel.Repository;
import org.wildfly.channel.maven.VersionResolverFactory;
import org.wildfly.channel.spi.MavenVersionsResolver;
import org.wildfly.channel.version.VersionMatcher;
import org.wildfly.prospero.Messages;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.model.ManifestVersionRecord;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

class ManifestVersionResolver {
    private final VersionResolverFactory resolverFactory;

    ManifestVersionResolver(MavenSessionManager msm) {
        MavenSessionManager mavenSessionManager = new MavenSessionManager(msm);
        mavenSessionManager.setOffline(true);
        RepositorySystem system = mavenSessionManager.newRepositorySystem();
        DefaultRepositorySystemSession session = mavenSessionManager.newRepositorySystemSession(system);
        this.resolverFactory = new VersionResolverFactory(system, (RepositorySystemSession)session);
    }

    ManifestVersionResolver(VersionResolverFactory resolverFactory) {
        this.resolverFactory = resolverFactory;
    }

    ManifestVersionRecord getCurrentVersions(List<Channel> channels) throws MetadataException {
        Objects.requireNonNull(channels);
        ManifestVersionRecord manifestVersionRecord = new ManifestVersionRecord();
        for (Channel channel : channels) {
            ChannelManifestCoordinate manifestCoordinate = channel.getManifestCoordinate();
            if (manifestCoordinate == null) {
                List<String> repos = channel.getRepositories().stream().map(Repository::getId).collect(Collectors.toList());
                manifestVersionRecord.addManifest(new ManifestVersionRecord.NoManifest(repos, channel.getNoStreamStrategy().toString()));
                continue;
            }
            if (manifestCoordinate.getUrl() != null) {
                try {
                    String content = IOUtils.toString((URL)manifestCoordinate.getUrl());
                    String hashCode = HashUtils.hash((String)content);
                    manifestVersionRecord.addManifest(new ManifestVersionRecord.UrlManifest(manifestCoordinate.getUrl().toExternalForm(), hashCode));
                    continue;
                }
                catch (IOException e) {
                    throw Messages.MESSAGES.unableToDownloadFile(manifestCoordinate.getUrl(), e);
                }
            }
            if (manifestCoordinate.getVersion() != null) {
                manifestVersionRecord.addManifest(new ManifestVersionRecord.MavenManifest(manifestCoordinate.getGroupId(), manifestCoordinate.getArtifactId(), manifestCoordinate.getVersion()));
                continue;
            }
            MavenVersionsResolver mavenVersionsResolver = this.resolverFactory.create((Collection)channel.getRepositories());
            Optional latestVersion = VersionMatcher.getLatestVersion((Set)mavenVersionsResolver.getAllVersions(manifestCoordinate.getGroupId(), manifestCoordinate.getArtifactId(), manifestCoordinate.getExtension(), manifestCoordinate.getClassifier()));
            manifestVersionRecord.addManifest(new ManifestVersionRecord.MavenManifest(manifestCoordinate.getGroupId(), manifestCoordinate.getArtifactId(), (String)latestVersion.get()));
        }
        return manifestVersionRecord;
    }
}

