/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ProvisioningConfig;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.prospero.Messages;
import org.wildfly.prospero.actions.ManifestVersionResolver;
import org.wildfly.prospero.api.Console;
import org.wildfly.prospero.api.InstallationMetadata;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.api.RepositoryUtils;
import org.wildfly.prospero.api.exceptions.ArtifactResolutionException;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.galleon.ChannelMavenArtifactRepositoryManager;
import org.wildfly.prospero.galleon.GalleonEnvironment;
import org.wildfly.prospero.galleon.GalleonFeaturePackAnalyzer;
import org.wildfly.prospero.galleon.GalleonUtils;
import org.wildfly.prospero.licenses.License;
import org.wildfly.prospero.licenses.LicenseManager;
import org.wildfly.prospero.model.ManifestVersionRecord;
import org.wildfly.prospero.model.ProsperoConfig;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

public class ProvisioningAction {
    private static final String CHANNEL_NAME_PREFIX = "channel-";
    private final MavenSessionManager mavenSessionManager;
    private final Path installDir;
    private final Console console;
    private final LicenseManager licenseManager;
    private final MavenOptions mvnOptions;

    public ProvisioningAction(Path installDir, MavenOptions mvnOptions, Console console) throws ProvisioningException {
        this.installDir = installDir;
        this.console = console;
        this.mvnOptions = mvnOptions;
        this.mavenSessionManager = new MavenSessionManager(mvnOptions);
        this.licenseManager = new LicenseManager();
        ProvisioningAction.verifyInstallDir(installDir);
    }

    public void provision(ProvisioningConfig provisioningConfig, List<Channel> channels) throws ProvisioningException, OperationException, MalformedURLException {
        channels = this.enforceChannelNames(channels);
        GalleonEnvironment galleonEnv = GalleonEnvironment.builder(this.installDir, channels, this.mavenSessionManager).setConsole(this.console).build();
        try {
            GalleonUtils.executeGalleon(options -> galleonEnv.getProvisioningManager().provision(provisioningConfig, options), this.mavenSessionManager.getProvisioningRepo().toAbsolutePath());
        }
        catch (UnresolvedMavenArtifactException e) {
            List<RemoteRepository> repositories = galleonEnv.getChannels().stream().flatMap(c -> c.getRepositories().stream()).map(r -> RepositoryUtils.toRemoteRepository(r.getId(), r.getUrl())).collect(Collectors.toList());
            throw new ArtifactResolutionException(e, repositories, this.mavenSessionManager.isOffline());
        }
        ManifestVersionRecord manifestRecord = new ManifestVersionResolver(this.mavenSessionManager).getCurrentVersions(channels);
        this.writeProsperoMetadata(this.installDir, galleonEnv.getRepositoryManager(), channels, manifestRecord);
        try {
            GalleonFeaturePackAnalyzer galleonFeaturePackAnalyzer = new GalleonFeaturePackAnalyzer(galleonEnv.getChannels(), this.mavenSessionManager);
            try {
                this.licenseManager.recordAgreements(this.getPendingLicenses(provisioningConfig, galleonFeaturePackAnalyzer), this.installDir);
            }
            catch (IOException e) {
                throw Messages.MESSAGES.unableToWriteFile(this.installDir.resolve("licenses"), e);
            }
            galleonFeaturePackAnalyzer.cacheGalleonArtifacts(this.installDir, provisioningConfig);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<License> getPendingLicenses(ProvisioningConfig provisioningConfig, List<Channel> channels) {
        Objects.requireNonNull(provisioningConfig);
        Objects.requireNonNull(channels);
        GalleonFeaturePackAnalyzer exporter = new GalleonFeaturePackAnalyzer(channels, this.mavenSessionManager);
        return this.getPendingLicenses(provisioningConfig, exporter);
    }

    private List<License> getPendingLicenses(ProvisioningConfig provisioningConfig, GalleonFeaturePackAnalyzer exporter) {
        try {
            List<String> featurePacks = exporter.getFeaturePacks(provisioningConfig);
            return this.licenseManager.getLicenses(featurePacks);
        }
        catch (IOException | ProvisioningException | OperationException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeProsperoMetadata(Path home, ChannelMavenArtifactRepositoryManager maven, List<Channel> channels, ManifestVersionRecord manifestVersions) throws MetadataException {
        ChannelManifest manifest = maven.resolvedChannel();
        try (InstallationMetadata installationMetadata = InstallationMetadata.newInstallation(home, manifest, new ProsperoConfig(channels, this.mvnOptions), Optional.of(manifestVersions));){
            installationMetadata.recordProvision(true, true);
        }
    }

    private List<Channel> enforceChannelNames(List<Channel> newChannels) {
        AtomicInteger channelCounter = new AtomicInteger(0);
        return newChannels.stream().map(c -> {
            if (StringUtils.isEmpty((CharSequence)c.getName())) {
                return new Channel(c.getSchemaVersion(), CHANNEL_NAME_PREFIX + channelCounter.getAndIncrement(), c.getDescription(), c.getVendor(), c.getRepositories(), c.getManifestCoordinate(), c.getBlocklistCoordinate(), c.getNoStreamStrategy());
            }
            return c;
        }).collect(Collectors.toList());
    }

    private static void verifyInstallDir(Path directory) {
        if (directory.toFile().isFile()) {
            throw Messages.MESSAGES.dirMustBeDirectory(directory);
        }
        if (!ProvisioningAction.isEmptyDirectory(directory)) {
            throw Messages.MESSAGES.cannotInstallIntoNonEmptyDirectory(directory);
        }
    }

    private static boolean isEmptyDirectory(Path directory) {
        String[] list = directory.toFile().list();
        return list == null || list.length == 0;
    }
}

