/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.galleon;

import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.wildfly.prospero.Messages;

public class FeaturePackLocationParser {
    public static FeaturePackLocation resolveFpl(String fplText) {
        FeaturePackLocation fpl = FeaturePackLocation.fromString((String)fplText);
        if (fpl.isMavenCoordinates() || fpl.getUniverse() != null) {
            return fpl;
        }
        String[] parts = fplText.split(":");
        if (parts.length == 1) {
            throw new IllegalArgumentException(Messages.MESSAGES.invalidFpl(fplText));
        }
        MavenArtifact artifact = new MavenArtifact();
        artifact.setGroupId(parts[0]);
        artifact.setArtifactId(parts[1]);
        artifact.setVersion(null);
        artifact.setExtension("zip");
        return new FeaturePackLocation(UniverseSpec.fromString((String)"maven"), fpl.getProducerName() + ":" + fpl.getChannelName() + "::zip", null, null, artifact.getVersion());
    }
}

