/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.jboss.galleon.ProvisioningException;
import org.wildfly.channel.Repository;
import org.wildfly.prospero.Messages;
import org.wildfly.prospero.actions.ApplyCandidateAction;
import org.wildfly.prospero.actions.PrepareCandidateAction;
import org.wildfly.prospero.api.Console;
import org.wildfly.prospero.api.InstallationChanges;
import org.wildfly.prospero.api.InstallationMetadata;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.api.SavedState;
import org.wildfly.prospero.api.TemporaryRepositoriesHandler;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.galleon.GalleonEnvironment;
import org.wildfly.prospero.metadata.ManifestVersionRecord;
import org.wildfly.prospero.metadata.ProsperoMetadataUtils;
import org.wildfly.prospero.model.ProsperoConfig;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

public class InstallationHistoryAction {
    private final Path installation;
    private final Console console;

    public InstallationHistoryAction(Path installation, Console console) {
        this.installation = installation;
        this.console = console;
    }

    public InstallationChanges compare(SavedState savedState) throws MetadataException {
        InstallationMetadata installationMetadata = InstallationMetadata.loadInstallation(this.installation);
        InstallationHistoryAction.verifyStateExists(savedState, installationMetadata);
        return installationMetadata.getChangesSince(savedState);
    }

    public List<SavedState> getRevisions() throws MetadataException {
        InstallationMetadata installationMetadata = InstallationMetadata.loadInstallation(this.installation);
        return installationMetadata.getRevisions();
    }

    public void rollback(SavedState savedState, MavenOptions mavenOptions, List<Repository> overrideRepositories) throws OperationException, ProvisioningException {
        Path tempDirectory = null;
        try {
            tempDirectory = Files.createTempDirectory("revert-candidate", new FileAttribute[0]);
            this.prepareRevert(savedState, mavenOptions, overrideRepositories, tempDirectory);
            new ApplyCandidateAction(this.installation, tempDirectory).applyUpdate(ApplyCandidateAction.Type.REVERT);
        }
        catch (IOException e) {
            throw Messages.MESSAGES.unableToCreateTemporaryDirectory(e);
        }
        finally {
            if (tempDirectory != null) {
                FileUtils.deleteQuietly((File)tempDirectory.toFile());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareRevert(SavedState savedState, MavenOptions mavenOptions, List<Repository> overrideRepositories, Path targetDir) throws OperationException, ProvisioningException {
        try (InstallationMetadata metadata = InstallationMetadata.loadInstallation(this.installation);){
            InstallationHistoryAction.verifyStateExists(savedState, metadata);
            ProsperoConfig prosperoConfig = new ProsperoConfig(TemporaryRepositoriesHandler.overrideRepositories(metadata.getProsperoConfig().getChannels(), overrideRepositories));
            MavenSessionManager mavenSessionManager = new MavenSessionManager(mavenOptions);
            try (InstallationMetadata revertMetadata = metadata.getSavedState(savedState);){
                GalleonEnvironment galleonEnv = GalleonEnvironment.builder(targetDir, prosperoConfig.getChannels(), mavenSessionManager).setConsole(this.console).setRestoreManifest(revertMetadata.getManifest()).build();
                System.setProperty("maven.repo.local", mavenSessionManager.getProvisioningRepo().toAbsolutePath().toString());
                try (PrepareCandidateAction prepareCandidateAction = new PrepareCandidateAction(this.installation, mavenSessionManager, this.console, prosperoConfig);){
                    prepareCandidateAction.buildCandidate(targetDir, galleonEnv, ApplyCandidateAction.Type.REVERT);
                }
                InstallationHistoryAction.revertCurrentVersions(targetDir, revertMetadata);
            }
            finally {
                System.clearProperty("maven.repo.local");
            }
        }
    }

    private static void revertCurrentVersions(Path targetDir, InstallationMetadata revertMetadata) throws MetadataException {
        try {
            Optional<ManifestVersionRecord> manifestHistory = revertMetadata.getManifestVersions();
            if (manifestHistory.isPresent()) {
                ProsperoMetadataUtils.writeVersionRecord((Path)targetDir.resolve(".installation").resolve("manifest_version.yaml"), (ManifestVersionRecord)manifestHistory.get());
            } else {
                Path versionsFile = targetDir.resolve(".installation").resolve("manifest_version.yaml");
                if (Files.exists(versionsFile, new LinkOption[0])) {
                    Files.delete(versionsFile);
                }
            }
        }
        catch (IOException e) {
            throw Messages.MESSAGES.unableToWriteFile(targetDir.resolve(".installation").resolve("manifest_version.yaml"), e);
        }
    }

    public void applyRevert(Path updateDirectory) throws OperationException, ProvisioningException {
        ApplyCandidateAction applyAction = new ApplyCandidateAction(this.installation, updateDirectory);
        if (ApplyCandidateAction.ValidationResult.OK != applyAction.verifyCandidate(ApplyCandidateAction.Type.REVERT)) {
            throw Messages.MESSAGES.invalidRollbackCandidate(updateDirectory, this.installation);
        }
        applyAction.applyUpdate(ApplyCandidateAction.Type.REVERT);
    }

    private static void verifyStateExists(SavedState savedState, InstallationMetadata metadata) throws MetadataException {
        if (!metadata.getRevisions().stream().filter(s -> s.getName().equals(savedState.getName())).findFirst().isPresent()) {
            throw Messages.MESSAGES.savedStateNotFound(savedState.getName());
        }
    }
}

