/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.wildfly.channel.Channel;
import org.wildfly.prospero.Messages;
import org.wildfly.prospero.api.InstallationMetadata;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.model.ProsperoConfig;

public class MetadataAction
implements AutoCloseable {
    private final InstallationMetadata installationMetadata;

    public MetadataAction(Path installation) throws MetadataException {
        this.installationMetadata = InstallationMetadata.loadInstallation(installation);
    }

    protected MetadataAction(InstallationMetadata installationMetadata) {
        this.installationMetadata = installationMetadata;
    }

    public void addChannel(Channel channel) throws MetadataException {
        ProsperoConfig prosperoConfig = this.installationMetadata.getProsperoConfig();
        List<Channel> channels = prosperoConfig.getChannels();
        if (channels.stream().filter(c -> c.getName().equals(channel.getName())).findAny().isPresent()) {
            throw Messages.MESSAGES.channelExists(channel.getName());
        }
        channels.add(channel);
        this.installationMetadata.updateProsperoConfig(prosperoConfig);
    }

    public void removeChannel(String channelName) throws MetadataException {
        ProsperoConfig prosperoConfig = this.installationMetadata.getProsperoConfig();
        List<Channel> channels = prosperoConfig.getChannels();
        Optional<Channel> removedChannel = channels.stream().filter(c -> c.getName().equals(channelName)).findAny();
        if (removedChannel.isEmpty()) {
            throw Messages.MESSAGES.channelNotFound(channelName);
        }
        channels.remove(removedChannel.get());
        this.installationMetadata.updateProsperoConfig(prosperoConfig);
    }

    public void changeChannel(String channelName, Channel newChannel) throws MetadataException {
        ProsperoConfig prosperoConfig = this.installationMetadata.getProsperoConfig();
        List<Channel> channels = prosperoConfig.getChannels();
        Optional<Channel> modifiedChannel = channels.stream().filter(c -> c.getName().equals(channelName)).findAny();
        if (modifiedChannel.isEmpty()) {
            throw Messages.MESSAGES.channelNotFound(channelName);
        }
        channels.set(channels.indexOf(modifiedChannel.get()), newChannel);
        this.installationMetadata.updateProsperoConfig(prosperoConfig);
    }

    public List<Channel> getChannels() throws MetadataException {
        return new ArrayList<Channel>(this.installationMetadata.getProsperoConfig().getChannels());
    }

    public Channel getChannel(int index) throws MetadataException {
        if (index < 0) {
            return null;
        }
        ProsperoConfig prosperoConfig = this.installationMetadata.getProsperoConfig();
        List<Channel> channels = prosperoConfig.getChannels();
        if (channels.size() <= index) {
            return null;
        }
        return channels.get(index);
    }

    @Override
    public void close() {
        this.installationMetadata.close();
    }
}

