/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.galleon;

import java.io.File;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferEvent;
import org.jboss.galleon.progresstracking.ProgressCallback;
import org.jboss.galleon.progresstracking.ProgressTracker;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.wildfly.prospero.api.Console;
import org.wildfly.prospero.api.ProvisioningProgressEvent;

class DownloadsCallbackAdapter
extends AbstractTransferListener
implements ProgressCallback<MavenArtifact> {
    private final Console console;
    private long totalVolume;
    private long processed;
    private boolean currentPhase = false;

    public DownloadsCallbackAdapter(Console console) {
        this.console = console;
    }

    public void starting(ProgressTracker<MavenArtifact> tracker) {
        this.totalVolume = tracker.getTotalVolume();
        this.processed = 0L;
        this.currentPhase = true;
        ProvisioningProgressEvent progress = new ProvisioningProgressEvent("JB_ARTIFACTS_RESOLVE", ProvisioningProgressEvent.EventType.STARTING, tracker.getProcessedVolume(), tracker.getTotalVolume());
        this.console.progressUpdate(progress);
    }

    public void pulse(ProgressTracker<MavenArtifact> progressTracker) {
    }

    public void complete(ProgressTracker<MavenArtifact> tracker) {
        ProvisioningProgressEvent progress = new ProvisioningProgressEvent("JB_ARTIFACTS_RESOLVE", ProvisioningProgressEvent.EventType.COMPLETED, tracker.getProcessedVolume(), tracker.getTotalVolume());
        this.console.progressUpdate(progress);
        this.totalVolume = 0L;
        this.processed = 0L;
        this.currentPhase = false;
    }

    public void transferSucceeded(TransferEvent event) {
        if (!this.currentPhase) {
            return;
        }
        String item = event.getResource().getResourceName();
        item = item.substring(item.lastIndexOf(File.separator) + 1);
        ProvisioningProgressEvent progress = new ProvisioningProgressEvent("JB_ARTIFACTS_RESOLVE", ProvisioningProgressEvent.EventType.UPDATE, ++this.processed, this.totalVolume, item, false);
        this.console.progressUpdate(progress);
    }
}

