/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.galleon;

import java.nio.file.Path;
import java.util.List;
import org.jboss.galleon.progresstracking.ProgressCallback;
import org.jboss.galleon.progresstracking.ProgressTracker;
import org.jboss.galleon.state.ProvisionedConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.wildfly.prospero.api.Console;
import org.wildfly.prospero.api.ProvisioningProgressEvent;

public class GalleonCallbackAdapter
implements ProgressCallback<Object> {
    private static final int PULSE_INTERVAL = 500;
    private static final int PULSE_PCT = 5;
    private final String id;
    private Console console;

    public GalleonCallbackAdapter(Console console, String id) {
        this.console = console;
        this.id = id;
    }

    public long getProgressPulsePct() {
        return 5L;
    }

    public long getMinPulseIntervalMs() {
        return 500L;
    }

    public long getMaxPulseIntervalMs() {
        return 500L;
    }

    public void starting(ProgressTracker tracker) {
        ProvisioningProgressEvent progress = new ProvisioningProgressEvent(this.id, ProvisioningProgressEvent.EventType.STARTING, tracker.getProcessedVolume(), tracker.getTotalVolume());
        this.console.progressUpdate(progress);
    }

    public void pulse(ProgressTracker tracker) {
    }

    public void complete(ProgressTracker tracker) {
        ProvisioningProgressEvent progress = new ProvisioningProgressEvent(this.id, ProvisioningProgressEvent.EventType.COMPLETED, tracker.getProcessedVolume(), tracker.getTotalVolume());
        this.console.progressUpdate(progress);
    }

    public void processing(ProgressTracker<Object> tracker) {
        Object item = null;
        boolean slowPhase = false;
        switch (this.id) {
            case "LAYOUT_BUILD": {
                item = ((FeaturePackLocation.FPID)tracker.getItem()).getLocation().toString();
                break;
            }
            case "CONFIGS": {
                if (tracker.getItem() != null) {
                    item = ((ProvisionedConfig)tracker.getItem()).getModel() + "/" + ((ProvisionedConfig)tracker.getItem()).getName();
                    break;
                }
                slowPhase = true;
                break;
            }
            case "JBEXTRACONFIGS": {
                List items = (List)tracker.getItem();
                if (items.get(1) instanceof ProvisionedConfig) {
                    item = "Generating " + ((ProvisionedConfig)items.get(1)).getName();
                } else if (items.get(1) instanceof Path) {
                    item = "Installing config " + ((Path)items.get(1)).getFileName();
                }
                if (!items.get(0).equals("CONFIGS")) break;
                slowPhase = true;
                break;
            }
            case "JB_ARTIFACTS_RESOLVE": {
                item = tracker.getItem() != null ? ((MavenArtifact)tracker.getItem()).toString() : "";
            }
        }
        ProvisioningProgressEvent progress = new ProvisioningProgressEvent(this.id, ProvisioningProgressEvent.EventType.UPDATE, tracker.getProcessedVolume(), tracker.getTotalVolume(), (String)item, slowPhase);
        this.console.progressUpdate(progress);
    }
}

