/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.promotion;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.eclipse.aether.artifact.Artifact;
import org.wildfly.channel.ArtifactCoordinate;
import org.wildfly.prospero.Messages;
import org.wildfly.prospero.promotion.CustomArtifact;
import org.wildfly.prospero.promotion.CustomArtifactList;

public class ArtifactBundle
implements AutoCloseable {
    public static final String BUNDLE_REPO_FOLDER = "maven-repository";
    public static final String FS = "/";
    public static final String ARTIFACT_LIST_YAML = "artifact-list.yaml";
    private final Path extracted;
    private List<ArtifactCoordinate> artifactCoordinates;

    private ArtifactBundle(Path extracted) throws IOException {
        this.extracted = extracted;
        this.artifactCoordinates = CustomArtifactList.readFrom(extracted.resolve(ARTIFACT_LIST_YAML)).getArtifactCoordinates();
    }

    public List<ArtifactCoordinate> getArtifactList() {
        return this.artifactCoordinates;
    }

    public Path getRepository() {
        return this.extracted.resolve(BUNDLE_REPO_FOLDER);
    }

    @Override
    public void close() {
        FileUtils.deleteQuietly((File)this.extracted.toFile());
    }

    public static ArtifactBundle extract(Path archivePath) throws IOException {
        Path extracted = null;
        try {
            ArtifactBundle artifactBundle = new ArtifactBundle(ArtifactBundle.unzipArchive(archivePath.toFile()));
            return artifactBundle;
        }
        finally {
            if (extracted != null) {
                FileUtils.deleteQuietly((File)extracted.toFile());
            }
        }
    }

    public static Path createCustomizationArchive(List<? extends Artifact> artifacts, File archive) throws IOException {
        Objects.requireNonNull(artifacts);
        Objects.requireNonNull(archive);
        if (artifacts.isEmpty()) {
            throw Messages.MESSAGES.noArtifactsToPackage();
        }
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(archive));){
            zos.putNextEntry(new ZipEntry(ARTIFACT_LIST_YAML));
            CustomArtifactList artifactList = new CustomArtifactList(artifacts.stream().map(a -> CustomArtifact.from(a)).collect(Collectors.toList()));
            String listYaml = artifactList.writeToString();
            zos.write(listYaml.getBytes(StandardCharsets.UTF_8), 0, listYaml.length());
            HashSet<Object> createdPaths = new HashSet<Object>();
            zos.putNextEntry(new ZipEntry("maven-repository/"));
            for (Artifact artifact : artifacts) {
                Object entry = "maven-repository/";
                for (String dir : artifact.getGroupId().split("\\.")) {
                    if (createdPaths.contains(entry = (String)entry + dir + FS)) continue;
                    zos.putNextEntry(new ZipEntry((String)entry));
                    createdPaths.add(entry);
                }
                entry = (String)entry + artifact.getArtifactId() + FS;
                zos.putNextEntry(new ZipEntry((String)entry));
                entry = (String)entry + artifact.getVersion() + FS;
                zos.putNextEntry(new ZipEntry((String)entry));
                Object fileName = entry = (String)entry + artifact.getFile().getName();
                zos.putNextEntry(new ZipEntry((String)fileName));
                try (FileInputStream fis = new FileInputStream(artifact.getFile());){
                    int len;
                    byte[] buffer = new byte[1024];
                    while ((len = fis.read(buffer)) > 0) {
                        zos.write(buffer, 0, len);
                    }
                }
                entry = (String)fileName + ".md5";
                zos.putNextEntry(new ZipEntry((String)entry));
                String md5 = DigestUtils.md5Hex((InputStream)new FileInputStream(artifact.getFile()));
                zos.write(md5.getBytes(), 0, md5.getBytes().length);
                entry = (String)fileName + ".sha1";
                zos.putNextEntry(new ZipEntry((String)entry));
                String sha1 = DigestUtils.sha1Hex((InputStream)new FileInputStream(artifact.getFile()));
                zos.write(sha1.getBytes(), 0, sha1.getBytes().length);
            }
        }
        return archive.toPath();
    }

    private static Path unzipArchive(File archivePath) throws IOException {
        Path extracted = Files.createTempDirectory("customization", new FileAttribute[0]);
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(archivePath));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    Files.createDirectories(extracted.resolve(entry.getName()), new FileAttribute[0]);
                    continue;
                }
                Files.copy(zis, extracted.resolve(entry.getName()), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        return extracted;
    }
}

