/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.galleon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.wildfly.channel.ArtifactCoordinate;
import org.wildfly.channel.MavenArtifact;
import org.wildfly.prospero.ProsperoLogger;

public class MavenArtifactMapper {
    private final Collection<org.jboss.galleon.universe.maven.MavenArtifact> galleonArtifacts;
    private final HashMap<String, List<org.jboss.galleon.universe.maven.MavenArtifact>> artifactMap = new HashMap();

    public MavenArtifactMapper(Collection<org.jboss.galleon.universe.maven.MavenArtifact> galleonArtifacts) {
        this.galleonArtifacts = galleonArtifacts;
        for (org.jboss.galleon.universe.maven.MavenArtifact a : galleonArtifacts) {
            String key = this.coordString(a.getGroupId(), a.getArtifactId(), a.getExtension(), a.getClassifier());
            if (!this.artifactMap.containsKey(key)) {
                this.artifactMap.put(key, new ArrayList());
            }
            this.artifactMap.get(key).add(a);
        }
    }

    private String coordString(String groupId, String artifactId, String extension, String classifier) {
        return String.format("%s:%s:%s:%s", groupId, artifactId, this.wrapNull(extension), this.wrapNull(classifier));
    }

    private String wrapNull(String value) {
        return value == null ? "" : value;
    }

    public List<ArtifactCoordinate> toChannelArtifacts() {
        return this.galleonArtifacts.stream().map(a -> new ArtifactCoordinate(a.getGroupId(), a.getArtifactId(), a.getExtension(), a.getClassifier(), a.getVersion())).collect(Collectors.toList());
    }

    public static boolean isSameArtifact(MavenArtifact channelArtifact, org.jboss.galleon.universe.maven.MavenArtifact galleonArtifact) {
        return channelArtifact.getGroupId().equals(galleonArtifact.getGroupId()) && channelArtifact.getArtifactId().equals(galleonArtifact.getArtifactId()) && channelArtifact.getClassifier().equals(galleonArtifact.getClassifier()) && channelArtifact.getExtension().equals(galleonArtifact.getExtension());
    }

    public Collection<org.jboss.galleon.universe.maven.MavenArtifact> applyResolution(List<MavenArtifact> channelArtifacts) {
        for (MavenArtifact channelArtifact : channelArtifacts) {
            String key = this.coordString(channelArtifact.getGroupId(), channelArtifact.getArtifactId(), channelArtifact.getExtension(), channelArtifact.getClassifier());
            if (!this.artifactMap.containsKey(key)) {
                throw ProsperoLogger.ROOT_LOGGER.unexpectedArtifact(key);
            }
            for (org.jboss.galleon.universe.maven.MavenArtifact a : this.artifactMap.get(key)) {
                MavenArtifactMapper.resolve(a, channelArtifact);
            }
        }
        return this.galleonArtifacts;
    }

    public static void resolve(org.jboss.galleon.universe.maven.MavenArtifact artifact, MavenArtifact resolvedArtifact) {
        Objects.requireNonNull(artifact);
        Objects.requireNonNull(resolvedArtifact);
        Objects.requireNonNull(resolvedArtifact.getFile());
        Objects.requireNonNull(resolvedArtifact.getVersion());
        artifact.setVersion(resolvedArtifact.getVersion());
        artifact.setPath(resolvedArtifact.getFile().toPath());
    }
}

