/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.updates;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.wildfly.channel.ChannelSession;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.prospero.api.ArtifactChange;
import org.wildfly.prospero.api.exceptions.ArtifactResolutionException;
import org.wildfly.prospero.updates.UpdateSet;

public class UpdateFinder
implements AutoCloseable {
    public static final int UPDATES_SEARCH_PARALLELISM = 10;
    private final ChannelSession channelSession;
    private final ExecutorService executorService;

    public UpdateFinder(ChannelSession channelSession) {
        this.channelSession = channelSession;
        this.executorService = Executors.newWorkStealingPool(10);
    }

    public UpdateSet findUpdates(List<Artifact> artifacts) throws ArtifactResolutionException {
        ArrayList allPackages = new ArrayList();
        for (Artifact artifact : artifacts) {
            CompletableFuture cf2 = new CompletableFuture();
            this.executorService.submit(() -> {
                try {
                    Optional<ArtifactChange> found = this.findUpdates(artifact);
                    cf2.complete(found);
                }
                catch (Exception e) {
                    cf2.completeExceptionally(e);
                }
            });
            allPackages.add(cf2);
        }
        try {
            CompletableFuture.allOf(allPackages.toArray(new CompletableFuture[0])).join();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof ArtifactResolutionException) {
                throw (ArtifactResolutionException)e.getCause();
            }
            throw e;
        }
        List<ArtifactChange> updates = allPackages.stream().map(cf -> cf.getNow(Optional.empty())).flatMap(Optional::stream).collect(Collectors.toList());
        return new UpdateSet(updates);
    }

    private Optional<ArtifactChange> findUpdates(Artifact artifact) throws ArtifactResolutionException {
        String latestVersion;
        try {
            latestVersion = this.channelSession.findLatestMavenArtifactVersion(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), null);
        }
        catch (UnresolvedMavenArtifactException e) {
            return Optional.of(ArtifactChange.removed(artifact));
        }
        DefaultArtifact latest = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), latestVersion);
        if (latestVersion == null || latest.getVersion().equals(artifact.getVersion())) {
            return Optional.empty();
        }
        ArtifactChange change = artifact == null ? ArtifactChange.added((Artifact)latest) : (latest == null ? ArtifactChange.removed((Artifact)latest) : ArtifactChange.updated(artifact, (Artifact)latest));
        return Optional.of(change);
    }

    @Override
    public void close() {
        this.executorService.shutdown();
    }
}

