/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.jboss.galleon.ProvisioningException;
import org.wildfly.channel.Channel;
import org.wildfly.channel.Repository;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.actions.ApplyCandidateAction;
import org.wildfly.prospero.actions.PrepareCandidateAction;
import org.wildfly.prospero.api.Console;
import org.wildfly.prospero.api.FileConflict;
import org.wildfly.prospero.api.InstallationMetadata;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.api.TemporaryRepositoriesHandler;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.galleon.GalleonEnvironment;
import org.wildfly.prospero.model.ProsperoConfig;
import org.wildfly.prospero.updates.UpdateFinder;
import org.wildfly.prospero.updates.UpdateSet;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

public class UpdateAction
implements AutoCloseable {
    private final InstallationMetadata metadata;
    private final MavenSessionManager mavenSessionManager;
    private final Path installDir;
    private final Console console;
    private final ProsperoConfig prosperoConfig;
    private final MavenOptions mavenOptions;

    public UpdateAction(Path installDir, MavenOptions mavenOptions, Console console, List<Repository> overrideRepositories) throws OperationException, ProvisioningException {
        this.metadata = InstallationMetadata.loadInstallation(installDir);
        this.installDir = installDir;
        this.console = console;
        this.prosperoConfig = this.addTemporaryRepositories(overrideRepositories);
        this.mavenOptions = this.prosperoConfig.getMavenOptions().merge(mavenOptions);
        this.mavenSessionManager = new MavenSessionManager(this.mavenOptions);
    }

    public List<FileConflict> performUpdate() throws OperationException, ProvisioningException {
        ProsperoLogger.ROOT_LOGGER.performUpdateStarted(this.installDir);
        Path targetDir = null;
        try {
            targetDir = Files.createTempDirectory("update-candidate", new FileAttribute[0]);
            if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                ProsperoLogger.ROOT_LOGGER.temporaryCandidateFolder(targetDir);
            }
            if (this.buildUpdate(targetDir)) {
                ApplyCandidateAction applyCandidateAction = new ApplyCandidateAction(this.installDir, targetDir);
                List<FileConflict> list = applyCandidateAction.applyUpdate(ApplyCandidateAction.Type.UPDATE);
                return list;
            }
            List<FileConflict> applyCandidateAction = Collections.emptyList();
            return applyCandidateAction;
        }
        catch (IOException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToCreateTemporaryDirectory(e);
        }
        finally {
            if (targetDir != null) {
                FileUtils.deleteQuietly((File)targetDir.toFile());
            }
        }
    }

    public boolean buildUpdate(Path targetDir) throws ProvisioningException, OperationException {
        if (this.findUpdates().isEmpty()) {
            ProsperoLogger.ROOT_LOGGER.noUpdatesFound(this.installDir);
            return false;
        }
        ProsperoLogger.ROOT_LOGGER.updateCandidateStarted(this.installDir);
        try (PrepareCandidateAction prepareCandidateAction = new PrepareCandidateAction(this.installDir, this.mavenSessionManager, this.console, this.prosperoConfig);){
            boolean result = prepareCandidateAction.buildCandidate(targetDir, this.getGalleonEnv(targetDir), ApplyCandidateAction.Type.UPDATE);
            ProsperoLogger.ROOT_LOGGER.updateCandidateCompleted(targetDir);
            boolean bl = result;
            return bl;
        }
    }

    public UpdateSet findUpdates() throws OperationException, ProvisioningException {
        ProsperoLogger.ROOT_LOGGER.checkingUpdates();
        GalleonEnvironment galleonEnv = this.getGalleonEnv(this.installDir);
        try (UpdateFinder updateFinder = new UpdateFinder(galleonEnv.getChannelSession());){
            UpdateSet updates = updateFinder.findUpdates(this.metadata.getArtifacts());
            ProsperoLogger.ROOT_LOGGER.updatesFound(updates.getArtifactUpdates().size());
            UpdateSet updateSet = updates;
            return updateSet;
        }
    }

    private GalleonEnvironment getGalleonEnv(Path target) throws ProvisioningException, OperationException {
        return GalleonEnvironment.builder(target, this.prosperoConfig.getChannels(), this.mavenSessionManager).setSourceServerPath(this.installDir).setConsole(this.console).build();
    }

    @Override
    public void close() {
        this.metadata.close();
    }

    private ProsperoConfig addTemporaryRepositories(List<Repository> repositories) {
        ProsperoConfig prosperoConfig = this.metadata.getProsperoConfig();
        List<Channel> channels = TemporaryRepositoriesHandler.overrideRepositories(prosperoConfig.getChannels(), repositories);
        return new ProsperoConfig(channels, prosperoConfig.getMavenOptions());
    }
}

