/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.galleon;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.transfer.TransferListener;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.layout.ProvisioningLayoutFactory;
import org.jboss.galleon.progresstracking.ProgressCallback;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.ChannelMetadataCoordinate;
import org.wildfly.channel.ChannelSession;
import org.wildfly.channel.InvalidChannelMetadataException;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.channel.maven.VersionResolverFactory;
import org.wildfly.channel.spi.MavenVersionsResolver;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.api.Console;
import org.wildfly.prospero.api.exceptions.ChannelDefinitionException;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.api.exceptions.UnresolvedChannelMetadataException;
import org.wildfly.prospero.galleon.CachedVersionResolverFactory;
import org.wildfly.prospero.galleon.ChannelManifestSubstitutor;
import org.wildfly.prospero.galleon.ChannelMavenArtifactRepositoryManager;
import org.wildfly.prospero.galleon.DownloadsCallbackAdapter;
import org.wildfly.prospero.galleon.GalleonCallbackAdapter;
import org.wildfly.prospero.galleon.GalleonUtils;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

public class GalleonEnvironment {
    public static final String TRACK_JBMODULES = "JBMODULES";
    public static final String TRACK_JBEXAMPLES = "JBEXTRACONFIGS";
    public static final String TRACK_JB_ARTIFACTS_RESOLVE = "JB_ARTIFACTS_RESOLVE";
    public static final String TRACK_RESOLVING_VERSIONS = "RESOLVING_VERSIONS";
    private final ProvisioningManager provisioningManager;
    private final ChannelMavenArtifactRepositoryManager repositoryManager;
    private final ChannelSession channelSession;
    private final List<Channel> channels;

    private GalleonEnvironment(Builder builder) throws ProvisioningException, MetadataException, ChannelDefinitionException, UnresolvedChannelMetadataException {
        CachedVersionResolverFactory factory;
        Optional<Console> console = Optional.ofNullable(builder.console);
        Optional<ChannelManifest> restoreManifest = Optional.ofNullable(builder.manifest);
        this.channels = builder.channels;
        ArrayList<Channel> substitutedChannels = new ArrayList<Channel>();
        ChannelManifestSubstitutor substitutor = new ChannelManifestSubstitutor(Map.of("installation.home", builder.installDir.toString()));
        for (Channel channel : this.channels) {
            substitutedChannels.add(substitutor.substitute(channel));
        }
        RepositorySystem system = builder.mavenSessionManager.newRepositorySystem();
        DefaultRepositorySystemSession session = builder.mavenSessionManager.newRepositorySystemSession(system);
        Path sourceServerPath = builder.sourceServerPath == null ? builder.installDir : builder.sourceServerPath;
        try {
            factory = new CachedVersionResolverFactory(new VersionResolverFactory(system, (RepositorySystemSession)session), sourceServerPath, system, session);
        }
        catch (IOException e) {
            ProsperoLogger.ROOT_LOGGER.debug("Unable to read artifact cache, falling back to Maven resolver.", e);
            factory = new VersionResolverFactory(system, (RepositorySystemSession)session);
        }
        this.channelSession = this.initChannelSession(session, factory);
        this.repositoryManager = restoreManifest.isEmpty() ? new ChannelMavenArtifactRepositoryManager(this.channelSession) : new ChannelMavenArtifactRepositoryManager(this.channelSession, restoreManifest.get());
        this.provisioningManager = GalleonUtils.getProvisioningManager(builder.installDir, this.repositoryManager, builder.fpTracker);
        ProvisioningLayoutFactory layoutFactory = this.provisioningManager.getLayoutFactory();
        Stream.of("LAYOUT_BUILD", "PACKAGES", "CONFIGS", TRACK_JBMODULES, TRACK_JBEXAMPLES).forEach(t -> layoutFactory.setProgressCallback(t, (ProgressCallback)new GalleonCallbackAdapter(console.orElse(null), (String)t)));
        DownloadsCallbackAdapter callback = new DownloadsCallbackAdapter(console.orElse(null));
        session.setTransferListener((TransferListener)callback);
        layoutFactory.setProgressCallback(TRACK_JB_ARTIFACTS_RESOLVE, (ProgressCallback)callback);
    }

    private ChannelSession initChannelSession(DefaultRepositorySystemSession session, MavenVersionsResolver.Factory factory) throws UnresolvedChannelMetadataException, ChannelDefinitionException {
        ChannelSession channelSession;
        try {
            channelSession = new ChannelSession(this.channels, factory);
        }
        catch (UnresolvedMavenArtifactException e) {
            Set<ChannelMetadataCoordinate> missingArtifacts = e.getUnresolvedArtifacts().stream().map(a -> new ChannelMetadataCoordinate(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getClassifier(), a.getExtension())).collect(Collectors.toSet());
            throw new UnresolvedChannelMetadataException(ProsperoLogger.ROOT_LOGGER.unableToResolve(), e, missingArtifacts, e.getAttemptedRepositories(), session.isOffline());
        }
        catch (InvalidChannelMetadataException e) {
            if (e.getCause() instanceof FileNotFoundException) {
                String url = (String)e.getValidationMessages().get(0);
                try {
                    ChannelMetadataCoordinate coord = new ChannelMetadataCoordinate(new URL(url));
                    throw new UnresolvedChannelMetadataException(ProsperoLogger.ROOT_LOGGER.unableToResolve(), e, Set.of(coord), Collections.emptySet(), session.isOffline());
                }
                catch (MalformedURLException ex) {
                    throw ProsperoLogger.ROOT_LOGGER.invalidManifest(e);
                }
            }
            throw ProsperoLogger.ROOT_LOGGER.invalidManifest(e);
        }
        return channelSession;
    }

    public ProvisioningManager getProvisioningManager() {
        return this.provisioningManager;
    }

    public ChannelMavenArtifactRepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public ChannelSession getChannelSession() {
        return this.channelSession;
    }

    public List<Channel> getChannels() {
        return this.channels;
    }

    public static Builder builder(Path installDir, List<Channel> channels, MavenSessionManager mavenSessionManager) {
        Objects.requireNonNull(installDir);
        Objects.requireNonNull(channels);
        Objects.requireNonNull(mavenSessionManager);
        return new Builder(installDir, channels, mavenSessionManager);
    }

    public static class Builder {
        private final Path installDir;
        private final List<Channel> channels;
        private final MavenSessionManager mavenSessionManager;
        private Console console;
        private ChannelManifest manifest;
        private Consumer<String> fpTracker;
        private Path sourceServerPath;

        private Builder(Path installDir, List<Channel> channels, MavenSessionManager mavenSessionManager) {
            this.installDir = installDir;
            this.channels = channels;
            this.mavenSessionManager = mavenSessionManager;
        }

        public Builder setConsole(Console console) {
            this.console = console;
            return this;
        }

        public Builder setRestoreManifest(ChannelManifest manifest) {
            this.manifest = manifest;
            return this;
        }

        public Builder setResolvedFpTracker(Consumer<String> fpTracker) {
            this.fpTracker = fpTracker;
            return this;
        }

        public GalleonEnvironment build() throws ProvisioningException, OperationException {
            return new GalleonEnvironment(this);
        }

        public Builder setSourceServerPath(Path sourceServerPath) {
            this.sourceServerPath = sourceServerPath;
            return this;
        }

        public Path getSourceServerPath() {
            return this.sourceServerPath;
        }
    }
}

