/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.api;

import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.xml.ProvisioningXmlParser;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.Stream;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.api.InstallationChanges;
import org.wildfly.prospero.api.SavedState;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.installation.git.GitStorage;
import org.wildfly.prospero.metadata.ManifestVersionRecord;
import org.wildfly.prospero.metadata.ProsperoMetadataUtils;
import org.wildfly.prospero.model.ManifestYamlSupport;
import org.wildfly.prospero.model.ProsperoConfig;

public class InstallationMetadata
implements AutoCloseable {
    public static final String PROVISIONING_FILE_NAME = "provisioning.xml";
    public static final String GALLEON_INSTALLATION_DIR = ".galleon";
    private final Path manifestFile;
    private final Path channelsFile;
    private final Path readmeFile;
    private final Path provisioningFile;
    private final ProvisioningConfig galleonProvisioningConfig;
    private final GitStorage gitStorage;
    private final Path base;
    private final Optional<ManifestVersionRecord> manifestVersion;
    private ProsperoConfig prosperoConfig;
    private ChannelManifest manifest;

    public static InstallationMetadata loadInstallation(Path base) throws MetadataException {
        ChannelManifest manifest;
        Path manifestFile = base.resolve(".installation").resolve("manifest.yaml");
        Optional currentVersion = Optional.empty();
        try {
            manifest = ManifestYamlSupport.parse(manifestFile.toFile());
        }
        catch (IOException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToParseConfiguration(manifestFile, e);
        }
        ProsperoConfig prosperoConfig = ProsperoConfig.readConfig(base.resolve(".installation"));
        Path versionsFile = base.resolve(".installation").resolve("manifest_version.yaml");
        try {
            currentVersion = ManifestVersionRecord.read((Path)versionsFile);
        }
        catch (JsonMappingException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToParseConfiguration(versionsFile, e);
        }
        catch (IOException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToReadFile(versionsFile, e);
        }
        try {
            GitStorage gitStorage = new GitStorage(base);
            InstallationMetadata metadata = new InstallationMetadata(base, manifest, prosperoConfig, gitStorage, currentVersion);
            if (!gitStorage.isStarted()) {
                ProsperoLogger.ROOT_LOGGER.debugf("Initializing history storage in %s", base);
                gitStorage.record();
            }
            return metadata;
        }
        catch (IOException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToCreateHistoryStorage(base.resolve(".installation"), e);
        }
    }

    public static InstallationMetadata newInstallation(Path base, ChannelManifest manifest, ProsperoConfig prosperoConfig, Optional<ManifestVersionRecord> currentVersions) throws MetadataException {
        return new InstallationMetadata(base, manifest, prosperoConfig, new GitStorage(base), currentVersions);
    }

    public static InstallationMetadata fromMetadataBundle(Path archiveLocation) throws IOException, MetadataException {
        if (!(Files.exists(archiveLocation, new LinkOption[0]) && Files.isRegularFile(archiveLocation, new LinkOption[0]) && Files.isReadable(archiveLocation))) {
            throw ProsperoLogger.ROOT_LOGGER.invalidMetadataBundle(archiveLocation);
        }
        Path tempDirectory = Files.createTempDirectory("installer-import", new FileAttribute[0]);
        tempDirectory.toFile().deleteOnExit();
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(archiveLocation.toFile()));){
            ZipEntry entry;
            Path manifestFile = null;
            Path channelsFile = null;
            Path provisioningFile = null;
            Files.createDirectory(tempDirectory.resolve(".installation"), new FileAttribute[0]);
            Files.createDirectory(tempDirectory.resolve(GALLEON_INSTALLATION_DIR), new FileAttribute[0]);
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.getName().equals("manifest.yaml")) {
                    manifestFile = tempDirectory.resolve(".installation").resolve("manifest.yaml");
                    Files.copy(zis, manifestFile, StandardCopyOption.REPLACE_EXISTING);
                    manifestFile.toFile().deleteOnExit();
                }
                if (entry.getName().equals("installer-channels.yaml")) {
                    channelsFile = tempDirectory.resolve(".installation").resolve("installer-channels.yaml");
                    Files.copy(zis, channelsFile, StandardCopyOption.REPLACE_EXISTING);
                    channelsFile.toFile().deleteOnExit();
                }
                if (!entry.getName().equals(PROVISIONING_FILE_NAME)) continue;
                provisioningFile = tempDirectory.resolve(GALLEON_INSTALLATION_DIR).resolve(PROVISIONING_FILE_NAME);
                Files.copy(zis, provisioningFile, StandardCopyOption.REPLACE_EXISTING);
                provisioningFile.toFile().deleteOnExit();
            }
            if (manifestFile == null || channelsFile == null || provisioningFile == null) {
                throw ProsperoLogger.ROOT_LOGGER.incompleteMetadataBundle(archiveLocation);
            }
        }
        return InstallationMetadata.loadInstallation(tempDirectory);
    }

    protected InstallationMetadata(Path base, ChannelManifest manifest, ProsperoConfig prosperoConfig, GitStorage gitStorage, Optional<ManifestVersionRecord> currentVersions) throws MetadataException {
        this.base = base;
        this.gitStorage = gitStorage;
        this.manifestFile = ProsperoMetadataUtils.manifestPath((Path)base);
        this.channelsFile = ProsperoMetadataUtils.configurationPath((Path)base);
        this.readmeFile = base.resolve(".installation").resolve("README.txt");
        this.provisioningFile = base.resolve(GALLEON_INSTALLATION_DIR).resolve(PROVISIONING_FILE_NAME);
        this.manifest = manifest;
        this.prosperoConfig = new ProsperoConfig(new ArrayList<Channel>(prosperoConfig.getChannels()), prosperoConfig.getMavenOptions());
        List<Channel> channels = prosperoConfig.getChannels();
        if (channels != null && channels.stream().filter(c -> StringUtils.isEmpty((CharSequence)c.getName())).findAny().isPresent()) {
            throw ProsperoLogger.ROOT_LOGGER.emptyChannelName();
        }
        try {
            this.galleonProvisioningConfig = ProvisioningXmlParser.parse((Path)this.provisioningFile);
        }
        catch (ProvisioningException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToParseConfiguration(this.provisioningFile, e);
        }
        this.manifestVersion = currentVersions;
    }

    public Path exportMetadataBundle(Path location) throws IOException {
        File file = location.toFile();
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(file));){
            int len;
            byte[] buffer;
            zos.putNextEntry(new ZipEntry("manifest.yaml"));
            try (FileInputStream fis = new FileInputStream(this.manifestFile.toFile());){
                buffer = new byte[1024];
                while ((len = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
            }
            zos.closeEntry();
            zos.putNextEntry(new ZipEntry("installer-channels.yaml"));
            fis = new FileInputStream(this.channelsFile.toFile());
            try {
                buffer = new byte[1024];
                while ((len = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
            }
            finally {
                fis.close();
            }
            zos.closeEntry();
            zos.putNextEntry(new ZipEntry(PROVISIONING_FILE_NAME));
            fis = new FileInputStream(this.provisioningFile.toFile());
            try {
                buffer = new byte[1024];
                while ((len = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
            }
            finally {
                fis.close();
            }
            zos.closeEntry();
        }
        return file.toPath();
    }

    public ChannelManifest getManifest() {
        return this.manifest;
    }

    public ProvisioningConfig getGalleonProvisioningConfig() {
        return this.galleonProvisioningConfig;
    }

    public void recordProvision(boolean overrideProsperoConfig) throws MetadataException {
        this.recordProvision(overrideProsperoConfig, true);
    }

    public void recordProvision(boolean overrideProsperoConfig, boolean gitRecord) throws MetadataException {
        try {
            ProsperoMetadataUtils.writeManifest((Path)this.manifestFile, (ChannelManifest)this.manifest);
        }
        catch (IOException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToSaveConfiguration(this.manifestFile, e);
        }
        if (!Files.exists(this.readmeFile, new LinkOption[0])) {
            try {
                ProsperoMetadataUtils.writeWarningReadme((Path)this.readmeFile);
            }
            catch (IOException e) {
                throw new MetadataException("Unable to create README.txt in installation", e);
            }
        }
        if (overrideProsperoConfig || !Files.exists(this.channelsFile, new LinkOption[0])) {
            this.writeProsperoConfig();
        }
        if (this.manifestVersion.isPresent()) {
            Path versionFile = this.base.resolve(".installation").resolve("manifest_version.yaml");
            try {
                ProsperoMetadataUtils.writeVersionRecord((Path)versionFile, (ManifestVersionRecord)this.manifestVersion.get());
            }
            catch (IOException e) {
                throw ProsperoLogger.ROOT_LOGGER.unableToWriteFile(versionFile, e);
            }
        }
        if (gitRecord) {
            this.gitStorage.record();
        }
    }

    private void writeProsperoConfig() throws MetadataException {
        try {
            ProsperoMetadataUtils.writeChannelsConfiguration((Path)this.channelsFile, this.getProsperoConfig().getChannels());
        }
        catch (IOException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToSaveConfiguration(this.channelsFile, e);
        }
    }

    public List<SavedState> getRevisions() throws MetadataException {
        return this.gitStorage.getRevisions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstallationMetadata getSavedState(SavedState savedState) throws MetadataException {
        Path revert = null;
        try {
            revert = this.gitStorage.revert(savedState);
            InstallationMetadata installationMetadata = InstallationMetadata.loadInstallation(revert);
            return installationMetadata;
        }
        finally {
            this.gitStorage.reset();
            if (revert != null && Files.exists(revert, new LinkOption[0])) {
                FileUtils.deleteQuietly((File)revert.toFile());
            }
        }
    }

    public InstallationChanges getChangesSince(SavedState savedState) throws MetadataException {
        return new InstallationChanges(this.gitStorage.getArtifactChanges(savedState), this.gitStorage.getChannelChanges(savedState));
    }

    public void setManifest(ChannelManifest resolvedChannel) {
        this.manifest = resolvedChannel;
    }

    public List<Artifact> getArtifacts() {
        return this.manifest.getStreams().stream().map(s -> this.streamToArtifact((Stream)s)).collect(Collectors.toList());
    }

    private DefaultArtifact streamToArtifact(Stream s) {
        return new DefaultArtifact(s.getGroupId(), s.getArtifactId(), "jar", s.getVersion());
    }

    public Artifact find(Artifact gav) {
        for (Stream stream : this.manifest.getStreams()) {
            if (!stream.getGroupId().equals(gav.getGroupId()) || !stream.getArtifactId().equals(gav.getArtifactId())) continue;
            return this.streamToArtifact(stream);
        }
        return null;
    }

    public ProsperoConfig getProsperoConfig() {
        return this.prosperoConfig;
    }

    public void updateProsperoConfig(ProsperoConfig config) throws MetadataException {
        this.prosperoConfig = config;
        this.writeProsperoConfig();
        this.gitStorage.recordConfigChange();
    }

    public Optional<ManifestVersionRecord> getManifestVersions() throws IOException {
        return this.manifestVersion;
    }

    @Override
    public void close() {
        if (this.gitStorage != null) {
            try {
                this.gitStorage.close();
            }
            catch (Exception e) {
                ProsperoLogger.ROOT_LOGGER.unableToCloseStore(e);
            }
        }
    }
}

