/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.galleon;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.layout.ProvisioningLayoutFactory;
import org.jboss.galleon.spec.FeaturePackPlugin;
import org.jboss.galleon.util.HashUtils;
import org.wildfly.channel.Channel;
import org.wildfly.channel.MavenArtifact;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.galleon.ArtifactCache;
import org.wildfly.prospero.galleon.GalleonEnvironment;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

public class GalleonFeaturePackAnalyzer {
    private final List<Channel> channels;
    private final MavenSessionManager mavenSessionManager;

    public GalleonFeaturePackAnalyzer(List<Channel> channels, MavenSessionManager mavenSessionManager) {
        this.channels = channels;
        this.mavenSessionManager = mavenSessionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheGalleonArtifacts(Path installedDir, ProvisioningConfig provisioningConfig) throws Exception {
        Path tempInstallationPath = Files.createTempDirectory("temp", new FileAttribute[0]);
        ArrayList<String> fps = new ArrayList<String>();
        GalleonEnvironment galleonEnv = null;
        ProvisioningLayoutFactory layoutFactory = null;
        ProvisioningLayout layout = null;
        try {
            galleonEnv = this.galleonEnvWithFpMapper(tempInstallationPath, fps);
            ProvisioningManager pm = galleonEnv.getProvisioningManager();
            layoutFactory = pm.getLayoutFactory();
            layout = layoutFactory.newConfigLayout(provisioningConfig);
            HashSet<String> pluginGavs = new HashSet<String>();
            for (Object fp : layout.getOrderedFeaturePacks()) {
                for (FeaturePackPlugin plugin : fp.getSpec().getPlugins().values()) {
                    pluginGavs.add(plugin.getLocation());
                }
            }
            ArtifactCache artifactCache = ArtifactCache.getInstance(installedDir);
            for (String pluginGav : pluginGavs) {
                String[] pluginLoc = pluginGav.split(":");
                MavenArtifact jar = galleonEnv.getChannelSession().resolveMavenArtifact(pluginLoc[0], pluginLoc[1], "jar", null, null);
                artifactCache.cache(jar);
            }
            for (String fp : fps) {
                String[] fpLoc = fp.split(":");
                MavenArtifact mavenArtifact = galleonEnv.getChannelSession().resolveMavenArtifact(fpLoc[0], fpLoc[1], "zip", null, null);
                artifactCache.cache(mavenArtifact);
            }
            try {
                MavenArtifact mavenArtifact = galleonEnv.getChannelSession().resolveMavenArtifact("org.wildfly.galleon-plugins", "wildfly-config-gen", "jar", null, null);
                artifactCache.cache(mavenArtifact);
            }
            catch (UnresolvedMavenArtifactException unresolvedMavenArtifactException) {
                // empty catch block
            }
            this.updateHashes(installedDir);
        }
        finally {
            if (layout != null) {
                layout.close();
            }
            if (layoutFactory != null) {
                layoutFactory.close();
            }
            if (galleonEnv != null) {
                galleonEnv.close();
            }
            FileUtils.deleteQuietly((File)tempInstallationPath.toFile());
        }
    }

    private void updateHashes(Path installedDir) throws IOException {
        Path hashesFile = installedDir.resolve(".galleon").resolve("hashes").resolve(ArtifactCache.CACHE_FOLDER).resolve("hashes");
        Path cachesDir = installedDir.resolve(ArtifactCache.CACHE_FOLDER);
        StringBuilder sb = new StringBuilder();
        for (File file : cachesDir.toFile().listFiles()) {
            sb.append(file.getName()).append(System.lineSeparator());
            sb.append(HashUtils.bytesToHexString((byte[])HashUtils.hashPath((Path)file.toPath()))).append(System.lineSeparator());
        }
        Files.writeString(hashesFile, (CharSequence)sb.toString(), new OpenOption[0]);
    }

    public List<String> getFeaturePacks(ProvisioningConfig provisioningConfig) throws IOException, ProvisioningException, OperationException {
        Path tempInstallationPath = Files.createTempDirectory("temp", new FileAttribute[0]);
        ArrayList<String> fps = new ArrayList<String>();
        try {
            GalleonEnvironment galleonEnv = this.galleonEnvWithFpMapper(tempInstallationPath, fps);
            try {
                ProvisioningManager pm = galleonEnv.getProvisioningManager();
                ProvisioningLayoutFactory layoutFactory = pm.getLayoutFactory();
                layoutFactory.newConfigLayout(provisioningConfig).close();
                ArrayList<String> arrayList = fps;
                if (galleonEnv != null) {
                    galleonEnv.close();
                }
                return arrayList;
            }
            catch (Throwable throwable) {
                if (galleonEnv != null) {
                    try {
                        galleonEnv.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            FileUtils.deleteQuietly((File)tempInstallationPath.toFile());
        }
    }

    private GalleonEnvironment galleonEnvWithFpMapper(Path tempInstallationPath, List<String> fps) throws ProvisioningException, OperationException {
        GalleonEnvironment galleonEnv = GalleonEnvironment.builder(tempInstallationPath, this.channels, this.mavenSessionManager).setConsole(null).setResolvedFpTracker(fps::add).build();
        return galleonEnv;
    }
}

