/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.logging.Logger;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.actions.ApplyCandidateAction;
import org.wildfly.prospero.actions.ProsperoManifestVersionResolver;
import org.wildfly.prospero.api.InstallationMetadata;
import org.wildfly.prospero.api.SavedState;
import org.wildfly.prospero.api.exceptions.ArtifactResolutionException;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.galleon.ArtifactCache;
import org.wildfly.prospero.galleon.GalleonEnvironment;
import org.wildfly.prospero.galleon.GalleonFeaturePackAnalyzer;
import org.wildfly.prospero.galleon.GalleonUtils;
import org.wildfly.prospero.licenses.LicenseManager;
import org.wildfly.prospero.metadata.ManifestVersionRecord;
import org.wildfly.prospero.model.ProsperoConfig;
import org.wildfly.prospero.updates.MarkerFile;
import org.wildfly.prospero.updates.UpdateSet;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

class PrepareCandidateAction
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger((String)PrepareCandidateAction.class.getName());
    private final InstallationMetadata metadata;
    private final ProsperoConfig prosperoConfig;
    private final MavenSessionManager mavenSessionManager;
    private final Path installDir;

    PrepareCandidateAction(Path installDir, MavenSessionManager mavenSessionManager, ProsperoConfig prosperoConfig) throws OperationException {
        this.metadata = InstallationMetadata.loadInstallation(installDir);
        this.installDir = installDir;
        this.prosperoConfig = prosperoConfig;
        this.mavenSessionManager = mavenSessionManager;
    }

    boolean buildCandidate(Path targetDir, GalleonEnvironment galleonEnv, ApplyCandidateAction.Type operation, ProvisioningConfig config) throws ProvisioningException, OperationException {
        return this.buildCandidate(targetDir, galleonEnv, operation, config, new UpdateSet(Collections.emptyList()));
    }

    boolean buildCandidate(Path targetDir, GalleonEnvironment galleonEnv, ApplyCandidateAction.Type operation, ProvisioningConfig config, UpdateSet updateSet) throws ProvisioningException, OperationException {
        return this.buildCandidate(targetDir, galleonEnv, operation, config, updateSet, this::getManifestVersionRecord);
    }

    boolean buildCandidate(Path targetDir, GalleonEnvironment galleonEnv, ApplyCandidateAction.Type operation, ProvisioningConfig config, UpdateSet updateSet, Function<List<Channel>, Optional<ManifestVersionRecord>> manifestVersionRecordSupplier) throws ProvisioningException, OperationException {
        Objects.requireNonNull(manifestVersionRecordSupplier);
        this.doBuildUpdate(targetDir, galleonEnv, config, manifestVersionRecordSupplier);
        try {
            SavedState savedState = this.metadata.getRevisions().get(0);
            new MarkerFile(savedState.getName(), operation).write(targetDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private void doBuildUpdate(Path targetDir, GalleonEnvironment galleonEnv, ProvisioningConfig provisioningConfig, Function<List<Channel>, Optional<ManifestVersionRecord>> manifestVersionResolver) throws ProvisioningException, OperationException {
        ProvisioningManager provMgr = galleonEnv.getProvisioningManager();
        try {
            GalleonUtils.executeGalleon(options -> {
                options.put("export-system-paths", "true");
                provMgr.provision(provisioningConfig, options);
            }, this.mavenSessionManager.getProvisioningRepo().toAbsolutePath());
        }
        catch (UnresolvedMavenArtifactException e) {
            throw new ArtifactResolutionException(ProsperoLogger.ROOT_LOGGER.unableToResolve(), e, e.getUnresolvedArtifacts(), e.getAttemptedRepositories(), this.mavenSessionManager.isOffline());
        }
        Optional<ManifestVersionRecord> manifestRecord = manifestVersionResolver.apply(galleonEnv.getChannels());
        if (LOG.isTraceEnabled()) {
            LOG.tracef("Recording manifests: %s", (Object)manifestRecord.orElse(new ManifestVersionRecord()));
        }
        manifestRecord.ifPresent(rec -> this.cacheManifests((ManifestVersionRecord)rec, targetDir));
        this.writeProsperoMetadata(targetDir, galleonEnv.getChannelSession().getRecordedChannel(), this.prosperoConfig.getChannels(), manifestRecord);
        try {
            GalleonFeaturePackAnalyzer galleonFeaturePackAnalyzer = new GalleonFeaturePackAnalyzer(galleonEnv.getChannels(), this.mavenSessionManager);
            galleonFeaturePackAnalyzer.cacheGalleonArtifacts(targetDir, provisioningConfig);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            new LicenseManager().copyIfExists(this.installDir, targetDir);
        }
        catch (IOException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToWriteFile(this.installDir.resolve("licenses"), e);
        }
    }

    private Optional<ManifestVersionRecord> getManifestVersionRecord(List<Channel> channels) {
        ProsperoManifestVersionResolver manifestResolver = new ProsperoManifestVersionResolver(this.mavenSessionManager);
        try {
            return Optional.of(manifestResolver.getCurrentVersions(channels));
        }
        catch (IOException e) {
            ProsperoLogger.ROOT_LOGGER.debug("Unable to retrieve current manifest versions", e);
            return Optional.empty();
        }
    }

    private void cacheManifests(ManifestVersionRecord manifestRecord, Path installDir) {
        try {
            ArtifactCache.getInstance(installDir).cache(manifestRecord, this.mavenSessionManager.getResolvedArtifactVersions());
        }
        catch (IOException e) {
            ProsperoLogger.ROOT_LOGGER.debug("Unable to record manifests in the internal cache", e);
        }
    }

    @Override
    public void close() {
        this.metadata.close();
    }

    private void writeProsperoMetadata(Path home, ChannelManifest manifest, List<Channel> channels, Optional<ManifestVersionRecord> manifestVersions) throws MetadataException {
        try (InstallationMetadata installationMetadata = InstallationMetadata.newInstallation(home, manifest, new ProsperoConfig(channels), manifestVersions);){
            installationMetadata.recordProvision(true, false);
        }
    }
}

