/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.util.PathsUtils;
import org.jboss.galleon.xml.ProvisioningXmlParser;
import org.wildfly.channel.Repository;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.actions.ApplyCandidateAction;
import org.wildfly.prospero.actions.InstallFolderUtils;
import org.wildfly.prospero.actions.PrepareCandidateAction;
import org.wildfly.prospero.api.Console;
import org.wildfly.prospero.api.InstallationChanges;
import org.wildfly.prospero.api.InstallationMetadata;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.api.SavedState;
import org.wildfly.prospero.api.TemporaryRepositoriesHandler;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.galleon.GalleonEnvironment;
import org.wildfly.prospero.model.ProsperoConfig;
import org.wildfly.prospero.updates.UpdateSet;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

public class InstallationHistoryAction {
    private final Path installation;
    private final Console console;

    public InstallationHistoryAction(Path installation, Console console) {
        this.installation = InstallFolderUtils.toRealPath(installation);
        this.console = console;
    }

    public InstallationChanges compare(SavedState savedState) throws MetadataException {
        ProsperoLogger.ROOT_LOGGER.historyDetails(savedState.getName(), this.installation);
        InstallationMetadata installationMetadata = InstallationMetadata.loadInstallation(this.installation);
        InstallationHistoryAction.verifyStateExists(savedState, installationMetadata);
        return installationMetadata.getChangesSince(savedState);
    }

    public List<SavedState> getRevisions() throws MetadataException {
        ProsperoLogger.ROOT_LOGGER.listHistory(this.installation);
        try (InstallationMetadata installationMetadata = InstallationMetadata.loadInstallation(this.installation);){
            List<SavedState> list = installationMetadata.getRevisions();
            return list;
        }
    }

    public void rollback(SavedState savedState, MavenOptions mavenOptions, List<Repository> overrideRepositories) throws OperationException, ProvisioningException {
        Path tempDirectory = null;
        try {
            ProsperoLogger.ROOT_LOGGER.revertStarted(this.installation, savedState.getName());
            tempDirectory = Files.createTempDirectory("revert-candidate", new FileAttribute[0]);
            if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                ProsperoLogger.ROOT_LOGGER.temporaryCandidateFolder(tempDirectory);
            }
            this.prepareRevert(savedState, mavenOptions, overrideRepositories, tempDirectory);
            new ApplyCandidateAction(this.installation, tempDirectory).applyUpdate(ApplyCandidateAction.Type.REVERT);
            ProsperoLogger.ROOT_LOGGER.revertCompleted(this.installation, savedState.getName());
        }
        catch (IOException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToCreateTemporaryDirectory(e);
        }
        finally {
            if (tempDirectory != null) {
                FileUtils.deleteQuietly((File)tempDirectory.toFile());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareRevert(SavedState savedState, MavenOptions mavenOptions, List<Repository> overrideRepositories, Path targetDir) throws OperationException, ProvisioningException {
        if (Files.exists(targetDir, new LinkOption[0])) {
            InstallFolderUtils.verifyIsEmptyDir(targetDir);
        } else {
            InstallFolderUtils.verifyIsWritable(targetDir);
        }
        targetDir = InstallFolderUtils.toRealPath(targetDir);
        try (InstallationMetadata metadata = InstallationMetadata.loadInstallation(this.installation);){
            ProsperoLogger.ROOT_LOGGER.revertCandidateStarted(this.installation);
            InstallationHistoryAction.verifyStateExists(savedState, metadata);
            InstallationHistoryAction.verifyStateIsNotTip(savedState, metadata);
            MavenSessionManager mavenSessionManager = new MavenSessionManager(mavenOptions);
            try (InstallationMetadata revertMetadata = metadata.getSavedState(savedState);){
                ProsperoConfig prosperoConfig = new ProsperoConfig(TemporaryRepositoriesHandler.overrideRepositories(revertMetadata.getProsperoConfig().getChannels(), overrideRepositories));
                try (GalleonEnvironment galleonEnv = GalleonEnvironment.builder(targetDir, prosperoConfig.getChannels(), mavenSessionManager).setConsole(this.console).setRestoreManifest(revertMetadata.getManifest(), revertMetadata.getManifestVersions().orElse(null)).setSourceServerPath(this.installation).build();
                     PrepareCandidateAction prepareCandidateAction = new PrepareCandidateAction(this.installation, mavenSessionManager, revertMetadata.getProsperoConfig());){
                    System.setProperty("maven.repo.local", mavenSessionManager.getProvisioningRepo().toAbsolutePath().toString());
                    ProvisioningConfig provisioningConfig = revertMetadata.getRecordedProvisioningConfig();
                    if (provisioningConfig == null) {
                        ProsperoLogger.ROOT_LOGGER.fallbackToGalleonProvisioningDefinition();
                        provisioningConfig = ProvisioningXmlParser.parse((Path)PathsUtils.getProvisioningXml((Path)this.installation));
                    }
                    prepareCandidateAction.buildCandidate(targetDir, galleonEnv, ApplyCandidateAction.Type.REVERT, provisioningConfig, UpdateSet.EMPTY, channels -> revertMetadata.getManifestVersions());
                }
                ProsperoLogger.ROOT_LOGGER.revertCandidateCompleted(targetDir);
            }
            finally {
                System.clearProperty("maven.repo.local");
            }
        }
    }

    private static void verifyStateExists(SavedState savedState, InstallationMetadata metadata) throws MetadataException {
        if (metadata.getRevisions().stream().noneMatch(s -> s.getName().equals(savedState.getName()))) {
            throw ProsperoLogger.ROOT_LOGGER.savedStateNotFound(savedState.getName());
        }
    }

    private static void verifyStateIsNotTip(SavedState savedState, InstallationMetadata metadata) throws MetadataException {
        Optional first = metadata.getRevisions().stream().findFirst();
        if (first.isPresent() && ((SavedState)first.get()).getName().equals(savedState.getName())) {
            throw ProsperoLogger.ROOT_LOGGER.cannotRevertToTip(savedState.getName());
        }
    }
}

