/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.wildfly.prospero.galleon.FeaturePackLocationParser;

class ProvisioningConfigManipulator {
    private final ProvisioningConfig.Builder configBuilder;

    public ProvisioningConfigManipulator(ProvisioningConfig.Builder configBuilder) {
        this.configBuilder = configBuilder;
    }

    int removeFeaturePackDefinition(String fpName) throws ProvisioningException {
        FeaturePackLocation.ProducerSpec depFpl = FeaturePackLocationParser.resolveFpl(fpName).getProducer();
        int fpIndex = this.configBuilder.getFeaturePackDepIndex(depFpl.getLocation());
        this.configBuilder.removeFeaturePackDep(depFpl.getLocation());
        return fpIndex;
    }

    int convertToTransitiveDep(String fpName, ProvisioningConfig originalConfig) throws ProvisioningException {
        FeaturePackLocation.ProducerSpec depFpl = FeaturePackLocationParser.resolveFpl(fpName).getProducer();
        FeaturePackConfig oldConfig = originalConfig.getFeaturePackDep(depFpl);
        int fpIndex = this.configBuilder.getFeaturePackDepIndex(depFpl.getLocation());
        this.configBuilder.removeFeaturePackDep(oldConfig.getLocation());
        FeaturePackConfig.Builder newFpBuilder = FeaturePackConfig.transitiveBuilder((FeaturePackLocation)oldConfig.getLocation());
        ProvisioningConfigManipulator.copyFeaturePackConfig(newFpBuilder, oldConfig);
        this.configBuilder.addFeaturePackDep(newFpBuilder.build());
        return fpIndex;
    }

    static void copyFeaturePackConfig(FeaturePackConfig.Builder configBuilder, FeaturePackConfig originalConfig) throws ProvisioningDescriptionException {
        if (originalConfig.getInheritPackages() != null) {
            configBuilder.setInheritPackages(originalConfig.getInheritPackages().booleanValue());
        }
        for (String excludedPackage : originalConfig.getExcludedPackages()) {
            configBuilder.excludePackage(excludedPackage);
        }
        for (String includedPackage : originalConfig.getIncludedPackages()) {
            configBuilder.includePackage(includedPackage);
        }
        for (FeaturePackLocation.FPID patch : originalConfig.getPatches()) {
            configBuilder.addPatch(patch);
        }
        if (originalConfig.getInheritConfigs() != null) {
            configBuilder.setInheritConfigs(originalConfig.getInheritConfigs().booleanValue());
        }
        configBuilder.setInheritModelOnlyConfigs(originalConfig.isInheritModelOnlyConfigs());
        for (String model : originalConfig.getFullModelsIncluded()) {
            configBuilder.includeConfigModel(model);
        }
        for (String model : originalConfig.getFullModelsExcluded().keySet()) {
            configBuilder.excludeConfigModel(model);
        }
        for (ConfigId config : originalConfig.getIncludedConfigs()) {
            configBuilder.includeDefaultConfig(config);
        }
        for (ConfigId config : originalConfig.getExcludedConfigs()) {
            configBuilder.excludeDefaultConfig(config);
        }
        for (ConfigId config : originalConfig.getDefinedConfigs()) {
            configBuilder.addConfig((ConfigModel)config);
        }
    }
}

