/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.galleon;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.jboss.logging.Logger;
import org.wildfly.channel.Repository;
import org.wildfly.channel.maven.VersionResolverFactory;
import org.wildfly.prospero.galleon.GalleonEnvironment;

class MavenProxyHandler {
    private static final Logger LOG = Logger.getLogger((String)GalleonEnvironment.class.getName());

    MavenProxyHandler() {
    }

    public static RemoteRepository addProxySettings(Repository r) {
        RemoteRepository.Builder builder = new RemoteRepository.Builder(r.getId(), "default", r.getUrl()).setPolicy(VersionResolverFactory.DEFAULT_REPOSITORY_POLICY);
        MavenProxyHandler.getDefinedProxy(r).ifPresent(arg_0 -> ((RemoteRepository.Builder)builder).setProxy(arg_0));
        return builder.build();
    }

    private static Optional<Proxy> getDefinedProxy(Repository r) {
        URI repositoryUri;
        try {
            repositoryUri = new URI(r.getUrl());
            if (repositoryUri.getScheme() == null || !repositoryUri.getScheme().equals("http") && !repositoryUri.getScheme().equals("https")) {
                LOG.debugf("Skipping proxy configuration for %s - scheme not supported", (Object)r.getUrl());
                return Optional.empty();
            }
            if (repositoryUri.getHost() == null) {
                LOG.infof("Skipping proxy configuration for %s - unable to find host", (Object)r.getUrl());
                return Optional.empty();
            }
        }
        catch (URISyntaxException e) {
            LOG.infof("Skipping proxy configuration for %s - unable to parse address", (Object)r.getUrl());
            return Optional.empty();
        }
        return ProxySelector.getDefault().select(repositoryUri).stream().filter(p -> p.type() == Proxy.Type.HTTP).map(java.net.Proxy::address).map(InetSocketAddress.class::cast).map(a -> {
            String username = MavenProxyHandler.getProperty(repositoryUri.getScheme(), "proxyUser");
            String password = MavenProxyHandler.getProperty(repositoryUri.getScheme(), "proxyPassword");
            return MavenProxyHandler.createProxySettings(a, username, password);
        }).findFirst();
    }

    private static String getProperty(String scheme, String suffix) {
        if (scheme.equals("https")) {
            return System.getProperty("https." + suffix);
        }
        if (scheme.equals("http")) {
            return System.getProperty("http." + suffix);
        }
        return null;
    }

    private static Proxy createProxySettings(InetSocketAddress proxyAddress, String username, String password) {
        if (username != null && password != null) {
            if (LOG.isTraceEnabled()) {
                LOG.tracef("Creating authenticator for the proxy", new Object[0]);
            }
            Authentication authentication = new AuthenticationBuilder().addUsername(username).addPassword(password).build();
            return new Proxy(null, proxyAddress.getHostName(), proxyAddress.getPort(), authentication);
        }
        return new Proxy(null, proxyAddress.getHostName(), proxyAddress.getPort());
    }
}

