/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.licenses;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Objects;

public class License {
    private final String name;
    private final String fpGav;
    private final String text;
    private final String title;

    @JsonCreator
    public License(@JsonProperty(value="name") String name, @JsonProperty(value="fpGAV") String fpGav, @JsonProperty(value="title") String title, @JsonProperty(value="text") String text) {
        this.name = name;
        this.fpGav = fpGav;
        this.title = title.trim();
        this.text = text.trim();
    }

    public static List<License> readLicenses(URL url) throws IOException {
        YAMLFactory yamlFactory = new YAMLFactory();
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)yamlFactory);
        return (List)objectMapper.readValue(url, (TypeReference)new TypeReference<List<License>>(){});
    }

    public static void writeLicenses(List<License> licenses, File targetFile) throws IOException {
        YAMLFactory yamlFactory = new YAMLFactory();
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)yamlFactory);
        objectMapper.writeValue(targetFile, licenses);
    }

    public String getName() {
        return this.name;
    }

    public String getFpGav() {
        return this.fpGav;
    }

    public String getTitle() {
        return this.title;
    }

    public String getText() {
        return this.text;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        License license = (License)o;
        return Objects.equals(this.name, license.name) && Objects.equals(this.fpGav, license.fpGav) && Objects.equals(this.text, license.text) && Objects.equals(this.title, license.title);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fpGav, this.text, this.title);
    }
}

