/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero;

import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.wildfly.channel.InvalidChannelMetadataException;
import org.wildfly.prospero.actions.FeaturesAddAction;
import org.wildfly.prospero.api.exceptions.ArtifactPromoteException;
import org.wildfly.prospero.api.exceptions.ChannelDefinitionException;
import org.wildfly.prospero.api.exceptions.InvalidUpdateCandidateException;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.NoChannelException;
import org.wildfly.prospero.api.exceptions.ProvisioningRuntimeException;

@MessageLogger(projectCode="PRSP")
public interface ProsperoLogger
extends BasicLogger {
    public static final ProsperoLogger ROOT_LOGGER = (ProsperoLogger)Logger.getMessageLogger(ProsperoLogger.class, (String)"org.wildfly.prospero");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Getting details of %s of %s")
    public void historyDetails(String var1, Path var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2, value="Listing history of %s")
    public void listHistory(Path var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3, value="Reverting %s to %s")
    public void revertStarted(Path var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=4, value="Reverted %s to %s")
    public void revertCompleted(Path var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=5, value="Building revert candidate for %s")
    public void revertCandidateStarted(Path var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=6, value="Revert candidate generated in %s")
    public void revertCandidateCompleted(Path var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=7, value="Created temporary candidate folder %s")
    public void temporaryCandidateFolder(Path var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=8, value="Performing update of %s")
    public void performUpdateStarted(Path var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=9, value="Aborting update - no updates found for %s")
    public void noUpdatesFound(Path var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10, value="Building update candidate for %s")
    public void updateCandidateStarted(Path var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11, value="Update candidate generated in %s")
    public void updateCandidateCompleted(Path var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=12, value="Checking available updates")
    public void checkingUpdates();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=13, value="Found %d updates")
    public void updatesFound(int var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=14, value="Adding channel %s")
    public void addingChannel(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15, value="Channel %s already exists")
    public void existingChannel(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=16, value="Channel %s added")
    public void channelAdded(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17, value="Removing channel %s")
    public void removingChannel(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=19, value="Channel removed %s")
    public void channelRemoved(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=20, value="Updating channel %s as %s")
    public void updatingChannel(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=21, value="Channel %s updated")
    public void channelUpdated(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=22, value="Listing subscribed channels")
    public void listChannels();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=23, value="Starting phase: [%s] %s")
    public void startedPhase(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=24, value="Completed phase: [%s] %s")
    public void completedPhase(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=25, value="Applying %s candidate from %s")
    public void applyingCandidate(String var1, Path var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=26, value="Changed artifacts [%s]")
    public void candidateChanges(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=27, value="No conflicts found.")
    public void noCandidateConflicts();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=28, value="File conflicts found: [%s]")
    public void candidateConflicts(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=29, value="%s candidate applied to %s")
    public void candidateApplied(String var1, Path var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=30, value="Starting provisioning into %s")
    public void startingProvision(Path var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=31, value="Server provisioned into %s")
    public void provisioningComplete(Path var1);

    @Message(id=200, value="Aborting update - the server appears to be running.")
    public ProvisioningException serverRunningError();

    @Message(id=201, value="Given path '%s' is a regular file. An empty directory or a non-existing path must be given.")
    public IllegalArgumentException dirMustBeDirectory(Path var1);

    @Message(id=202, value="Invalid channel manifest definition")
    public ChannelDefinitionException invalidManifest(@Cause InvalidChannelMetadataException var1);

    @Message(id=203, value="Can't install the server into a non empty directory '%s'.")
    public IllegalArgumentException cannotInstallIntoNonEmptyDirectory(Path var1);

    @Message(id=204, value="Installation dir '%s' doesn't exist")
    public IllegalArgumentException installationDirDoesNotExist(Path var1);

    @Message(id=205, value="Installation dir '%s' already exists")
    public ProvisioningException installationDirAlreadyExists(Path var1);

    @Message(id=206, value="Given configuration doesn't reference any channel or channel manifest.")
    public NoChannelException noChannelReference();

    @Message(id=207, value="Invalid channel: Channel '%s' doesn't reference a manifest.")
    public NoChannelException noChannelManifestReference(String var1);

    @Message(id=208, value="Pre-defined FPL [%s] doesn't specify any channels and no explicit channels were given.")
    public NoChannelException fplDefinitionDoesntContainChannel(String var1);

    @Message(id=209, value="Channel '%s' is already present.")
    public MetadataException channelExists(String var1);

    @Message(id=210, value="Channel with name [%s] cannot be found.")
    public MetadataException channelNotFound(String var1);

    @Message(id=211, value="Channel name cannot be empty.")
    public MetadataException emptyChannelName();

    @Message(id=212, value="Promoting artifacts to %s:")
    public String promotingArtifacts(URL var1);

    @Message(id=213, value="Unable to parse server configuration at '%s'")
    public MetadataException unableToParseConfiguration(Path var1, @Cause Throwable var2);

    @Message(id=214, value="Unable to parse server configuration at '%s'")
    public MetadataException unableToParseConfigurationUri(URI var1, @Cause Throwable var2);

    @Message(id=215, value="Unable to read file at [%s]")
    public MetadataException unableToReadFile(Path var1, @Cause Exception var2);

    @Message(id=216, value="The installation at %s is not a valid update for %s")
    public InvalidUpdateCandidateException invalidUpdateCandidate(Path var1, Path var2);

    @Message(id=217, value="Unable to save server configuration at '%s'")
    public MetadataException unableToSaveConfiguration(Path var1, @Cause Exception var2);

    @Message(id=218, value="Unable to close the update store.")
    @LogMessage(level=Logger.Level.WARN)
    public void unableToCloseStore(@Cause Exception var1);

    @Message(id=219, value="Unable to create history store at [%s]")
    public MetadataException unableToCreateHistoryStorage(Path var1, @Cause Exception var2);

    @Message(id=220, value="Provided metadata bundle [%s] is missing one or more entries")
    public IllegalArgumentException incompleteMetadataBundle(Path var1);

    @Message(id=221, value="Unable to write file at [%s]")
    public MetadataException unableToWriteFile(Path var1, @Cause Exception var2);

    @Message(id=222, value="Path `%s` does not contain a server installation provisioned by prospero.")
    public IllegalArgumentException invalidInstallationDir(Path var1);

    @Message(id=223, value="Unable to access history store at [%s]")
    public MetadataException unableToAccessHistoryStorage(Path var1, @Cause Exception var2);

    @Message(id=224, value="Unable to download file")
    public MetadataException unableToDownloadFile(@Cause Exception var1);

    @Message(id=225, value="Unable to create temporary cache for provisioning cache folder.")
    public ProvisioningException unableToCreateCache(@Cause Exception var1);

    @Message(id=226, value="Failed to initiate maven repository system")
    public ProvisioningRuntimeException failedToInitMaven(@Cause Throwable var1);

    @Message(id=227, value="Unable to find required stream definitions")
    public String streamNotFound();

    @Message(id=228, value="Unable to resolve artifact")
    public String unableToResolve();

    @Message(id=229, value="Invalid URL [%s]")
    public IllegalArgumentException invalidUrl(String var1, @Cause Exception var2);

    @Message(id=230, value="Incomplete configuration: If the FPL is not one of predefined names (%s) a channel must be given.")
    public IllegalArgumentException predefinedFplOrChannelRequired(String var1);

    @Message(id=231, value="Incomplete configuration: neither FPL nor Galleon provisioning config was given.")
    public IllegalArgumentException fplNorGalleonConfigWereSet();

    @Message(id=232, value="Found unexpected artifact [%s]")
    public ProvisioningRuntimeException unexpectedArtifact(String var1);

    @Message(id=233, value="File already exists [%s]")
    public IllegalArgumentException fileAlreadyExists(Path var1);

    @Message(id=234, value="Promoting to non-file repositories is not currently supported")
    public IllegalArgumentException unsupportedPromotionTarget();

    @Message(id=235, value="Wrong format of custom channel version [%s]")
    public IllegalArgumentException wrongVersionFormat(String var1);

    @Message(id=236, value="Custom channel version exceeded limit [%s]")
    public IllegalArgumentException versionLimitExceeded(String var1);

    @Message(id=237, value="Cannot create bundle without artifacts.")
    public IllegalArgumentException noArtifactsToPackage();

    @Message(id=238, value="Channel reference has to use Maven GA.")
    public IllegalArgumentException nonMavenChannelRef();

    @Message(id=239, value="Unable to promote artifacts to [%s].")
    public ArtifactPromoteException unableToPromote(URL var1, @Cause Exception var2);

    @Message(id=240, value="Unable to parse the customization bundle [%s].")
    public ArtifactPromoteException unableToParseCustomizationBundle(Path var1, @Cause Exception var2);

    @Message(id=241, value="At least one repository must be set when using the manifest option.")
    public IllegalArgumentException repositoriesMustBeSetWithManifest();

    @Message(id=242, value="Out file [%s] exists already!")
    public IllegalArgumentException outFileExists(Path var1);

    @Message(id=243, value="Installation metadata is exported to [%s].")
    public String installationExported(Path var1);

    @Message(id=244, value="Malformed URL in substituted value : %s from %s")
    public MetadataException invalidPropertySubstitutionValue(String var1, String var2);

    @Message(id=245, value="The requested state %s does not exist in server's history.")
    public MetadataException savedStateNotFound(String var1);

    @Message(id=246, value="Unable to create temporary directory")
    public ProvisioningException unableToCreateTemporaryDirectory(@Cause Throwable var1);

    @Message(id=247, value="Invalid channel definition")
    public ChannelDefinitionException invalidChannel(@Cause InvalidChannelMetadataException var1);

    @Message(id=248, value="Provided feature pack location has invalid format `%s`. Expected <groupId:artifactId>")
    public String invalidFpl(String var1);

    @Message(id=249, value="Unrecognized profile %s, did you mean one of [%s]")
    public IllegalArgumentException unknownInstallationProfile(String var1, String var2);

    @Message(id=250, value="Invalid candidate marker file [%s]. Missing required field [%s].")
    public MetadataException invalidCandidateMarker(Path var1, String var2);

    @Message(id=251, value="Unexpected operation type [%s] in the candidate marker file.")
    public IllegalArgumentException invalidMarkerFileOperation(String var1);

    @Message(id=252, value="Invalid metadata bundle [%s]. Expected a ZIP archive containing installation configuration.")
    public IllegalArgumentException invalidMetadataBundle(Path var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=253, value="Unable to retrieve stored provisioning configuration. Falling back to current configuration")
    public void fallbackToGalleonProvisioningDefinition();

    @Message(id=254, value="Multiple models available in the selected feature pack, please select one.")
    public String noDefaultModel();

    @Message(id=255, value="Chosen feature pack does not support model %s. Please choose one of supported models.")
    public String modelNotFoundInFeaturePack(String var1);

    @Message(id=256, value="The feature pack doesn't define requested layers: [%s]")
    public String layerNotFoundInFeaturePack(String var1);

    @Message(id=257, value="Feature pack %s is already provisioned")
    public FeaturesAddAction.FeaturePackAlreadyInstalledException featurePackAlreadyInstalled(FeaturePackLocation var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=258, value="Adding a feature pack [%s] with configuration %s and layers [%s]")
    public void addingFeaturePack(FeaturePackLocation var1, String var2, String var3);

    @Message(id=259, value="Requested configuration %s/%s is not available in the feature packs.")
    public String galleonConfigNotFound(String var1, String var2);

    @Message(id=260, value="The selected folder %s cannot be created.")
    public IllegalArgumentException dirMustBeWritable(Path var1);
}

