/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.eclipse.aether.artifact.Artifact;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.diff.FsDiff;
import org.jboss.galleon.diff.FsEntry;
import org.jboss.galleon.layout.SystemPaths;
import org.jboss.galleon.util.HashUtils;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.PathsUtils;
import org.jboss.logging.Logger;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.api.ArtifactChange;
import org.wildfly.prospero.api.FileConflict;
import org.wildfly.prospero.api.InstallationMetadata;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.api.SavedState;
import org.wildfly.prospero.api.exceptions.InvalidUpdateCandidateException;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.galleon.ArtifactCache;
import org.wildfly.prospero.galleon.GalleonEnvironment;
import org.wildfly.prospero.installation.git.GitStorage;
import org.wildfly.prospero.metadata.ProsperoMetadataUtils;
import org.wildfly.prospero.updates.CandidateProperties;
import org.wildfly.prospero.updates.CandidatePropertiesParser;
import org.wildfly.prospero.updates.MarkerFile;
import org.wildfly.prospero.updates.UpdateSet;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

public class ApplyCandidateAction {
    public static final Path STANDALONE_STARTUP_MARKER = Path.of("standalone", "tmp", "startup-marker");
    public static final Path DOMAIN_STARTUP_MARKER = Path.of("domain", "tmp", "startup-marker");
    public static final String CANDIDATE_CHANNEL_NAME_LIST = "candidate_properties.yaml";
    private final Path updateDir;
    private final Path installationDir;
    private final SystemPaths systemPaths;
    private static final Logger log = Logger.getLogger(ApplyCandidateAction.class);

    public ApplyCandidateAction(Path installationDir, Path updateDir) throws ProvisioningException, OperationException {
        this.updateDir = updateDir;
        this.installationDir = installationDir;
        try {
            this.systemPaths = SystemPaths.load((Path)updateDir);
        }
        catch (IOException ex) {
            throw new ProvisioningException((Throwable)ex);
        }
        if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
            ProsperoLogger.ROOT_LOGGER.debug("System paths " + this.systemPaths.getPaths());
        }
    }

    public List<FileConflict> applyUpdate(Type operation) throws ProvisioningException, OperationException {
        if (ValidationResult.OK != this.verifyCandidate(operation)) {
            InvalidUpdateCandidateException ex = ProsperoLogger.ROOT_LOGGER.invalidUpdateCandidate(this.updateDir, this.installationDir);
            ProsperoLogger.ROOT_LOGGER.warn("", ex);
            throw ex;
        }
        if (this.targetServerIsRunning()) {
            ProvisioningException ex = ProsperoLogger.ROOT_LOGGER.serverRunningError();
            ProsperoLogger.ROOT_LOGGER.warn("", ex);
            throw ex;
        }
        FsDiff diffs = this.findChanges();
        try {
            ProsperoLogger.ROOT_LOGGER.applyingCandidate(operation.text.toLowerCase(Locale.ROOT), this.updateDir);
            ProsperoLogger.ROOT_LOGGER.candidateChanges(this.findUpdates().getArtifactUpdates().stream().map(ArtifactChange::prettyPrint).collect(Collectors.joining("; ")));
            List<FileConflict> conflicts = this.doApplyUpdate(diffs);
            if (conflicts.isEmpty()) {
                ProsperoLogger.ROOT_LOGGER.noCandidateConflicts();
            } else {
                ProsperoLogger.ROOT_LOGGER.candidateConflicts(conflicts.stream().map(FileConflict::prettyPrint).collect(Collectors.joining("; ")));
                for (FileConflict conflict : conflicts) {
                    ProsperoLogger.ROOT_LOGGER.info(conflict.prettyPrint());
                }
            }
            this.updateMetadata(operation);
            ProsperoLogger.ROOT_LOGGER.candidateApplied(operation.text, this.installationDir);
            return conflicts;
        }
        catch (IOException ex) {
            throw new ProvisioningException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ValidationResult verifyCandidate(Type operation) throws InvalidUpdateCandidateException, MetadataException {
        Path updateMarkerPath = this.updateDir.resolve(MarkerFile.UPDATE_MARKER_FILE);
        if (!Files.exists(updateMarkerPath, new LinkOption[0])) {
            if (!ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) return ValidationResult.NOT_CANDIDATE;
            ProsperoLogger.ROOT_LOGGER.debugf("The candidate [%s] doesn't have a marker file", this.updateDir);
            return ValidationResult.NOT_CANDIDATE;
        }
        try {
            MarkerFile marker = MarkerFile.read(this.updateDir);
            String hash = marker.getState();
            try (InstallationMetadata metadata = InstallationMetadata.loadInstallation(this.installationDir);){
                if (!metadata.getRevisions().get(0).getName().equals(hash)) {
                    if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                        ProsperoLogger.ROOT_LOGGER.debugf("The installation state has changed from the candidate [%s].", this.updateDir);
                    }
                    ValidationResult validationResult = ValidationResult.STALE;
                    return validationResult;
                }
            }
            if (marker.getOperation() == operation) return ValidationResult.OK;
            if (!ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) return ValidationResult.WRONG_TYPE;
            ProsperoLogger.ROOT_LOGGER.debugf("The candidate server has been prepared for different operation [%s].", marker.getOperation().getText());
            return ValidationResult.WRONG_TYPE;
        }
        catch (IOException e) {
            if (!ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) throw ProsperoLogger.ROOT_LOGGER.unableToReadFile(updateMarkerPath, e);
            ProsperoLogger.ROOT_LOGGER.debugf("Unable to read marker file [%s].", this.updateDir);
            throw ProsperoLogger.ROOT_LOGGER.unableToReadFile(updateMarkerPath, e);
        }
    }

    public List<FileConflict> getConflicts() throws ProvisioningException, OperationException {
        try {
            return this.compareServers(this.findChanges());
        }
        catch (IOException ex) {
            throw new ProvisioningException((Throwable)ex);
        }
    }

    public boolean removeCandidate(File updateDir) {
        File[] allContents = updateDir.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                this.removeCandidate(file);
            }
        }
        return updateDir.delete();
    }

    public UpdateSet findUpdates() throws OperationException {
        List<Artifact> candidate;
        List<Artifact> base;
        HashMap<CallSite, Artifact> baseMap = new HashMap<CallSite, Artifact>();
        HashMap<CallSite, Artifact> candidateMap = new HashMap<CallSite, Artifact>();
        try (Iterator<Artifact> metadata = InstallationMetadata.loadInstallation(this.installationDir);){
            base = ((InstallationMetadata)((Object)metadata)).getArtifacts();
        }
        metadata = InstallationMetadata.loadInstallation(this.updateDir);
        try {
            candidate = ((InstallationMetadata)((Object)metadata)).getArtifacts();
        }
        finally {
            if (metadata != null) {
                ((InstallationMetadata)((Object)metadata)).close();
            }
        }
        for (Artifact artifact : base) {
            baseMap.put((CallSite)((Object)(artifact.getGroupId() + ":" + artifact.getArtifactId())), artifact);
        }
        for (Artifact artifact : candidate) {
            candidateMap.put((CallSite)((Object)(artifact.getGroupId() + ":" + artifact.getArtifactId())), artifact);
        }
        ArrayList<ArtifactChange> changes = new ArrayList<ArtifactChange>();
        CandidateProperties candidateProperties = this.readCandidateProperties();
        for (String key : baseMap.keySet()) {
            if (candidateMap.containsKey(key)) {
                if (((Artifact)baseMap.get(key)).getVersion().equals(((Artifact)candidateMap.get(key)).getVersion())) continue;
                String updateChannelName = candidateProperties.getUpdateChannel(key);
                changes.add(ArtifactChange.updated((Artifact)baseMap.get(key), (Artifact)candidateMap.get(key), updateChannelName));
                continue;
            }
            changes.add(ArtifactChange.removed((Artifact)baseMap.get(key)));
        }
        for (String key : candidateMap.keySet()) {
            if (baseMap.containsKey(key)) continue;
            changes.add(ArtifactChange.added((Artifact)candidateMap.get(key)));
        }
        return new UpdateSet(changes);
    }

    private CandidateProperties readCandidateProperties() {
        Path candidatePropertiesPath = this.updateDir.resolve(".installation").resolve(CANDIDATE_CHANNEL_NAME_LIST);
        if (Files.exists(candidatePropertiesPath, new LinkOption[0])) {
            try {
                return CandidatePropertiesParser.read(candidatePropertiesPath);
            }
            catch (IOException | MetadataException e) {
                ProsperoLogger.ROOT_LOGGER.unableToReadChannelNames(candidatePropertiesPath.toString(), e);
            }
        }
        return new CandidateProperties(Collections.emptyList());
    }

    public SavedState getCandidateRevision() throws MetadataException {
        try (InstallationMetadata metadata = InstallationMetadata.loadInstallation(this.updateDir);){
            SavedState savedState = metadata.getRevisions().get(0);
            return savedState;
        }
    }

    private boolean targetServerIsRunning() {
        return Files.exists(this.installationDir.resolve(STANDALONE_STARTUP_MARKER), new LinkOption[0]) || Files.exists(this.installationDir.resolve(DOMAIN_STARTUP_MARKER), new LinkOption[0]);
    }

    private FsDiff findChanges() throws ProvisioningException, OperationException {
        MavenOptions mavenOptions = MavenOptions.builder().setOffline(true).setNoLocalCache(true).build();
        try (GalleonEnvironment galleonEnv = GalleonEnvironment.builder(this.installationDir, Collections.emptyList(), new MavenSessionManager(mavenOptions)).build();){
            ProvisioningManager provisioningManager = galleonEnv.getProvisioningManager();
            FsDiff fsDiff = provisioningManager.getFsDiff();
            return fsDiff;
        }
    }

    private void updateMetadata(Type operation) throws ProvisioningException, MetadataException {
        try {
            this.copyCurrentVersions();
            Path installationGalleonPath = PathsUtils.getProvisionedStateDir((Path)this.installationDir);
            Path updateGalleonPath = PathsUtils.getProvisionedStateDir((Path)this.updateDir);
            IoUtils.recursiveDelete((Path)installationGalleonPath);
            IoUtils.copy((Path)updateGalleonPath, (Path)installationGalleonPath, (boolean)true);
            ProsperoMetadataUtils.recordProvisioningDefinition((Path)this.installationDir);
            this.writeProsperoMetadata(operation);
            this.updateInstallationCache();
        }
        catch (IOException ex) {
            throw new ProvisioningException((Throwable)ex);
        }
    }

    private void copyCurrentVersions() throws IOException {
        Path sourceVersions = this.updateDir.resolve(".installation").resolve("manifest_version.yaml");
        if (Files.exists(sourceVersions, new LinkOption[0])) {
            Files.copy(sourceVersions, this.installationDir.resolve(".installation").resolve("manifest_version.yaml"), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeProsperoMetadata(Type operation) throws MetadataException, IOException {
        Path updateMetadataDir = this.updateDir.resolve(".installation");
        Path updateManifest = updateMetadataDir.resolve("manifest.yaml");
        Path installationMetadataDir = this.installationDir.resolve(".installation");
        Path installationManifest = installationMetadataDir.resolve("manifest.yaml");
        IoUtils.copy((Path)updateManifest, (Path)installationManifest);
        try (GitStorage git = new GitStorage(this.installationDir);){
            switch (operation) {
                case UPDATE: {
                    git.recordChange(SavedState.Type.UPDATE);
                    return;
                }
                case REVERT: {
                    git.recordChange(SavedState.Type.ROLLBACK);
                    Path updateChannels = updateMetadataDir.resolve("installer-channels.yaml");
                    Path installationChannels = installationMetadataDir.resolve("installer-channels.yaml");
                    IoUtils.copy((Path)updateChannels, (Path)installationChannels);
                    return;
                }
                case FEATURE_ADD: {
                    git.recordChange(SavedState.Type.FEATURE_PACK);
                    return;
                }
            }
            return;
        }
    }

    private void updateInstallationCache() throws IOException {
        Path updateCacheDir = this.updateDir.resolve(ArtifactCache.CACHE_FOLDER);
        Path installationCacheDir = this.installationDir.resolve(ArtifactCache.CACHE_FOLDER);
        if (Files.exists(installationCacheDir, new LinkOption[0])) {
            IoUtils.recursiveDelete((Path)installationCacheDir);
        }
        if (Files.exists(updateCacheDir, new LinkOption[0])) {
            IoUtils.copy((Path)updateCacheDir, (Path)installationCacheDir);
        }
    }

    private List<FileConflict> handleRemovedFiles(FsDiff fsDiff) throws IOException {
        ArrayList<FileConflict> conflictList = new ArrayList<FileConflict>();
        if (fsDiff.hasRemovedEntries()) {
            for (FsEntry removed : fsDiff.getRemovedEntries()) {
                Path target = this.updateDir.resolve(removed.getRelativePath());
                if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                    ProsperoLogger.ROOT_LOGGER.debug(FsDiff.formatMessage((char)'-', (String)removed.getRelativePath(), null));
                }
                if (Files.exists(target, new LinkOption[0])) {
                    if (!this.systemPaths.isSystemPath(Paths.get(removed.getRelativePath(), new String[0]))) continue;
                    conflictList.add(FileConflict.userRemoved(removed.getRelativePath()).updateModified().overwritten());
                    if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                        ProsperoLogger.ROOT_LOGGER.debug(FsDiff.formatMessage((char)'F', (String)removed.getRelativePath(), (String)"has changed in the updated version"));
                    }
                    Files.createDirectories(this.installationDir.resolve(removed.getRelativePath()).getParent(), new FileAttribute[0]);
                    IoUtils.copy((Path)target, (Path)this.installationDir.resolve(removed.getRelativePath()));
                    continue;
                }
                if (!ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) continue;
                ProsperoLogger.ROOT_LOGGER.debug(FsDiff.formatMessage((char)'-', (String)removed.getRelativePath(), (String)"has been removed from the updated version"));
            }
        }
        return conflictList;
    }

    private List<FileConflict> handleAddedFiles(FsDiff fsDiff) throws IOException, ProvisioningException {
        ArrayList<FileConflict> conflictList = new ArrayList<FileConflict>();
        if (fsDiff.hasAddedEntries()) {
            for (FsEntry added : fsDiff.getAddedEntries()) {
                Path p = Paths.get(added.getRelativePath(), new String[0]);
                if (p.getNameCount() > 0 && p.getName(0).toString().equals(".installation")) continue;
                this.addFsEntry(this.updateDir, added, this.systemPaths, conflictList);
            }
        }
        return conflictList;
    }

    private void addFsEntry(Path updateDir, FsEntry added, SystemPaths systemPaths, List<FileConflict> conflictList) throws ProvisioningException {
        Path target = updateDir.resolve(added.getRelativePath());
        if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
            ProsperoLogger.ROOT_LOGGER.debug(FsDiff.formatMessage((char)'+', (String)added.getRelativePath(), null));
        }
        if (Files.exists(target, new LinkOption[0])) {
            byte[] targetHash;
            if (added.isDir()) {
                for (FsEntry child : added.getChildren()) {
                    this.addFsEntry(updateDir, child, systemPaths, conflictList);
                }
                return;
            }
            try {
                targetHash = HashUtils.hashPath((Path)target);
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.hashCalculation((Path)target), (Throwable)e);
            }
            if (Arrays.equals(added.getHash(), targetHash)) {
                if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                    ProsperoLogger.ROOT_LOGGER.debug(FsDiff.formatMessage((char)'+', (String)added.getRelativePath(), (String)"Added file matches the update."));
                }
            } else if (systemPaths.isSystemPath(Paths.get(added.getRelativePath(), new String[0]))) {
                if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                    ProsperoLogger.ROOT_LOGGER.debug(FsDiff.formatMessage((char)'F', (String)added.getRelativePath(), (String)"conflicts with the updated version"));
                }
                conflictList.add(FileConflict.userAdded(added.getRelativePath()).updateAdded().overwritten());
                ApplyCandidateAction.glold(this.installationDir.resolve(added.getRelativePath()), target);
            } else {
                if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                    ProsperoLogger.ROOT_LOGGER.debug(FsDiff.formatMessage((char)'C', (String)added.getRelativePath(), (String)"conflicts with the updated version"));
                }
                conflictList.add(FileConflict.userAdded(added.getRelativePath()).updateAdded().userPreserved());
                ApplyCandidateAction.glnew(target, this.installationDir.resolve(added.getRelativePath()));
            }
        }
    }

    private List<FileConflict> handleModifiedFiles(FsDiff fsDiff) throws IOException, ProvisioningException {
        ArrayList<FileConflict> conflictList = new ArrayList<FileConflict>();
        if (fsDiff.hasModifiedEntries()) {
            for (FsEntry[] modified : fsDiff.getModifiedEntries()) {
                FsEntry installation = modified[1];
                FsEntry original = modified[0];
                Path file = this.updateDir.resolve(modified[1].getRelativePath());
                if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                    ProsperoLogger.ROOT_LOGGER.debug(FsDiff.formatMessage((char)'M', (String)installation.getRelativePath(), null));
                }
                if (Files.exists(file, new LinkOption[0])) {
                    byte[] updateHash;
                    try {
                        updateHash = HashUtils.hashPath((Path)file);
                    }
                    catch (IOException e) {
                        throw new ProvisioningException(Errors.hashCalculation((Path)file), (Throwable)e);
                    }
                    Path installationFile = this.installationDir.resolve(modified[1].getRelativePath());
                    if (Arrays.equals(installation.getHash(), updateHash)) {
                        if (!ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) continue;
                        ProsperoLogger.ROOT_LOGGER.debug(FsDiff.formatMessage((char)'M', (String)installation.getRelativePath(), (String)"Modified file matches the update"));
                        continue;
                    }
                    if (Arrays.equals(original.getHash(), updateHash)) continue;
                    if (this.systemPaths.isSystemPath(Paths.get(installation.getRelativePath(), new String[0]))) {
                        if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                            ProsperoLogger.ROOT_LOGGER.debug(FsDiff.formatMessage((char)'F', (String)installation.getRelativePath(), (String)"has changed in the updated version"));
                        }
                        conflictList.add(FileConflict.userModified(installation.getRelativePath()).updateModified().overwritten());
                        ApplyCandidateAction.glold(installation.getPath(), file);
                        continue;
                    }
                    if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                        ProsperoLogger.ROOT_LOGGER.debug(FsDiff.formatMessage((char)'C', (String)installation.getRelativePath(), (String)"has changed in the updated version"));
                    }
                    conflictList.add(FileConflict.userModified(installation.getRelativePath()).updateModified().userPreserved());
                    ApplyCandidateAction.glnew(file, installationFile);
                    continue;
                }
                if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                    ProsperoLogger.ROOT_LOGGER.debug(FsDiff.formatMessage((char)'M', (String)installation.getRelativePath(), (String)"has been removed from the updated version"));
                }
                conflictList.add(FileConflict.userModified(installation.getRelativePath()).updateRemoved().userPreserved());
            }
        }
        return conflictList;
    }

    private List<FileConflict> compareServers(FsDiff fsDiff) throws IOException, ProvisioningException {
        ArrayList<FileConflict> conflicts = new ArrayList<FileConflict>();
        conflicts.addAll(this.handleRemovedFiles(fsDiff));
        conflicts.addAll(this.handleAddedFiles(fsDiff));
        conflicts.addAll(this.handleModifiedFiles(fsDiff));
        return Collections.unmodifiableList(conflicts);
    }

    private List<FileConflict> doApplyUpdate(final FsDiff fsDiff) throws IOException, ProvisioningException {
        ArrayList<FileConflict> conflicts = new ArrayList<FileConflict>();
        conflicts.addAll(this.handleRemovedFiles(fsDiff));
        conflicts.addAll(this.handleAddedFiles(fsDiff));
        conflicts.addAll(this.handleModifiedFiles(fsDiff));
        final Path skipUpdateGalleon = PathsUtils.getProvisionedStateDir((Path)this.updateDir);
        final Path skipUpdateInstallation = this.updateDir.resolve(".installation");
        final Path skipInstallationGalleon = PathsUtils.getProvisionedStateDir((Path)this.installationDir);
        final Path skipInstallationInstallation = this.installationDir.resolve(".installation");
        Files.walkFileTree(this.updateDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path relative = ApplyCandidateAction.this.updateDir.relativize(file);
                Path installationFile = ApplyCandidateAction.this.installationDir.resolve(relative);
                String pathKey = ApplyCandidateAction.this.getFsDiffKey(relative, false);
                if (fsDiff.getModifiedEntry(pathKey) == null && fsDiff.getAddedEntry(pathKey) == null && !this.isParentAdded(fsDiff, relative)) {
                    byte[] updateHash = HashUtils.hashPath((Path)file);
                    if (!Files.exists(installationFile, new LinkOption[0]) || !Arrays.equals(updateHash, HashUtils.hashPath((Path)installationFile))) {
                        if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                            ProsperoLogger.ROOT_LOGGER.debug("Copying updated file " + relative + " to the installation");
                        }
                        IoUtils.copy((Path)file, (Path)installationFile);
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            private boolean isParentAdded(FsDiff fsDiff2, Path relative) {
                for (Path parent = relative.getParent(); parent != null; parent = parent.getParent()) {
                    if (fsDiff2.getAddedEntry(parent + "/") == null) continue;
                    return true;
                }
                return false;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (dir.equals(skipUpdateGalleon) || dir.equals(skipUpdateInstallation)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
        Files.walkFileTree(this.installationDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path relative = ApplyCandidateAction.this.installationDir.relativize(file);
                Path updateFile = ApplyCandidateAction.this.updateDir.resolve(relative);
                String fsDiffKey = ApplyCandidateAction.this.getFsDiffKey(relative, false);
                if (ApplyCandidateAction.isNotAddedOrModified(fsDiffKey, fsDiff) && this.fileNotPresent(updateFile)) {
                    if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                        ProsperoLogger.ROOT_LOGGER.debug("Deleting the file " + relative + " that doesn't exist in the update");
                    }
                    IoUtils.recursiveDelete((Path)file);
                }
                return FileVisitResult.CONTINUE;
            }

            private boolean fileNotPresent(Path updateFile) {
                return !Files.exists(updateFile, new LinkOption[0]) && !updateFile.toString().endsWith(".glnew") && !updateFile.toString().endsWith(".glold");
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (dir.equals(skipInstallationGalleon) || dir.equals(skipInstallationInstallation)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (!dir.equals(ApplyCandidateAction.this.installationDir)) {
                    Path relative = ApplyCandidateAction.this.installationDir.relativize(dir);
                    Path target = ApplyCandidateAction.this.updateDir.resolve(relative);
                    String pathKey = ApplyCandidateAction.this.getFsDiffKey(relative, true);
                    if (ApplyCandidateAction.isAdded(pathKey, fsDiff) && !Files.exists(target, new LinkOption[0])) {
                        if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                            ProsperoLogger.ROOT_LOGGER.debug("The directory " + relative + " that doesn't exist in the update is a User changes, skipping it");
                        }
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                if (!dir.equals(ApplyCandidateAction.this.installationDir)) {
                    Path relative = ApplyCandidateAction.this.installationDir.relativize(dir);
                    Path target = ApplyCandidateAction.this.updateDir.resolve(relative);
                    String pathKey = ApplyCandidateAction.this.getFsDiffKey(relative, true);
                    if (!ApplyCandidateAction.isAdded(pathKey, fsDiff) && !Files.exists(target, new LinkOption[0]) && ApplyCandidateAction.isEmpty(dir)) {
                        if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                            ProsperoLogger.ROOT_LOGGER.debug("Deleting the directory " + relative + " that doesn't exist in the update");
                        }
                        IoUtils.recursiveDelete((Path)dir);
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return Collections.unmodifiableList(conflicts);
    }

    private static boolean isEmpty(Path dir) {
        String[] children = dir.toFile().list();
        if (children == null) {
            throw new RuntimeException("Unable to list children of " + dir);
        }
        return children.length == 0;
    }

    private static boolean isAdded(String pathKey, FsDiff fsDiff) {
        return fsDiff.getAddedEntry(pathKey) != null;
    }

    private static boolean isNotAddedOrModified(String fsDiffKey, FsDiff fsDiff) {
        return !ApplyCandidateAction.isAdded(fsDiffKey, fsDiff) && fsDiff.getModifiedEntry(fsDiffKey) == null;
    }

    private String getFsDiffKey(Path relative, boolean appendSeparator) {
        Object pathKey = relative.toString().replace(File.separator, "/");
        if (appendSeparator) {
            pathKey = ((String)pathKey).endsWith("/") ? pathKey : (String)pathKey + "/";
        }
        return pathKey;
    }

    private static void glnew(Path updateFile, Path installationFile) throws ProvisioningException {
        try {
            IoUtils.copy((Path)updateFile, (Path)installationFile.getParent().resolve(installationFile.getFileName() + ".glnew"));
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to persist " + installationFile.getParent().resolve(installationFile.getFileName() + ".glnew"), (Throwable)e);
        }
    }

    private static void glold(Path installationFile, Path target) throws ProvisioningException {
        try {
            IoUtils.copy((Path)installationFile, (Path)installationFile.getParent().resolve(installationFile.getFileName() + ".glold"));
            IoUtils.copy((Path)target, (Path)installationFile);
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to persist " + target.getParent().resolve(target.getFileName() + ".glold"), (Throwable)e);
        }
    }

    public static enum ValidationResult {
        OK,
        NOT_CANDIDATE,
        STALE,
        WRONG_TYPE;

    }

    public static enum Type {
        UPDATE("UPDATE"),
        REVERT("REVERT"),
        FEATURE_ADD("FEATURE_ADD");

        private final String text;

        private Type(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public static Type from(String text) {
            switch (text) {
                case "UPDATE": {
                    return UPDATE;
                }
                case "REVERT": {
                    return REVERT;
                }
                case "FEATURE_ADD": {
                    return FEATURE_ADD;
                }
            }
            throw ProsperoLogger.ROOT_LOGGER.invalidMarkerFileOperation(text);
        }
    }
}

