/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.logging.Logger;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.ChannelSession;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.actions.ApplyCandidateAction;
import org.wildfly.prospero.api.ArtifactChange;
import org.wildfly.prospero.api.InstallationMetadata;
import org.wildfly.prospero.api.SavedState;
import org.wildfly.prospero.api.exceptions.ArtifactResolutionException;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.galleon.ArtifactCache;
import org.wildfly.prospero.galleon.GalleonEnvironment;
import org.wildfly.prospero.galleon.GalleonFeaturePackAnalyzer;
import org.wildfly.prospero.galleon.GalleonUtils;
import org.wildfly.prospero.licenses.LicenseManager;
import org.wildfly.prospero.metadata.ManifestVersionRecord;
import org.wildfly.prospero.metadata.ManifestVersionResolver;
import org.wildfly.prospero.model.ProsperoConfig;
import org.wildfly.prospero.updates.CandidateProperties;
import org.wildfly.prospero.updates.CandidatePropertiesParser;
import org.wildfly.prospero.updates.MarkerFile;
import org.wildfly.prospero.updates.UpdateSet;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

class PrepareCandidateAction
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger((String)PrepareCandidateAction.class.getName());
    private final InstallationMetadata metadata;
    private final ProsperoConfig prosperoConfig;
    private final MavenSessionManager mavenSessionManager;
    private final Path installDir;

    PrepareCandidateAction(Path installDir, MavenSessionManager mavenSessionManager, ProsperoConfig prosperoConfig) throws OperationException {
        this.metadata = InstallationMetadata.loadInstallation(installDir);
        this.installDir = installDir;
        this.prosperoConfig = prosperoConfig;
        this.mavenSessionManager = mavenSessionManager;
    }

    boolean buildCandidate(Path targetDir, GalleonEnvironment galleonEnv, ApplyCandidateAction.Type operation, GalleonProvisioningConfig config) throws ProvisioningException, OperationException {
        return this.buildCandidate(targetDir, galleonEnv, operation, config, new UpdateSet(Collections.emptyList()));
    }

    boolean buildCandidate(Path targetDir, GalleonEnvironment galleonEnv, ApplyCandidateAction.Type operation, GalleonProvisioningConfig config, UpdateSet updateSet) throws ProvisioningException, OperationException {
        return this.buildCandidate(targetDir, galleonEnv, operation, config, updateSet, () -> this.getManifestVersionRecord(galleonEnv));
    }

    boolean buildCandidate(Path targetDir, GalleonEnvironment galleonEnv, ApplyCandidateAction.Type operation, GalleonProvisioningConfig config, UpdateSet updateSet, Supplier<Optional<ManifestVersionRecord>> manifestVersionRecordSupplier) throws ProvisioningException, OperationException {
        Objects.requireNonNull(manifestVersionRecordSupplier);
        this.doBuildUpdate(targetDir, galleonEnv, config, manifestVersionRecordSupplier);
        try {
            SavedState savedState = this.metadata.getRevisions().get(0);
            new MarkerFile(savedState.getName(), operation).write(targetDir);
            this.writeCandidateProperties(updateSet, targetDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private void doBuildUpdate(Path targetDir, GalleonEnvironment galleonEnv, GalleonProvisioningConfig provisioningConfig, Supplier<Optional<ManifestVersionRecord>> manifestVersionResolver) throws ProvisioningException, OperationException {
        Provisioning provMgr = galleonEnv.getProvisioning();
        try {
            GalleonUtils.executeGalleon(options -> {
                options.put("export-system-paths", "true");
                provMgr.provision(provisioningConfig, options);
            }, this.mavenSessionManager.getProvisioningRepo().toAbsolutePath());
        }
        catch (UnresolvedMavenArtifactException e) {
            throw new ArtifactResolutionException(ProsperoLogger.ROOT_LOGGER.unableToResolve(), e, e.getUnresolvedArtifacts(), e.getAttemptedRepositories(), this.mavenSessionManager.isOffline());
        }
        Optional<ManifestVersionRecord> manifestRecord = manifestVersionResolver.get();
        if (LOG.isTraceEnabled()) {
            LOG.tracef("Recording manifests: %s", (Object)manifestRecord.orElse(new ManifestVersionRecord()));
        }
        manifestRecord.ifPresent(rec -> this.cacheManifests((ManifestVersionRecord)rec, targetDir));
        this.writeProsperoMetadata(targetDir, galleonEnv.getChannelSession().getRecordedChannel(), this.prosperoConfig.getChannels(), manifestRecord);
        try {
            GalleonFeaturePackAnalyzer galleonFeaturePackAnalyzer = new GalleonFeaturePackAnalyzer(galleonEnv.getChannels(), this.mavenSessionManager);
            galleonFeaturePackAnalyzer.cacheGalleonArtifacts(targetDir, provisioningConfig);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            new LicenseManager().copyIfExists(this.installDir, targetDir);
        }
        catch (IOException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToWriteFile(this.installDir.resolve("licenses"), e);
        }
    }

    private Optional<ManifestVersionRecord> getManifestVersionRecord(GalleonEnvironment galleonEnv) {
        try {
            return Optional.of(ManifestVersionResolver.getCurrentVersions((ChannelSession)galleonEnv.getChannelSession()));
        }
        catch (IOException e) {
            ProsperoLogger.ROOT_LOGGER.debug("Unable to retrieve current manifest versions", e);
            return Optional.empty();
        }
    }

    private void cacheManifests(ManifestVersionRecord manifestRecord, Path installDir) {
        try {
            RepositorySystem system = this.mavenSessionManager.newRepositorySystem();
            DefaultRepositorySystemSession session = this.mavenSessionManager.newRepositorySystemSession(system);
            ArtifactCache.getInstance(installDir).cache(manifestRecord, session.getLocalRepositoryManager());
        }
        catch (IOException e) {
            ProsperoLogger.ROOT_LOGGER.debug("Unable to record manifests in the internal cache", e);
        }
    }

    @Override
    public void close() {
        this.metadata.close();
    }

    private void writeProsperoMetadata(Path home, ChannelManifest manifest, List<Channel> channels, Optional<ManifestVersionRecord> manifestVersions) throws MetadataException {
        try (InstallationMetadata installationMetadata = InstallationMetadata.newInstallation(home, manifest, new ProsperoConfig(channels), manifestVersions);){
            installationMetadata.recordProvision(true, false);
        }
    }

    private void writeCandidateProperties(UpdateSet updateSet, Path installationDir) {
        ArrayList<CandidateProperties.ComponentUpdate> updates = new ArrayList<CandidateProperties.ComponentUpdate>();
        for (ArtifactChange artifactChange : updateSet.getArtifactUpdates()) {
            String[] gaSplit = artifactChange.getArtifactName().split(":");
            if (!artifactChange.getChannelName().isPresent()) continue;
            updates.add(new CandidateProperties.ComponentUpdate(gaSplit[0], gaSplit[1], artifactChange.getChannelName().get()));
        }
        Path candidateFile = installationDir.resolve(".installation").resolve("candidate_properties.yaml");
        try {
            CandidatePropertiesParser.write(new CandidateProperties(updates), candidateFile);
            ProsperoLogger.ROOT_LOGGER.channelNamesWrittenToFile(candidateFile.toFile().getAbsolutePath());
        }
        catch (IOException e) {
            ProsperoLogger.ROOT_LOGGER.unableToWriteChannelNamesToFile(candidateFile.toFile().getAbsolutePath(), e);
        }
    }
}

