/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.installation.git;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.util.SystemReader;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.Stream;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.api.ArtifactChange;
import org.wildfly.prospero.api.ChannelChange;
import org.wildfly.prospero.api.FeatureChange;
import org.wildfly.prospero.api.SavedState;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.installation.git.FeatureChangeParser;
import org.wildfly.prospero.installation.git.NonPersistingSystemReader;
import org.wildfly.prospero.metadata.ManifestVersionRecord;
import org.wildfly.prospero.model.ManifestYamlSupport;
import org.wildfly.prospero.model.ProsperoConfig;

public class GitStorage
implements AutoCloseable {
    public static final String GIT_HISTORY_USER = "Wildfly Installer";
    private final Git git;
    private Path base;

    public GitStorage(Path base) throws MetadataException {
        this.base = base.resolve(".installation");
        try {
            this.git = this.initGit();
        }
        catch (IOException | GitAPIException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToCreateHistoryStorage(base, (Exception)e);
        }
    }

    public List<SavedState> getRevisions() throws MetadataException {
        try {
            Iterable call = this.git.log().call();
            ArrayList<SavedState> history = new ArrayList<SavedState>();
            for (RevCommit revCommit : call) {
                SavedState.Type recordType;
                String msg;
                String type;
                String shortMessage = revCommit.getShortMessage().trim();
                int endOfTypeIndex = shortMessage.indexOf(32);
                if (endOfTypeIndex < 0) {
                    type = shortMessage;
                    msg = "";
                } else {
                    type = shortMessage.substring(0, endOfTypeIndex).trim();
                    msg = shortMessage.substring(endOfTypeIndex + 1).trim();
                }
                if ((recordType = SavedState.Type.fromText(type.toUpperCase(Locale.ROOT))) == SavedState.Type.INTERNAL_UPDATE) continue;
                if (recordType == SavedState.Type.UNKNOWN) {
                    msg = shortMessage;
                }
                history.add(new SavedState(revCommit.getName().substring(0, 8), Instant.ofEpochSecond(revCommit.getCommitTime()), recordType, msg));
            }
            return history;
        }
        catch (GitAPIException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToAccessHistoryStorage(this.base, (Exception)((Object)e));
        }
    }

    public void record() throws MetadataException {
        try {
            if (this.isRepositoryEmpty(this.git)) {
                PersonIdent author = this.adjustCommitDateToCreationDate(this.getCommitter());
                SavedState.Type commitType = SavedState.Type.INSTALL;
                String msg = this.readCommitMessage();
                this.git.add().addFilepattern("manifest.yaml").call();
                this.git.add().addFilepattern("installer-channels.yaml").call();
                this.git.add().addFilepattern("manifest_version.yaml").call();
                this.git.add().addFilepattern("provisioning_record.xml").call();
                this.git.commit().setAuthor(author).setCommitter(author).setMessage(commitType.name() + (String)(msg == null ? "" : " " + msg)).call();
            } else {
                this.recordChange(SavedState.Type.UPDATE);
            }
        }
        catch (IOException | GitAPIException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToAccessHistoryStorage(this.base, (Exception)e);
        }
    }

    private String readCommitMessage() throws MetadataException {
        Path versionsFile = this.base.resolve("manifest_version.yaml");
        try {
            return ManifestVersionRecord.read((Path)versionsFile).map(ManifestVersionRecord::getSummary).orElse(null);
        }
        catch (IOException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToReadFile(versionsFile, e);
        }
    }

    public void recordChange(SavedState.Type operation) throws MetadataException {
        this.recordChange(operation, "manifest.yaml", "manifest_version.yaml", "provisioning_record.xml");
    }

    public void recordChange(SavedState.Type operation, String ... files) throws MetadataException {
        try {
            if (this.isRepositoryEmpty(this.git)) {
                throw new IllegalStateException("This operation cannot be performed on empty repository");
            }
            for (String file : files) {
                this.git.add().addFilepattern(file).call();
            }
            PersonIdent author = this.getCommitter();
            SavedState.Type commitType = operation;
            String msg = this.readCommitMessage();
            this.git.commit().setAuthor(author).setCommitter(author).setMessage(commitType.name() + (String)(msg == null ? "" : " " + msg)).call();
        }
        catch (IOException | GitAPIException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToAccessHistoryStorage(this.base, (Exception)e);
        }
    }

    private PersonIdent getCommitter() {
        return new PersonIdent(GIT_HISTORY_USER, "");
    }

    private PersonIdent adjustCommitDateToCreationDate(PersonIdent committer) throws IOException {
        FileTime fileTime = Files.readAttributes(this.base, BasicFileAttributes.class, new LinkOption[0]).creationTime();
        return new PersonIdent(committer, fileTime.toMillis(), committer.getTimeZone().getRawOffset());
    }

    public void recordConfigChange() throws MetadataException {
        try {
            this.git.add().addFilepattern("installer-channels.yaml").call();
            PersonIdent author = this.getCommitter();
            this.git.commit().setAuthor(author).setCommitter(author).setMessage(SavedState.Type.CONFIG_CHANGE.name()).call();
        }
        catch (GitAPIException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToAccessHistoryStorage(this.base, (Exception)((Object)e));
        }
    }

    public Path revert(SavedState savedState) throws MetadataException {
        Path path;
        block10: {
            Path hist = Files.createTempDirectory("hist", new FileAttribute[0]).resolve(".installation");
            Git temp = Git.cloneRepository().setDirectory(hist.toFile()).setRemote("origin").setURI(this.base.toUri().toString()).call();
            try {
                temp.reset().setMode(ResetCommand.ResetType.HARD).setRef(savedState.getName()).call();
                if (!Files.exists(hist.resolve("provisioning_record.xml"), new LinkOption[0])) {
                    Iterable provRecordHistory = this.git.log().addPath("provisioning_record.xml").call();
                    Iterator iterator = provRecordHistory.iterator();
                    RevCommit revCommit = null;
                    while (iterator.hasNext()) {
                        revCommit = (RevCommit)iterator.next();
                    }
                    temp.checkout().addPath("provisioning_record.xml").setAllPaths(false).setStartPoint(revCommit).call();
                }
                path = hist.getParent();
                if (temp == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (temp != null) {
                        try {
                            temp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | GitAPIException e) {
                    throw ProsperoLogger.ROOT_LOGGER.unableToAccessHistoryStorage(this.base, (Exception)e);
                }
            }
            temp.close();
        }
        return path;
    }

    public void reset() throws MetadataException {
        try {
            this.git.reset().setRef("HEAD").setMode(ResetCommand.ResetType.HARD).call();
        }
        catch (GitAPIException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToAccessHistoryStorage(this.base, (Exception)((Object)e));
        }
    }

    public List<ArtifactChange> getArtifactChanges(SavedState savedState) throws MetadataException {
        ArtifactChangeParser parser = new ArtifactChangeParser();
        SavedState other = this.getStateFromName(savedState.getName() + "^");
        return this.getChanges(savedState, other, "manifest.yaml", parser);
    }

    public List<ArtifactChange> getArtifactChangesSince(SavedState savedState) throws MetadataException {
        ArtifactChangeParser parser = new ArtifactChangeParser();
        SavedState other = this.getStateFromName("HEAD");
        return this.getChanges(other, savedState, "manifest.yaml", parser);
    }

    public List<ChannelChange> getChannelChanges(SavedState savedState) throws MetadataException {
        ChannelChangeParser parser = new ChannelChangeParser();
        SavedState other = this.getStateFromName(savedState.getName() + "^");
        return this.getChanges(savedState, other, "installer-channels.yaml", parser);
    }

    public List<ChannelChange> getChannelChangesSince(SavedState savedState) throws MetadataException {
        ChannelChangeParser parser = new ChannelChangeParser();
        SavedState other = this.getStateFromName("HEAD");
        return this.getChanges(other, savedState, "installer-channels.yaml", parser);
    }

    public List<FeatureChange> getFeatureChanges(SavedState latestState) throws MetadataException {
        SavedState other = this.getStateFromName(latestState.getName() + "^");
        return this.getChanges(latestState, other, "provisioning_record.xml", new FeatureChangeParser());
    }

    public List<FeatureChange> getFeatureChangesSince(SavedState latestState) throws MetadataException {
        SavedState other = this.getStateFromName("HEAD");
        return this.getChanges(other, latestState, "provisioning_record.xml", new FeatureChangeParser());
    }

    private <T> List<T> getChanges(SavedState savedState, SavedState other, String manifestFileName, Parser<T> parser) throws MetadataException {
        Path change = null;
        Path base = null;
        try {
            change = this.checkoutPastState(savedState, manifestFileName);
            if (other != null) {
                base = this.checkoutPastState(other, manifestFileName);
            }
            List<T> list = parser.parse(change, base);
            return list;
        }
        catch (GitAPIException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToParseConfiguration(change, e);
        }
        finally {
            try {
                if (change != null) {
                    FileUtils.deleteDirectory((File)change.toFile());
                }
                if (base != null) {
                    FileUtils.deleteDirectory((File)base.toFile());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private SavedState getStateFromName(String savedState) throws MetadataException {
        try {
            ObjectId parentRef = this.git.getRepository().resolve(savedState);
            return parentRef == null ? null : new SavedState(parentRef.getName());
        }
        catch (IOException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToAccessHistoryStorage(this.base, e);
        }
    }

    private Map<String, Artifact> toMap(Collection<Stream> artifacts) {
        HashMap<String, Artifact> map = new HashMap<String, Artifact>();
        for (Stream stream : artifacts) {
            DefaultArtifact artifact = new DefaultArtifact(stream.getGroupId(), stream.getArtifactId(), "jar", stream.getVersion());
            map.put(stream.getGroupId() + ":" + stream.getArtifactId(), (Artifact)artifact);
        }
        return map;
    }

    private boolean isRepositoryEmpty(Git git) throws IOException {
        return git.getRepository().resolve("HEAD") == null;
    }

    private Git initGit() throws GitAPIException, IOException {
        Git git;
        if (!this.base.resolve(".git").toFile().exists()) {
            git = Git.init().setDirectory(this.base.toFile()).call();
            StoredConfig config = git.getRepository().getConfig();
            config.setBoolean("commit", null, "gpgsign", false);
            config.setString("user", null, "name", GIT_HISTORY_USER);
            config.setString("user", null, "email", "");
            config.save();
        } else {
            git = Git.open((File)this.base.toFile());
        }
        return git;
    }

    @Override
    public void close() {
        if (this.git != null) {
            this.git.close();
        }
    }

    public boolean isStarted() throws IOException {
        return !this.isRepositoryEmpty(this.git);
    }

    private Path checkoutPastState(SavedState savedState, String fileName) throws GitAPIException, IOException {
        Path hist = Files.createTempDirectory("hist", new FileAttribute[0]);
        try (Git temp = Git.cloneRepository().setDirectory(hist.toFile()).setRemote("origin").setURI(this.base.toUri().toString()).call();){
            temp.checkout().setStartPoint(savedState.getName()).addPath(fileName).call();
            Path path = hist;
            return path;
        }
    }

    static {
        SystemReader systemReader = SystemReader.getInstance();
        SystemReader.setInstance((SystemReader)new NonPersistingSystemReader(systemReader));
    }

    private class ArtifactChangeParser
    implements Parser<ArtifactChange> {
        private ArtifactChangeParser() {
        }

        @Override
        public List<ArtifactChange> parse(Path changed, Path base) throws IOException, MetadataException {
            Map<Object, Object> oldArtifacts;
            if (base != null) {
                ChannelManifest parseOld = ManifestYamlSupport.parse(base.resolve("manifest.yaml").toFile());
                oldArtifacts = GitStorage.this.toMap(parseOld.getStreams());
            } else {
                oldArtifacts = Collections.emptyMap();
            }
            ChannelManifest parseCurrent = ManifestYamlSupport.parse(changed.resolve("manifest.yaml").toFile());
            Map<String, Artifact> currentArtifacts = GitStorage.this.toMap(parseCurrent.getStreams());
            ArrayList<ArtifactChange> artifactChanges = new ArrayList<ArtifactChange>();
            for (String string : currentArtifacts.keySet()) {
                if (!oldArtifacts.containsKey(string)) {
                    artifactChanges.add(ArtifactChange.added(currentArtifacts.get(string)));
                    continue;
                }
                if (currentArtifacts.get(string).getVersion().equals(((Artifact)oldArtifacts.get(string)).getVersion())) continue;
                artifactChanges.add(ArtifactChange.updated((Artifact)oldArtifacts.get(string), currentArtifacts.get(string)));
            }
            for (String string : oldArtifacts.keySet()) {
                if (currentArtifacts.containsKey(string)) continue;
                artifactChanges.add(ArtifactChange.removed((Artifact)oldArtifacts.get(string)));
            }
            return artifactChanges;
        }
    }

    static interface Parser<T> {
        public List<T> parse(Path var1, Path var2) throws IOException, MetadataException;
    }

    private static class ChannelChangeParser
    implements Parser<ChannelChange> {
        private ChannelChangeParser() {
        }

        @Override
        public List<ChannelChange> parse(Path changed, Path base) throws IOException, MetadataException {
            List<Channel> oldChannels = base == null ? Collections.emptyList() : ProsperoConfig.readConfig(base).getChannels();
            List<Channel> currentChannels = ProsperoConfig.readConfig(changed).getChannels();
            ArrayList<ChannelChange> channelChanges = new ArrayList<ChannelChange>();
            for (Channel current2 : currentChannels) {
                Optional<Channel> oldChannel = oldChannels.stream().filter(old -> current2.getName().equals(old.getName())).findFirst();
                if (oldChannel.isEmpty()) {
                    channelChanges.add(ChannelChange.added(current2));
                    continue;
                }
                ChannelChange change = ChannelChange.modified(oldChannel.get(), current2);
                if (change.getChildren().isEmpty()) continue;
                channelChanges.add(change);
            }
            for (Channel old2 : oldChannels) {
                Optional<Channel> currentChannel = currentChannels.stream().filter(current -> current.getName().equals(old2.getName())).findFirst();
                if (!currentChannel.isEmpty()) continue;
                channelChanges.add(ChannelChange.removed(old2));
            }
            return channelChanges;
        }
    }
}

