/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.promotion;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;
import org.jboss.logging.Logger;
import org.wildfly.channel.ArtifactCoordinate;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.ChannelManifestMapper;
import org.wildfly.channel.Repository;
import org.wildfly.channel.Stream;
import org.wildfly.channel.maven.ChannelCoordinate;
import org.wildfly.channel.maven.VersionResolverFactory;
import org.wildfly.channel.spi.MavenVersionsResolver;
import org.wildfly.prospero.ProsperoLogger;

public class ArtifactPromoter {
    private static final Logger log = Logger.getLogger(ArtifactPromoter.class);
    private RepositorySystem system;
    private DefaultRepositorySystemSession session;
    private RemoteRepository targetRepository;

    public ArtifactPromoter(RepositorySystem system, DefaultRepositorySystemSession session, RemoteRepository targetRepository) {
        this.system = system;
        this.session = session;
        this.targetRepository = targetRepository;
        if (!targetRepository.getProtocol().equals("file")) {
            throw ProsperoLogger.ROOT_LOGGER.unsupportedPromotionTarget();
        }
    }

    public void promote(List<ArtifactCoordinate> artifacts, ChannelCoordinate coordinate, RemoteRepository sourceRepository) throws ArtifactResolutionException, DeploymentException, IOException {
        Objects.requireNonNull(artifacts);
        Objects.requireNonNull(coordinate);
        if (artifacts.isEmpty()) {
            log.debug((Object)"No artifacts to promote");
            return;
        }
        List<ArtifactResult> results = this.resolveArtifactsFromBundle(artifacts, sourceRepository);
        this.deployResolvedArtifacts(results);
        List streams = artifacts.stream().map(a -> new Stream(a.getGroupId(), a.getArtifactId(), a.getVersion())).collect(Collectors.toList());
        VersionRangeRequest vr = new VersionRangeRequest((Artifact)new DefaultArtifact(coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getClassifier(), coordinate.getExtension(), "[0,)"), Arrays.asList(this.targetRepository), null);
        Optional<String> version = this.latestAvailableChannelVersion(vr);
        ChannelManifest manifest = this.resolveDeployedChannel(coordinate, version);
        if (!manifest.getStreams().addAll(streams)) {
            return;
        }
        this.deployChannel(coordinate, version, manifest);
    }

    private List<ArtifactResult> resolveArtifactsFromBundle(List<ArtifactCoordinate> artifacts, RemoteRepository sourceRepository) throws ArtifactResolutionException {
        log.debugf("Resolving %s artifacts from custom bundle at %s", artifacts.size(), (Object)sourceRepository.getUrl());
        List<RemoteRepository> repositories = Arrays.asList(sourceRepository);
        List requests = artifacts.stream().map(artifact -> {
            String extension = artifact.getExtension() != null && !artifact.getExtension().isEmpty() ? artifact.getExtension() : "jar";
            DefaultArtifact mavenArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), extension, artifact.getVersion());
            return new ArtifactRequest((Artifact)mavenArtifact, repositories, null);
        }).collect(Collectors.toList());
        return this.system.resolveArtifacts((RepositorySystemSession)this.session, requests);
    }

    private void deployResolvedArtifacts(List<ArtifactResult> results) throws DeploymentException {
        log.debugf("Deploying %s artifacts from custom bundle to %s", results.size(), (Object)this.targetRepository.getUrl());
        DeployRequest deployRequest = new DeployRequest();
        deployRequest.setRepository(this.targetRepository);
        results.forEach(result -> deployRequest.setArtifacts(Arrays.asList(result.getArtifact())));
        this.system.deploy((RepositorySystemSession)this.session, deployRequest);
    }

    private Optional<String> latestAvailableChannelVersion(VersionRangeRequest vr) {
        try {
            VersionRangeResult result = this.system.resolveVersionRange((RepositorySystemSession)this.session, vr);
            return Optional.ofNullable(result.getHighestVersion()).map(Version::toString);
        }
        catch (VersionRangeResolutionException e) {
            return Optional.empty();
        }
    }

    private ChannelManifest resolveDeployedChannel(ChannelCoordinate coordinate, Optional<String> version) throws IOException {
        if (version.isPresent()) {
            log.debugf("Found existing customization channel with version %s", (Object)version.get());
            try (VersionResolverFactory versionResolverFactory = new VersionResolverFactory(this.system, (RepositorySystemSession)this.session);){
                MavenVersionsResolver resolver = versionResolverFactory.create(Arrays.asList(new Repository(this.targetRepository.getId(), this.targetRepository.getUrl())));
                File file = resolver.resolveArtifact(coordinate.getGroupId(), coordinate.getArtifactId(), "yaml", "manifest", version.get());
                ChannelManifest channelManifest = ChannelManifestMapper.fromString((String)Files.readString(file.toPath()));
                return channelManifest;
            }
        }
        log.debugf("No existing customization channel found, creating new channel", new Object[0]);
        return new ChannelManifest("custom-channel", "custom-channel", "Customization channel", new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployChannel(ChannelCoordinate coordinate, Optional<String> version, ChannelManifest manifest) throws IOException, DeploymentException {
        Path tempFile = Files.createTempFile("manifest", "yaml", new FileAttribute[0]);
        try {
            log.debugf("Writing new customization channel to %s", (Object)tempFile);
            Files.writeString(tempFile, (CharSequence)ChannelManifestMapper.toYaml((ChannelManifest)manifest), new OpenOption[0]);
            String newVersion = this.incrementVersion(version.orElse("1.0.0.Final-rev00000001"));
            log.debugf("Deploying new customization channel as version %s to %s", (Object)newVersion, (Object)this.targetRepository);
            DefaultArtifact channelArtifact = new DefaultArtifact(coordinate.getGroupId(), coordinate.getArtifactId(), "manifest", "yaml", newVersion, null, tempFile.toFile());
            channelArtifact.setFile(tempFile.toFile());
            DeployRequest deployRequest = new DeployRequest();
            deployRequest.setRepository(this.targetRepository);
            deployRequest.setArtifacts(Arrays.asList(channelArtifact));
            this.system.deploy((RepositorySystemSession)this.session, deployRequest);
        }
        finally {
            Files.delete(tempFile);
        }
    }

    private String incrementVersion(String baseVersion) {
        Pattern versionSuffixFormat = Pattern.compile(".*-rev\\d{8}");
        if (!versionSuffixFormat.matcher(baseVersion).matches()) {
            throw ProsperoLogger.ROOT_LOGGER.wrongVersionFormat(baseVersion);
        }
        String suffix = "-rev";
        int suffixIndex = baseVersion.lastIndexOf("-rev") + "-rev".length();
        String suffixVersion = baseVersion.substring(suffixIndex);
        String coreVersion = baseVersion.substring(0, suffixIndex);
        int currentVersion = Integer.parseInt(suffixVersion);
        if (currentVersion == 99999999) {
            throw ProsperoLogger.ROOT_LOGGER.versionLimitExceeded(baseVersion);
        }
        return String.format("%s%08d", coreVersion, currentVersion + 1);
    }
}

