/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.wildfly.prospero.model.FeaturePackTemplate;

class FeaturePackTemplateList {
    private static final String DEFAULT_VERSION = "1.0.0";
    private static final Set<String> KNOWN_SCHEMA_VERSIONS = Set.of("1.0.0");
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private String schemaVersion;
    private List<FeaturePackTemplate> recipes;

    public FeaturePackTemplateList(List<FeaturePackTemplate> recipes) {
        this(DEFAULT_VERSION, recipes);
    }

    @JsonCreator
    public FeaturePackTemplateList(@JsonProperty(value="schemaVersion", required=true) String schemaVersion, @JsonProperty(value="feature-packs") List<FeaturePackTemplate> recipes) {
        if (recipes == null) {
            recipes = Collections.emptyList();
        }
        this.validateUnique(recipes);
        this.schemaVersion = schemaVersion;
        this.recipes = recipes;
    }

    private void validateUnique(List<FeaturePackTemplate> recipes) {
        List recipeGavs = recipes.stream().map(r -> String.format("%s:%s:%s", r.getGroupId(), r.getArtifactId(), r.getVersion())).sorted().collect(Collectors.toList());
        String previousGav = "";
        for (String recipeGav : recipeGavs) {
            if (recipeGav.equals(previousGav)) {
                throw new IllegalArgumentException("Duplicated mappings for GAV: " + recipeGav);
            }
            previousGav = recipeGav;
        }
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<FeaturePackTemplate> getRecipes() {
        return this.recipes;
    }

    public String toYaml() throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString((Object)this);
    }

    public static FeaturePackTemplateList read(String yaml) throws JsonProcessingException {
        JsonNode schemaVersion = OBJECT_MAPPER.readTree(yaml).get("schemaVersion");
        if (schemaVersion == null || !KNOWN_SCHEMA_VERSIONS.contains(schemaVersion.asText())) {
            throw new IllegalArgumentException("Unknown schema version for the recipe book");
        }
        return (FeaturePackTemplateList)OBJECT_MAPPER.readValue(yaml, FeaturePackTemplateList.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeaturePackTemplateList that = (FeaturePackTemplateList)o;
        return Objects.equals(this.schemaVersion, that.schemaVersion) && Objects.equals(this.recipes, that.recipes);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.recipes);
    }

    public String toString() {
        return "FeaturePackTemplateList{schemaVersion='" + this.schemaVersion + "', recipes=" + String.valueOf(this.recipes) + "}";
    }
}

