/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.spi;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.galleon.ProvisioningException;
import org.jboss.logging.Logger;
import org.wildfly.channel.ChannelManifestCoordinate;
import org.wildfly.channel.MavenCoordinate;
import org.wildfly.channel.Repository;
import org.wildfly.installationmanager.ArtifactChange;
import org.wildfly.installationmanager.CandidateType;
import org.wildfly.installationmanager.Channel;
import org.wildfly.installationmanager.ChannelChange;
import org.wildfly.installationmanager.FileConflict;
import org.wildfly.installationmanager.HistoryResult;
import org.wildfly.installationmanager.ManifestVersion;
import org.wildfly.installationmanager.OperationNotAvailableException;
import org.wildfly.installationmanager.spi.InstallationManager;
import org.wildfly.installationmanager.spi.OsShell;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.actions.ApplyCandidateAction;
import org.wildfly.prospero.actions.InstallationExportAction;
import org.wildfly.prospero.actions.InstallationHistoryAction;
import org.wildfly.prospero.actions.MetadataAction;
import org.wildfly.prospero.actions.UpdateAction;
import org.wildfly.prospero.api.FileConflict;
import org.wildfly.prospero.api.InstallationChanges;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.api.SavedState;
import org.wildfly.prospero.api.exceptions.InvalidUpdateCandidateException;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.galleon.GalleonCallbackAdapter;
import org.wildfly.prospero.metadata.ManifestVersionRecord;
import org.wildfly.prospero.spi.internal.CliProvider;
import org.wildfly.prospero.updates.UpdateSet;

public class ProsperoInstallationManager
implements InstallationManager {
    private static final Logger logger = Logger.getLogger(GalleonCallbackAdapter.class);
    private final ActionFactory actionFactory;
    private Path installationDir;

    public ProsperoInstallationManager(Path installationDir, org.wildfly.installationmanager.MavenOptions mavenOptions) throws Exception {
        MavenOptions.Builder options = MavenOptions.builder().setOffline(mavenOptions.isOffline());
        if (mavenOptions.getLocalRepository() != null) {
            options.setNoLocalCache(false);
            options.setLocalCachePath(mavenOptions.getLocalRepository());
        }
        this.actionFactory = new ActionFactory(installationDir, options.build());
        this.installationDir = installationDir;
    }

    protected ProsperoInstallationManager(ActionFactory actionFactory) {
        this.actionFactory = actionFactory;
    }

    public List<HistoryResult> history() throws Exception {
        logger.info((Object)"Listing installation history");
        InstallationHistoryAction historyAction = this.actionFactory.getHistoryAction();
        List<SavedState> revisions = historyAction.getRevisions();
        ArrayList<HistoryResult> results = new ArrayList<HistoryResult>();
        for (SavedState savedState : revisions) {
            results.add(new HistoryResult(savedState.getName(), savedState.getTimestamp(), savedState.getType().toString(), savedState.getMsg(), Collections.emptyList()));
        }
        return results;
    }

    public org.wildfly.installationmanager.InstallationChanges revisionDetails(String revision) throws MetadataException {
        Objects.requireNonNull(revision);
        InstallationHistoryAction historyAction = this.actionFactory.getHistoryAction();
        InstallationChanges changes = historyAction.getRevisionChanges(new SavedState(revision));
        if (changes.isEmpty()) {
            return new org.wildfly.installationmanager.InstallationChanges(Collections.emptyList(), Collections.emptyList());
        }
        List artifacts = changes.getArtifactChanges().stream().map(ProsperoInstallationManager::mapArtifactChange).collect(Collectors.toList());
        List channels = changes.getChannelChanges().stream().map(ProsperoInstallationManager::mapChannelChange).collect(Collectors.toList());
        return new org.wildfly.installationmanager.InstallationChanges(artifacts, channels);
    }

    public void prepareRevert(String revision, Path targetDir, List<org.wildfly.installationmanager.Repository> repositories) throws Exception {
        Objects.requireNonNull(revision);
        Objects.requireNonNull(targetDir);
        InstallationHistoryAction historyAction = this.actionFactory.getHistoryAction();
        historyAction.prepareRevert(new SavedState(revision), this.actionFactory.mavenOptions, ProsperoInstallationManager.map(repositories, ProsperoInstallationManager::mapRepository), targetDir);
    }

    public boolean prepareUpdate(Path targetDir, List<org.wildfly.installationmanager.Repository> repositories) throws Exception {
        try (UpdateAction prepareUpdateAction = this.actionFactory.getUpdateAction(ProsperoInstallationManager.map(repositories, ProsperoInstallationManager::mapRepository));){
            boolean bl = prepareUpdateAction.buildUpdate(targetDir);
            return bl;
        }
    }

    public Collection<FileConflict> verifyCandidate(Path candidatePath, CandidateType candidateType) throws Exception {
        ApplyCandidateAction applyCandidateAction = this.actionFactory.getApplyCandidateAction(candidatePath);
        ApplyCandidateAction.Type operation = switch (candidateType) {
            case CandidateType.UPDATE -> ApplyCandidateAction.Type.UPDATE;
            case CandidateType.REVERT -> ApplyCandidateAction.Type.REVERT;
            default -> throw new IllegalArgumentException("Unsupported candidate type: " + String.valueOf(candidateType));
        };
        ApplyCandidateAction.ValidationResult validationResult = applyCandidateAction.verifyCandidate(operation);
        switch (validationResult) {
            case OK: {
                break;
            }
            case STALE: {
                throw ProsperoLogger.ROOT_LOGGER.staleCandidate(this.installationDir, candidatePath);
            }
            case NO_CHANGES: {
                throw ProsperoLogger.ROOT_LOGGER.noChangesAvailable(this.installationDir, candidatePath);
            }
            case NOT_CANDIDATE: {
                throw ProsperoLogger.ROOT_LOGGER.notCandidate(candidatePath);
            }
            case WRONG_TYPE: {
                throw ProsperoLogger.ROOT_LOGGER.wrongCandidateOperation(candidatePath, operation);
            }
            default: {
                throw new InvalidUpdateCandidateException(String.format("The candidate server %s is invalid - %s.", new Object[]{candidatePath, validationResult}));
            }
        }
        return ProsperoInstallationManager.map(applyCandidateAction.getConflicts(), ProsperoInstallationManager::mapFileConflict);
    }

    private static FileConflict mapFileConflict(org.wildfly.prospero.api.FileConflict fileConflict) {
        return new FileConflict(Path.of(fileConflict.getRelativePath(), new String[0]), ProsperoInstallationManager.map(fileConflict.getUserChange()), ProsperoInstallationManager.map(fileConflict.getUpdateChange()), fileConflict.getResolution() == FileConflict.Resolution.UPDATE);
    }

    private static FileConflict.Status map(FileConflict.Change change) {
        switch (change) {
            case MODIFIED: {
                return FileConflict.Status.MODIFIED;
            }
            case ADDED: {
                return FileConflict.Status.ADDED;
            }
            case REMOVED: {
                return FileConflict.Status.REMOVED;
            }
            case NONE: {
                return FileConflict.Status.NONE;
            }
        }
        throw new IllegalArgumentException("Unknown file conflict change: " + String.valueOf((Object)change));
    }

    public List<ArtifactChange> findUpdates(List<org.wildfly.installationmanager.Repository> repositories) throws Exception {
        try (UpdateAction updateAction = this.actionFactory.getUpdateAction(ProsperoInstallationManager.map(repositories, ProsperoInstallationManager::mapRepository));){
            UpdateSet updates = updateAction.findUpdates();
            List<ArtifactChange> list = updates.getArtifactUpdates().stream().map(ProsperoInstallationManager::mapArtifactChange).collect(Collectors.toList());
            return list;
        }
    }

    public Collection<Channel> listChannels() throws OperationException {
        try (MetadataAction metadataAction = this.actionFactory.getMetadataAction();){
            Collection collection = metadataAction.getChannels().stream().map(ProsperoInstallationManager::mapChannel).collect(Collectors.toList());
            return collection;
        }
    }

    public void removeChannel(String channelName) throws OperationException {
        try (MetadataAction metadataAction = this.actionFactory.getMetadataAction();){
            metadataAction.removeChannel(channelName);
        }
    }

    public void addChannel(Channel channel) throws OperationException {
        try (MetadataAction metadataAction = this.actionFactory.getMetadataAction();){
            metadataAction.addChannel(ProsperoInstallationManager.mapChannel(channel));
        }
    }

    public void changeChannel(Channel newChannel) throws OperationException {
        if (newChannel.getName() == null || newChannel.getName().isEmpty()) {
            throw ProsperoLogger.ROOT_LOGGER.emptyChannelName();
        }
        try (MetadataAction metadataAction = this.actionFactory.getMetadataAction();){
            metadataAction.changeChannel(newChannel.getName(), ProsperoInstallationManager.mapChannel(newChannel));
        }
    }

    public Path createSnapshot(Path targetPath) throws Exception {
        Path snapshotPath;
        if (!Files.exists(targetPath, new LinkOption[0])) {
            if (targetPath.toString().toLowerCase().endsWith(".zip")) {
                snapshotPath = targetPath.toAbsolutePath();
            } else {
                timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                snapshotPath = targetPath.resolve("im-snapshot-" + timestamp + ".zip").toAbsolutePath();
            }
        } else if (Files.isDirectory(targetPath, new LinkOption[0])) {
            timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            snapshotPath = targetPath.resolve("im-snapshot-" + timestamp + ".zip").toAbsolutePath();
        } else {
            throw ProsperoLogger.ROOT_LOGGER.fileAlreadyExists(targetPath);
        }
        InstallationExportAction installationExportAction = this.actionFactory.getInstallationExportAction();
        installationExportAction.export(snapshotPath);
        return snapshotPath;
    }

    public String generateApplyUpdateCommand(Path scriptHome, Path candidatePath) throws OperationNotAvailableException {
        boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
        return this.generateApplyUpdateCommand(scriptHome, candidatePath, isWindows ? OsShell.WindowsBash : OsShell.Linux);
    }

    public String generateApplyRevertCommand(Path scriptHome, Path candidatePath) throws OperationNotAvailableException {
        boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
        return this.generateApplyRevertCommand(scriptHome, candidatePath, isWindows ? OsShell.WindowsBash : OsShell.Linux);
    }

    public String generateApplyUpdateCommand(Path scriptHome, Path candidatePath, OsShell shell) throws OperationNotAvailableException {
        return this.generateApplyUpdateCommand(scriptHome, candidatePath, shell, false);
    }

    public String generateApplyRevertCommand(Path scriptHome, Path candidatePath, OsShell shell) throws OperationNotAvailableException {
        return this.generateApplyRevertCommand(scriptHome, candidatePath, shell, false);
    }

    public String generateApplyUpdateCommand(Path scriptHome, Path candidatePath, OsShell shell, boolean noConflictsOnly) throws OperationNotAvailableException {
        Optional<CliProvider> cliProviderLoader = ServiceLoader.load(CliProvider.class).findFirst();
        if (cliProviderLoader.isEmpty()) {
            throw new OperationNotAvailableException("Installation manager does not support CLI operations.");
        }
        CliProvider cliProvider = cliProviderLoader.get();
        return this.escape(scriptHome.resolve(cliProvider.getScriptName(shell))) + " " + cliProvider.getApplyUpdateCommand(this.installationDir, candidatePath, false);
    }

    public String generateApplyRevertCommand(Path scriptHome, Path candidatePath, OsShell shell, boolean noConflictsOnly) throws OperationNotAvailableException {
        Optional<CliProvider> cliProviderLoader = ServiceLoader.load(CliProvider.class).findFirst();
        if (cliProviderLoader.isEmpty()) {
            throw new OperationNotAvailableException("Installation manager does not support CLI operations.");
        }
        CliProvider cliProvider = cliProviderLoader.get();
        return this.escape(scriptHome.resolve(cliProvider.getScriptName(shell))) + " " + cliProvider.getApplyRevertCommand(this.installationDir, candidatePath, noConflictsOnly);
    }

    public Collection<ManifestVersion> getInstalledVersions() throws MetadataException {
        try (MetadataAction metadataAction = this.actionFactory.getMetadataAction();){
            ManifestVersionRecord versionRecord = metadataAction.getChannelVersions();
            Collection collection = Stream.concat(versionRecord.getMavenManifests().stream().map(m -> new ManifestVersion(m.getGroupId() + ":" + m.getArtifactId(), m.getDescription(), m.getVersion(), ManifestVersion.Type.MAVEN)), versionRecord.getUrlManifests().stream().map(m -> new ManifestVersion(m.getUrl(), m.getDescription(), m.getHash(), ManifestVersion.Type.URL))).collect(Collectors.toList());
            return collection;
        }
    }

    private String escape(Path absolutePath) {
        return "\"" + absolutePath.toString() + "\"";
    }

    private static Channel mapChannel(org.wildfly.channel.Channel channel) {
        if (channel.getManifestCoordinate() == null) {
            return new Channel(channel.getName(), ProsperoInstallationManager.map(channel.getRepositories(), ProsperoInstallationManager::mapRepository));
        }
        if (channel.getManifestCoordinate().getUrl() != null) {
            return new Channel(channel.getName(), ProsperoInstallationManager.map(channel.getRepositories(), ProsperoInstallationManager::mapRepository), channel.getManifestCoordinate().getUrl());
        }
        if (channel.getManifestCoordinate().getMaven() != null) {
            return new Channel(channel.getName(), ProsperoInstallationManager.map(channel.getRepositories(), ProsperoInstallationManager::mapRepository), ProsperoInstallationManager.toGav(channel.getManifestCoordinate().getMaven()));
        }
        return new Channel(channel.getName(), ProsperoInstallationManager.map(channel.getRepositories(), ProsperoInstallationManager::mapRepository));
    }

    private static String toGav(MavenCoordinate coord) {
        String ga = coord.getGroupId() + ":" + coord.getArtifactId();
        if (coord.getVersion() != null && !coord.getVersion().isEmpty()) {
            return ga + ":" + coord.getVersion();
        }
        return ga;
    }

    private static org.wildfly.channel.Channel mapChannel(Channel channel) {
        return new org.wildfly.channel.Channel(channel.getName(), null, null, ProsperoInstallationManager.map(channel.getRepositories(), ProsperoInstallationManager::mapRepository), ProsperoInstallationManager.toManifestCoordinate(channel), null, null);
    }

    private static ChannelManifestCoordinate toManifestCoordinate(Channel c) {
        if (c.getManifestUrl().isPresent()) {
            return new ChannelManifestCoordinate((URL)c.getManifestUrl().get());
        }
        if (c.getManifestCoordinate().isPresent()) {
            String[] coordinate = ((String)c.getManifestCoordinate().get()).split(":");
            if (coordinate.length == 3) {
                return new ChannelManifestCoordinate(coordinate[0], coordinate[1], coordinate[2]);
            }
            return new ChannelManifestCoordinate(coordinate[0], coordinate[1]);
        }
        return null;
    }

    private static <T, R> List<R> map(List<T> subject, Function<T, R> mapper) {
        if (subject == null) {
            return Collections.emptyList();
        }
        return subject.stream().map(mapper::apply).collect(Collectors.toList());
    }

    private static Repository mapRepository(org.wildfly.installationmanager.Repository repository) {
        return new Repository(repository.getId(), repository.getUrl());
    }

    private static org.wildfly.installationmanager.Repository mapRepository(Repository repository) {
        return new org.wildfly.installationmanager.Repository(repository.getId(), repository.getUrl());
    }

    private static ArtifactChange mapArtifactChange(org.wildfly.prospero.api.ArtifactChange change) {
        if (change.isInstalled()) {
            return new ArtifactChange(null, change.getNewVersion().get(), change.getArtifactName(), ArtifactChange.Status.INSTALLED);
        }
        if (change.isRemoved()) {
            return new ArtifactChange(change.getOldVersion().get(), null, change.getArtifactName(), ArtifactChange.Status.REMOVED);
        }
        return new ArtifactChange(change.getOldVersion().get(), change.getNewVersion().get(), change.getArtifactName(), ArtifactChange.Status.UPDATED);
    }

    private static ChannelChange mapChannelChange(org.wildfly.prospero.api.ChannelChange change) {
        Channel oldChannel = change.getOldChannel() == null ? null : ProsperoInstallationManager.mapChannel(change.getOldChannel());
        Channel newChannel = change.getNewChannel() == null ? null : ProsperoInstallationManager.mapChannel(change.getNewChannel());
        switch (change.getStatus()) {
            case ADDED: {
                return new ChannelChange(oldChannel, newChannel, ChannelChange.Status.ADDED);
            }
            case REMOVED: {
                return new ChannelChange(oldChannel, newChannel, ChannelChange.Status.REMOVED);
            }
        }
        return new ChannelChange(oldChannel, newChannel, ChannelChange.Status.MODIFIED);
    }

    ActionFactory getActionFactory() {
        return this.actionFactory;
    }

    protected static class ActionFactory {
        private final Path server;
        private final MavenOptions mavenOptions;

        private ActionFactory(Path server, MavenOptions mavenOptions) {
            this.server = server;
            this.mavenOptions = mavenOptions;
        }

        protected InstallationHistoryAction getHistoryAction() {
            return new InstallationHistoryAction(this.server, null);
        }

        protected UpdateAction getUpdateAction(List<Repository> repositories) throws OperationException, ProvisioningException {
            return new UpdateAction(this.server, this.mavenOptions, null, repositories);
        }

        protected MetadataAction getMetadataAction() throws MetadataException {
            return new MetadataAction(this.server);
        }

        protected InstallationExportAction getInstallationExportAction() {
            return new InstallationExportAction(this.server);
        }

        protected ApplyCandidateAction getApplyCandidateAction(Path candidateDir) throws ProvisioningException, OperationException {
            return new ApplyCandidateAction(this.server, candidateDir);
        }

        MavenOptions getMavenOptions() {
            return this.mavenOptions;
        }
    }
}

