package org.wildfly.prospero;

import java.util.Locale;
import org.wildfly.prospero.api.exceptions.NoChannelException;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.wildfly.channel.InvalidChannelMetadataException;
import org.jboss.galleon.universe.FeaturePackLocation;
import java.lang.String;
import org.jboss.logging.Logger;
import java.net.URI;
import org.wildfly.prospero.api.exceptions.MetadataException;
import java.net.URL;
import java.lang.RuntimeException;
import org.jboss.logging.BasicLogger;
import org.jboss.galleon.ProvisioningException;
import java.util.List;
import org.wildfly.prospero.api.exceptions.ChannelDefinitionException;
import java.lang.IllegalArgumentException;
import org.wildfly.prospero.api.exceptions.ProvisioningRuntimeException;
import java.nio.file.Path;
import org.wildfly.prospero.api.exceptions.ArtifactPromoteException;
import javax.annotation.processing.Generated;
import org.wildfly.prospero.actions.FeaturesAddAction.FeaturePackAlreadyInstalledException;
import org.wildfly.prospero.api.exceptions.InvalidUpdateCandidateException;
import java.io.IOException;
import java.lang.Exception;
import org.wildfly.prospero.actions.ApplyCandidateAction.Type;
import org.wildfly.prospero.api.exceptions.InvalidRepositoryArchiveException;
import java.lang.Throwable;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2025-05-12T13:49:12+0000")
public class ProsperoLogger_$logger extends DelegatingBasicLogger implements ProsperoLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ProsperoLogger_$logger.class.getName();
    public ProsperoLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void historyDetails(final String savedStateName, final Path path) {
        super.log.logf(FQCN, INFO, null, historyDetails$str(), savedStateName, path);
    }
    protected String historyDetails$str() {
        return "PRSP000001: Getting details of %s of %s";
    }
    @Override
    public final void listHistory(final Path path) {
        super.log.logf(FQCN, INFO, null, listHistory$str(), path);
    }
    protected String listHistory$str() {
        return "PRSP000002: Listing history of %s";
    }
    @Override
    public final void revertStarted(final Path installationPath, final String savedStateName) {
        super.log.logf(FQCN, INFO, null, revertStarted$str(), installationPath, savedStateName);
    }
    protected String revertStarted$str() {
        return "PRSP000003: Reverting %s to %s";
    }
    @Override
    public final void revertCompleted(final Path installationPath, final String savedStateName) {
        super.log.logf(FQCN, INFO, null, revertCompleted$str(), installationPath, savedStateName);
    }
    protected String revertCompleted$str() {
        return "PRSP000004: Reverted %s to %s";
    }
    @Override
    public final void revertCandidateStarted(final Path installationPath) {
        super.log.logf(FQCN, INFO, null, revertCandidateStarted$str(), installationPath);
    }
    protected String revertCandidateStarted$str() {
        return "PRSP000005: Building revert candidate for %s";
    }
    @Override
    public final void revertCandidateCompleted(final Path installationPath) {
        super.log.logf(FQCN, INFO, null, revertCandidateCompleted$str(), installationPath);
    }
    protected String revertCandidateCompleted$str() {
        return "PRSP000006: Revert candidate generated in %s";
    }
    @Override
    public final void temporaryCandidateFolder(final Path tempPath) {
        super.log.logf(FQCN, DEBUG, null, temporaryCandidateFolder$str(), tempPath);
    }
    protected String temporaryCandidateFolder$str() {
        return "PRSP000007: Created temporary candidate folder %s";
    }
    @Override
    public final void performUpdateStarted(final Path installaPath) {
        super.log.logf(FQCN, INFO, null, performUpdateStarted$str(), installaPath);
    }
    protected String performUpdateStarted$str() {
        return "PRSP000008: Performing update of %s";
    }
    @Override
    public final void noUpdatesFound(final Path installationPath) {
        super.log.logf(FQCN, INFO, null, noUpdatesFound$str(), installationPath);
    }
    protected String noUpdatesFound$str() {
        return "PRSP000009: Aborting update - no updates found for %s";
    }
    @Override
    public final void updateCandidateStarted(final Path installationPath) {
        super.log.logf(FQCN, INFO, null, updateCandidateStarted$str(), installationPath);
    }
    protected String updateCandidateStarted$str() {
        return "PRSP000010: Building update candidate for %s";
    }
    @Override
    public final void updateCandidateCompleted(final Path installationPath) {
        super.log.logf(FQCN, INFO, null, updateCandidateCompleted$str(), installationPath);
    }
    protected String updateCandidateCompleted$str() {
        return "PRSP000011: Update candidate generated in %s";
    }
    @Override
    public final void checkingUpdates() {
        super.log.logf(FQCN, INFO, null, checkingUpdates$str());
    }
    protected String checkingUpdates$str() {
        return "PRSP000012: Checking available updates";
    }
    @Override
    public final void updatesFound(final int count) {
        super.log.logf(FQCN, INFO, null, updatesFound$str(), count);
    }
    protected String updatesFound$str() {
        return "PRSP000013: Found %d updates";
    }
    @Override
    public final void addingChannel(final String channel) {
        super.log.logf(FQCN, INFO, null, addingChannel$str(), channel);
    }
    protected String addingChannel$str() {
        return "PRSP000014: Adding channel %s";
    }
    @Override
    public final void existingChannel(final String channelName) {
        super.log.logf(FQCN, WARN, null, existingChannel$str(), channelName);
    }
    protected String existingChannel$str() {
        return "PRSP000015: Channel %s already exists";
    }
    @Override
    public final void channelAdded(final String channelName) {
        super.log.logf(FQCN, INFO, null, channelAdded$str(), channelName);
    }
    protected String channelAdded$str() {
        return "PRSP000016: Channel %s added";
    }
    @Override
    public final void removingChannel(final String channelName) {
        super.log.logf(FQCN, INFO, null, removingChannel$str(), channelName);
    }
    protected String removingChannel$str() {
        return "PRSP000017: Removing channel %s";
    }
    @Override
    public final void channelRemoved(final String channelName) {
        super.log.logf(FQCN, INFO, null, channelRemoved$str(), channelName);
    }
    protected String channelRemoved$str() {
        return "PRSP000019: Channel removed %s";
    }
    @Override
    public final void updatingChannel(final String channelDesc, final String channelName) {
        super.log.logf(FQCN, INFO, null, updatingChannel$str(), channelDesc, channelName);
    }
    protected String updatingChannel$str() {
        return "PRSP000020: Updating channel %s as %s";
    }
    @Override
    public final void channelUpdated(final String channelName) {
        super.log.logf(FQCN, INFO, null, channelUpdated$str(), channelName);
    }
    protected String channelUpdated$str() {
        return "PRSP000021: Channel %s updated";
    }
    @Override
    public final void listChannels() {
        super.log.logf(FQCN, INFO, null, listChannels$str());
    }
    protected String listChannels$str() {
        return "PRSP000022: Listing subscribed channels";
    }
    @Override
    public final void startedPhase(final String name, final String count) {
        super.log.logf(FQCN, INFO, null, startedPhase$str(), name, count);
    }
    protected String startedPhase$str() {
        return "PRSP000023: Starting phase: [%s] %s";
    }
    @Override
    public final void completedPhase(final String name, final String count) {
        super.log.logf(FQCN, INFO, null, completedPhase$str(), name, count);
    }
    protected String completedPhase$str() {
        return "PRSP000024: Completed phase: [%s] %s";
    }
    @Override
    public final void applyingCandidate(final String operationName, final Path updateDir) {
        super.log.logf(FQCN, INFO, null, applyingCandidate$str(), operationName, updateDir);
    }
    protected String applyingCandidate$str() {
        return "PRSP000025: Applying %s candidate from %s";
    }
    @Override
    public final void candidateChanges(final String changes) {
        super.log.logf(FQCN, INFO, null, candidateChanges$str(), changes);
    }
    protected String candidateChanges$str() {
        return "PRSP000026: Changed artifacts [%s]";
    }
    @Override
    public final void noCandidateConflicts() {
        super.log.logf(FQCN, INFO, null, noCandidateConflicts$str());
    }
    protected String noCandidateConflicts$str() {
        return "PRSP000027: No conflicts found.";
    }
    @Override
    public final void candidateConflicts(final String conflicts) {
        super.log.logf(FQCN, INFO, null, candidateConflicts$str(), conflicts);
    }
    protected String candidateConflicts$str() {
        return "PRSP000028: File conflicts found: [%s]";
    }
    @Override
    public final void candidateApplied(final String operation, final Path installationDir) {
        super.log.logf(FQCN, INFO, null, candidateApplied$str(), operation, installationDir);
    }
    protected String candidateApplied$str() {
        return "PRSP000029: %s candidate applied to %s";
    }
    @Override
    public final void startingProvision(final Path installDir) {
        super.log.logf(FQCN, INFO, null, startingProvision$str(), installDir);
    }
    protected String startingProvision$str() {
        return "PRSP000030: Starting provisioning into %s";
    }
    @Override
    public final void provisioningComplete(final Path installDir) {
        super.log.logf(FQCN, INFO, null, provisioningComplete$str(), installDir);
    }
    protected String provisioningComplete$str() {
        return "PRSP000031: Server provisioned into %s";
    }
    protected String serverRunningError$str() {
        return "PRSP000200: Aborting update - the server appears to be running.";
    }
    @Override
    public final ProvisioningException serverRunningError() {
        final ProvisioningException result = new ProvisioningException(String.format(getLoggingLocale(), serverRunningError$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String dirMustBeDirectory$str() {
        return "PRSP000201: Given path '%s' is a regular file. An empty directory or a non-existing path must be given.";
    }
    @Override
    public final IllegalArgumentException dirMustBeDirectory(final Path path) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), dirMustBeDirectory$str(), path));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidManifest$str() {
        return "PRSP000202: Invalid channel manifest definition";
    }
    @Override
    public final ChannelDefinitionException invalidManifest(final InvalidChannelMetadataException e) {
        final ChannelDefinitionException result = new ChannelDefinitionException(String.format(getLoggingLocale(), invalidManifest$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotInstallIntoNonEmptyDirectory$str() {
        return "PRSP000203: Can't install the server into a non empty directory '%s'.";
    }
    @Override
    public final IllegalArgumentException cannotInstallIntoNonEmptyDirectory(final Path path) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotInstallIntoNonEmptyDirectory$str(), path));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String installationDirDoesNotExist$str() {
        return "PRSP000204: Installation dir '%s' doesn't exist";
    }
    @Override
    public final IllegalArgumentException installationDirDoesNotExist(final Path path) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), installationDirDoesNotExist$str(), path));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String installationDirAlreadyExists$str() {
        return "PRSP000205: Installation dir '%s' already exists";
    }
    @Override
    public final ProvisioningException installationDirAlreadyExists(final Path installDir) {
        final ProvisioningException result = new ProvisioningException(String.format(getLoggingLocale(), installationDirAlreadyExists$str(), installDir));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noChannelReference$str() {
        return "PRSP000206: Given configuration doesn't reference any channel or channel manifest.";
    }
    @Override
    public final NoChannelException noChannelReference() {
        final NoChannelException result = new NoChannelException(String.format(getLoggingLocale(), noChannelReference$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noChannelManifestReference$str() {
        return "PRSP000207: Invalid channel: Channel '%s' doesn't reference a manifest.";
    }
    @Override
    public final NoChannelException noChannelManifestReference(final String name) {
        final NoChannelException result = new NoChannelException(String.format(getLoggingLocale(), noChannelManifestReference$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fplDefinitionDoesntContainChannel$str() {
        return "PRSP000208: Pre-defined FPL [%s] doesn't specify any channels and no explicit channels were given.";
    }
    @Override
    public final NoChannelException fplDefinitionDoesntContainChannel(final String fpl) {
        final NoChannelException result = new NoChannelException(String.format(getLoggingLocale(), fplDefinitionDoesntContainChannel$str(), fpl));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String channelExists$str() {
        return "PRSP000209: Channel '%s' is already present.";
    }
    @Override
    public final MetadataException channelExists(final String channelName) {
        final MetadataException result = new MetadataException(String.format(getLoggingLocale(), channelExists$str(), channelName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String channelNotFound$str() {
        return "PRSP000210: Channel with name [%s] cannot be found.";
    }
    @Override
    public final MetadataException channelNotFound(final String channelName) {
        final MetadataException result = new MetadataException(String.format(getLoggingLocale(), channelNotFound$str(), channelName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String emptyChannelName$str() {
        return "PRSP000211: Channel name cannot be empty.";
    }
    @Override
    public final MetadataException emptyChannelName() {
        final MetadataException result = new MetadataException(String.format(getLoggingLocale(), emptyChannelName$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String promotingArtifacts$str() {
        return "PRSP000212: Promoting artifacts to %s:";
    }
    @Override
    public final String promotingArtifacts(final URL targetRepository) {
        return String.format(getLoggingLocale(), promotingArtifacts$str(), targetRepository);
    }
    protected String unableToParseConfiguration$str() {
        return "PRSP000213: Unable to parse server configuration at '%s'";
    }
    @Override
    public final MetadataException unableToParseConfiguration(final Path path, final Throwable e) {
        final MetadataException result = new MetadataException(String.format(getLoggingLocale(), unableToParseConfiguration$str(), path), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToParseConfigurationUri$str() {
        return "PRSP000214: Unable to parse server configuration at '%s'";
    }
    @Override
    public final MetadataException unableToParseConfigurationUri(final URI uri, final Throwable e) {
        final MetadataException result = new MetadataException(String.format(getLoggingLocale(), unableToParseConfigurationUri$str(), uri), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToReadFile$str() {
        return "PRSP000215: Unable to read file at [%s]";
    }
    @Override
    public final MetadataException unableToReadFile(final Path path, final Exception e) {
        final MetadataException result = new MetadataException(String.format(getLoggingLocale(), unableToReadFile$str(), path), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidUpdateCandidate$str() {
        return "PRSP000216: The installation at %s is not a valid update for %s";
    }
    @Override
    public final InvalidUpdateCandidateException invalidUpdateCandidate(final Path update, final Path installation) {
        final InvalidUpdateCandidateException result = new InvalidUpdateCandidateException(String.format(getLoggingLocale(), invalidUpdateCandidate$str(), update, installation));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToSaveConfiguration$str() {
        return "PRSP000217: Unable to save server configuration at '%s'";
    }
    @Override
    public final MetadataException unableToSaveConfiguration(final Path path, final Exception e) {
        final MetadataException result = new MetadataException(String.format(getLoggingLocale(), unableToSaveConfiguration$str(), path), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void unableToCloseStore(final Exception e) {
        super.log.logf(FQCN, WARN, e, unableToCloseStore$str());
    }
    protected String unableToCloseStore$str() {
        return "PRSP000218: Unable to close the update store.";
    }
    protected String unableToCreateHistoryStorage$str() {
        return "PRSP000219: Unable to create history store at [%s]";
    }
    @Override
    public final MetadataException unableToCreateHistoryStorage(final Path path, final Exception e) {
        final MetadataException result = new MetadataException(String.format(getLoggingLocale(), unableToCreateHistoryStorage$str(), path), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String incompleteMetadataBundle$str() {
        return "PRSP000220: Provided metadata bundle [%s] is missing one or more entries";
    }
    @Override
    public final IllegalArgumentException incompleteMetadataBundle(final Path path) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), incompleteMetadataBundle$str(), path));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToWriteFile$str() {
        return "PRSP000221: Unable to write file at [%s]";
    }
    @Override
    public final MetadataException unableToWriteFile(final Path path, final Exception e) {
        final MetadataException result = new MetadataException(String.format(getLoggingLocale(), unableToWriteFile$str(), path), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidInstallationDir$str() {
        return "PRSP000222: Path `%s` does not contain a server installation provisioned by prospero. Missing required files: %s";
    }
    @Override
    public final IllegalArgumentException invalidInstallationDir(final Path path, final List<Path> missingFolders) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidInstallationDir$str(), path, missingFolders));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToAccessHistoryStorage$str() {
        return "PRSP000223: Unable to access history store at [%s]";
    }
    @Override
    public final MetadataException unableToAccessHistoryStorage(final Path path, final Exception e) {
        final MetadataException result = new MetadataException(String.format(getLoggingLocale(), unableToAccessHistoryStorage$str(), path), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToDownloadFile$str() {
        return "PRSP000224: Unable to download file";
    }
    @Override
    public final MetadataException unableToDownloadFile(final Exception e) {
        final MetadataException result = new MetadataException(String.format(getLoggingLocale(), unableToDownloadFile$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCreateCache$str() {
        return "PRSP000225: Unable to create temporary cache for provisioning cache folder.";
    }
    @Override
    public final ProvisioningException unableToCreateCache(final Exception e) {
        final ProvisioningException result = new ProvisioningException(String.format(getLoggingLocale(), unableToCreateCache$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToInitMaven$str() {
        return "PRSP000226: Failed to initiate maven repository system";
    }
    @Override
    public final ProvisioningRuntimeException failedToInitMaven(final Throwable exception) {
        final ProvisioningRuntimeException result = new ProvisioningRuntimeException(String.format(getLoggingLocale(), failedToInitMaven$str()));
        result.initCause(exception);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String streamNotFound$str() {
        return "PRSP000227: Unable to find required stream definitions";
    }
    @Override
    public final String streamNotFound() {
        return String.format(getLoggingLocale(), streamNotFound$str());
    }
    protected String unableToResolve$str() {
        return "PRSP000228: Unable to resolve artifact";
    }
    @Override
    public final String unableToResolve() {
        return String.format(getLoggingLocale(), unableToResolve$str());
    }
    protected String invalidUrl$str() {
        return "PRSP000229: Invalid URL [%s]";
    }
    @Override
    public final IllegalArgumentException invalidUrl(final String text, final Exception e) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidUrl$str(), text), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String predefinedFplOrChannelRequired$str() {
        return "PRSP000230: Incomplete configuration: If the FPL is not one of predefined names (%s) a channel must be given.";
    }
    @Override
    public final IllegalArgumentException predefinedFplOrChannelRequired(final String availableFpls) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), predefinedFplOrChannelRequired$str(), availableFpls));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fplNorGalleonConfigWereSet$str() {
        return "PRSP000231: Incomplete configuration: neither FPL nor Galleon provisioning config was given.";
    }
    @Override
    public final IllegalArgumentException fplNorGalleonConfigWereSet() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), fplNorGalleonConfigWereSet$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedArtifact$str() {
        return "PRSP000232: Found unexpected artifact [%s]";
    }
    @Override
    public final ProvisioningRuntimeException unexpectedArtifact(final String gav) {
        final ProvisioningRuntimeException result = new ProvisioningRuntimeException(String.format(getLoggingLocale(), unexpectedArtifact$str(), gav));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fileAlreadyExists$str() {
        return "PRSP000233: File already exists [%s]";
    }
    @Override
    public final IllegalArgumentException fileAlreadyExists(final Path path) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), fileAlreadyExists$str(), path));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedPromotionTarget$str() {
        return "PRSP000234: Promoting to non-file repositories is not currently supported";
    }
    @Override
    public final IllegalArgumentException unsupportedPromotionTarget() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unsupportedPromotionTarget$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String wrongVersionFormat$str() {
        return "PRSP000235: Wrong format of custom channel version [%s]";
    }
    @Override
    public final IllegalArgumentException wrongVersionFormat(final String baseVersion) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), wrongVersionFormat$str(), baseVersion));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String versionLimitExceeded$str() {
        return "PRSP000236: Custom channel version exceeded limit [%s]";
    }
    @Override
    public final IllegalArgumentException versionLimitExceeded(final String baseVersion) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), versionLimitExceeded$str(), baseVersion));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noArtifactsToPackage$str() {
        return "PRSP000237: Cannot create bundle without artifacts.";
    }
    @Override
    public final IllegalArgumentException noArtifactsToPackage() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noArtifactsToPackage$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonMavenChannelRef$str() {
        return "PRSP000238: Channel reference has to use Maven GA.";
    }
    @Override
    public final IllegalArgumentException nonMavenChannelRef() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nonMavenChannelRef$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToPromote$str() {
        return "PRSP000239: Unable to promote artifacts to [%s].";
    }
    @Override
    public final ArtifactPromoteException unableToPromote(final URL target, final Exception e) {
        final ArtifactPromoteException result = new ArtifactPromoteException(String.format(getLoggingLocale(), unableToPromote$str(), target), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToParseCustomizationBundle$str() {
        return "PRSP000240: Unable to parse the customization bundle [%s].";
    }
    @Override
    public final ArtifactPromoteException unableToParseCustomizationBundle(final Path path, final Exception e) {
        final ArtifactPromoteException result = new ArtifactPromoteException(String.format(getLoggingLocale(), unableToParseCustomizationBundle$str(), path), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String repositoriesMustBeSetWithManifest$str() {
        return "PRSP000241: At least one repository must be set when using the manifest option.";
    }
    @Override
    public final IllegalArgumentException repositoriesMustBeSetWithManifest() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), repositoriesMustBeSetWithManifest$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String outFileExists$str() {
        return "PRSP000242: Out file [%s] exists already!";
    }
    @Override
    public final IllegalArgumentException outFileExists(final Path outPath) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), outFileExists$str(), outPath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String installationExported$str() {
        return "PRSP000243: Installation metadata is exported to [%s].";
    }
    @Override
    public final String installationExported(final Path outPath) {
        return String.format(getLoggingLocale(), installationExported$str(), outPath);
    }
    protected String invalidPropertySubstitutionValue$str() {
        return "PRSP000244: Malformed URL in substituted value : %s from %s";
    }
    @Override
    public final MetadataException invalidPropertySubstitutionValue(final String substituted, final String url) {
        final MetadataException result = new MetadataException(String.format(getLoggingLocale(), invalidPropertySubstitutionValue$str(), substituted, url));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String savedStateNotFound$str() {
        return "PRSP000245: The requested state %s does not exist in server's history.";
    }
    @Override
    public final MetadataException savedStateNotFound(final String name) {
        final MetadataException result = new MetadataException(String.format(getLoggingLocale(), savedStateNotFound$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCreateTemporaryDirectory$str() {
        return "PRSP000246: Unable to create temporary directory";
    }
    @Override
    public final ProvisioningException unableToCreateTemporaryDirectory(final Throwable t) {
        final ProvisioningException result = new ProvisioningException(String.format(getLoggingLocale(), unableToCreateTemporaryDirectory$str()), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidChannel$str() {
        return "PRSP000247: Invalid channel definition";
    }
    @Override
    public final ChannelDefinitionException invalidChannel(final InvalidChannelMetadataException e) {
        final ChannelDefinitionException result = new ChannelDefinitionException(String.format(getLoggingLocale(), invalidChannel$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFpl$str() {
        return "PRSP000248: Provided feature pack location has invalid format `%s`. Expected <groupId:artifactId>";
    }
    @Override
    public final String invalidFpl(final String fplText) {
        return String.format(getLoggingLocale(), invalidFpl$str(), fplText);
    }
    protected String unknownInstallationProfile$str() {
        return "PRSP000249: Unrecognized profile %s, did you mean one of [%s]";
    }
    @Override
    public final IllegalArgumentException unknownInstallationProfile(final String profileName, final String options) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownInstallationProfile$str(), profileName, options));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidCandidateMarker$str() {
        return "PRSP000250: Invalid candidate marker file [%s]. Missing required field [%s].";
    }
    @Override
    public final MetadataException invalidCandidateMarker(final Path resolve, final String operationProperty) {
        final MetadataException result = new MetadataException(String.format(getLoggingLocale(), invalidCandidateMarker$str(), resolve, operationProperty));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidMarkerFileOperation$str() {
        return "PRSP000251: Unexpected operation type [%s] in the candidate marker file.";
    }
    @Override
    public final IllegalArgumentException invalidMarkerFileOperation(final String operation) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidMarkerFileOperation$str(), operation));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidMetadataBundle$str() {
        return "PRSP000252: Invalid metadata bundle [%s]. Expected a ZIP archive containing installation configuration.";
    }
    @Override
    public final IllegalArgumentException invalidMetadataBundle(final Path path) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidMetadataBundle$str(), path));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void fallbackToGalleonProvisioningDefinition() {
        super.log.logf(FQCN, INFO, null, fallbackToGalleonProvisioningDefinition$str());
    }
    protected String fallbackToGalleonProvisioningDefinition$str() {
        return "PRSP000253: Unable to retrieve stored provisioning configuration. Falling back to current configuration";
    }
    protected String noDefaultModel$str() {
        return "PRSP000254: Multiple models available in the selected feature pack, please select one.";
    }
    @Override
    public final String noDefaultModel() {
        return String.format(getLoggingLocale(), noDefaultModel$str());
    }
    protected String modelNotFoundInFeaturePack$str() {
        return "PRSP000255: Chosen feature pack does not support model %s. Please choose one of supported models.";
    }
    @Override
    public final String modelNotFoundInFeaturePack(final String model) {
        return String.format(getLoggingLocale(), modelNotFoundInFeaturePack$str(), model);
    }
    protected String layerNotFoundInFeaturePack$str() {
        return "PRSP000256: The feature pack doesn't define requested layers: [%s]";
    }
    @Override
    public final String layerNotFoundInFeaturePack(final String layerName) {
        return String.format(getLoggingLocale(), layerNotFoundInFeaturePack$str(), layerName);
    }
    protected String featurePackAlreadyInstalled$str() {
        return "PRSP000257: Feature pack %s is already provisioned";
    }
    @Override
    public final FeaturePackAlreadyInstalledException featurePackAlreadyInstalled(final FeaturePackLocation fpl) {
        final FeaturePackAlreadyInstalledException result = new FeaturePackAlreadyInstalledException(String.format(getLoggingLocale(), featurePackAlreadyInstalled$str(), fpl));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void addingFeaturePack(final FeaturePackLocation fpl, final String configuration, final String layers) {
        super.log.logf(FQCN, DEBUG, null, addingFeaturePack$str(), fpl, configuration, layers);
    }
    protected String addingFeaturePack$str() {
        return "PRSP000258: Adding a feature pack [%s] with configuration %s and layers [%s]";
    }
    protected String galleonConfigNotFound$str() {
        return "PRSP000259: Requested configuration %s/%s is not available in the feature packs.";
    }
    @Override
    public final String galleonConfigNotFound(final String model, final String name) {
        return String.format(getLoggingLocale(), galleonConfigNotFound$str(), model, name);
    }
    protected String dirMustBeWritable$str() {
        return "PRSP000260: The selected folder %s cannot be created.";
    }
    @Override
    public final IllegalArgumentException dirMustBeWritable(final Path directory) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), dirMustBeWritable$str(), directory));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void channelNamesWrittenToFile(final String fileName) {
        super.log.logf(FQCN, DEBUG, null, channelNamesWrittenToFile$str(), fileName);
    }
    protected String channelNamesWrittenToFile$str() {
        return "PRSP000261: Channel map data has been written to %s.";
    }
    @Override
    public final void unableToWriteChannelNamesToFile(final String fileName, final Exception e) {
        super.log.logf(FQCN, ERROR, e, unableToWriteChannelNamesToFile$str(), fileName);
    }
    protected String unableToWriteChannelNamesToFile$str() {
        return "PRSP000262: Unable to create a candidate properties file %s.";
    }
    @Override
    public final void unableToReadChannelNames(final String fileName, final Exception e) {
        super.log.logf(FQCN, ERROR, e, unableToReadChannelNames$str(), fileName);
    }
    protected String unableToReadChannelNames$str() {
        return "PRSP000263: Unable to read the candidate properties file %s.";
    }
    protected String unableToReadArtifactCache$str() {
        return "PRSP000264: Bad artifact record format in the cache descriptor, line %d: '%s'";
    }
    @Override
    public final IOException unableToReadArtifactCache(final int row, final String line, final Exception e) {
        final IOException result = new IOException(String.format(getLoggingLocale(), unableToReadArtifactCache$str(), row, line), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCreateTemporaryFile$str() {
        return "PRSP000265: Unable to create temporary file";
    }
    @Override
    public final ProvisioningException unableToCreateTemporaryFile(final Throwable t) {
        final ProvisioningException result = new ProvisioningException(String.format(getLoggingLocale(), unableToCreateTemporaryFile$str()), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToExtractRepositoryArchive$str() {
        return "PRSP000266: Unable to extract the repository archive %s.";
    }
    @Override
    public final InvalidRepositoryArchiveException unableToExtractRepositoryArchive(final String archiveUrl, final Throwable t) {
        final InvalidRepositoryArchiveException result = new InvalidRepositoryArchiveException(String.format(getLoggingLocale(), unableToExtractRepositoryArchive$str(), archiveUrl), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidRepositoryArchive$str() {
        return "PRSP000267: Repository archive has to contain a single root folder with a maven-repository sub-folder.";
    }
    @Override
    public final InvalidRepositoryArchiveException invalidRepositoryArchive() {
        final InvalidRepositoryArchiveException result = new InvalidRepositoryArchiveException(String.format(getLoggingLocale(), invalidRepositoryArchive$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotRevertToTip$str() {
        return "PRSP000268: The revision %s is the state of the current installation. Reverting to the same state is not a valid operation.";
    }
    @Override
    public final MetadataException cannotRevertToTip(final String name) {
        final MetadataException result = new MetadataException(String.format(getLoggingLocale(), cannotRevertToTip$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noChangesAvailable$str() {
        return "PRSP000269: There are no changes to apply to the installation %s from the candidate installation %s.";
    }
    @Override
    public final InvalidUpdateCandidateException noChangesAvailable(final Path installationDir, final Path candidateDir) {
        final InvalidUpdateCandidateException result = new InvalidUpdateCandidateException(String.format(getLoggingLocale(), noChangesAvailable$str(), installationDir, candidateDir));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCompareHashDirs$str() {
        return "PRSP000270: Unable to compare the hash content between the installation %s and candidate installation %s.";
    }
    @Override
    public final MetadataException unableToCompareHashDirs(final Path installationDir, final Path updateDir, final Exception e) {
        final MetadataException result = new MetadataException(String.format(getLoggingLocale(), unableToCompareHashDirs$str(), installationDir, updateDir), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToEvaluateSymbolicLink$str() {
        return "PRSP000271: Unable to evaluate symbolic link %s.";
    }
    @Override
    public final RuntimeException unableToEvaluateSymbolicLink(final Path symlink, final IOException e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), unableToEvaluateSymbolicLink$str(), symlink), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToApplyCandidate$str() {
        return "PRSP000272: Failed to apply the candidate changes due to: %s";
    }
    @Override
    public final String failedToApplyCandidate(final String reason) {
        return String.format(getLoggingLocale(), failedToApplyCandidate$str(), reason);
    }
    protected String staleCandidate$str() {
        return "PRSP000273: The server [%s] has been modified after the candidate has been created [%s].";
    }
    @Override
    public final InvalidUpdateCandidateException staleCandidate(final Path originalServer, final Path candiadate) {
        final InvalidUpdateCandidateException result = new InvalidUpdateCandidateException(String.format(getLoggingLocale(), staleCandidate$str(), originalServer, candiadate));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notCandidate$str() {
        return "PRSP000274: The folder [%s] doesn't contain a server candidate.";
    }
    @Override
    public final InvalidUpdateCandidateException notCandidate(final Path candidateServer) {
        final InvalidUpdateCandidateException result = new InvalidUpdateCandidateException(String.format(getLoggingLocale(), notCandidate$str(), candidateServer));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String wrongCandidateOperation$str() {
        return "PRSP000275: The candidate at [%s] was not prepared for %s operation.";
    }
    @Override
    public final InvalidUpdateCandidateException wrongCandidateOperation(final Path candidateServer, final Type operationType) {
        final InvalidUpdateCandidateException result = new InvalidUpdateCandidateException(String.format(getLoggingLocale(), wrongCandidateOperation$str(), candidateServer, operationType));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
