/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.api;

public class ProvisioningProgressEvent {
    private final long completed;
    private final long total;
    private final String stage;
    private final EventType eventType;
    private String item = null;
    private boolean slowPhase = false;

    public ProvisioningProgressEvent(String stage, EventType eventType, long completed, long total) {
        this.completed = completed;
        this.total = total;
        this.stage = stage;
        this.eventType = eventType;
    }

    public ProvisioningProgressEvent(String stage, EventType eventType, long completed, long total, String item, boolean slowPhase) {
        this(stage, eventType, completed, total);
        this.item = item;
        this.slowPhase = slowPhase;
    }

    public String getCurrentItem() {
        return this.item;
    }

    public boolean isSlowPhase() {
        return this.slowPhase;
    }

    public double getProgress() {
        if (this.total < 0L) {
            return 0.0;
        }
        return (double)this.completed / (double)this.total * 100.0;
    }

    boolean isMeasurable() {
        return this.total > 0L;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public long getCompleted() {
        return this.completed;
    }

    public long getTotal() {
        return this.total;
    }

    public String getStage() {
        return this.stage;
    }

    public String toString() {
        return "ProvisioningProgress{completed=" + this.completed + ", total=" + this.total + ", stage='" + this.stage + "', event=" + String.valueOf((Object)this.eventType) + "}";
    }

    public static enum EventType {
        STARTING,
        UPDATE,
        COMPLETED;

    }
}

