/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class FeaturePackTemplate {
    private final String artifactId;
    private final String version;
    private final String groupId;
    private final List<String> additionalPackages;
    private final String transitiveDependency;
    private final boolean supportsCustomization;
    private final boolean requiresLayers;
    private final String replacesDependency;

    @JsonCreator
    public FeaturePackTemplate(@JsonProperty(value="groupId") String groupId, @JsonProperty(value="artifactId") String artifactId, @JsonProperty(value="version") String version, @JsonProperty(value="additional-packages") List<String> additionalPackages, @JsonProperty(value="transitive-dependencies") String transitiveDependency, @JsonProperty(value="replaces-dependency") String replacesDependency, @JsonProperty(value="supports-customization") Boolean supportsCustomization, @JsonProperty(value="requires-layers") boolean requiresLayers) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.additionalPackages = additionalPackages == null ? Collections.emptyList() : additionalPackages;
        this.transitiveDependency = transitiveDependency;
        this.replacesDependency = replacesDependency;
        this.supportsCustomization = supportsCustomization == null || supportsCustomization != false;
        this.requiresLayers = requiresLayers;
    }

    private FeaturePackTemplate(Builder builder) {
        this(builder.groupId, builder.artifactId, builder.version, builder.additionalPackages, builder.transitiveDependency, builder.replacesDependency, builder.supportsCustomization, builder.requiresLayers);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isRequiresLayers() {
        return this.requiresLayers;
    }

    public boolean isSupportsCustomization() {
        return this.supportsCustomization;
    }

    public List<String> getAdditionalPackages() {
        return this.additionalPackages;
    }

    public String getTransitiveDependency() {
        return this.transitiveDependency;
    }

    public String getReplacesDependency() {
        return this.replacesDependency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeaturePackTemplate template = (FeaturePackTemplate)o;
        return this.supportsCustomization == template.supportsCustomization && this.requiresLayers == template.requiresLayers && Objects.equals(this.artifactId, template.artifactId) && Objects.equals(this.version, template.version) && Objects.equals(this.groupId, template.groupId) && Objects.equals(this.additionalPackages, template.additionalPackages) && Objects.equals(this.transitiveDependency, template.transitiveDependency) && Objects.equals(this.replacesDependency, template.replacesDependency);
    }

    public int hashCode() {
        return Objects.hash(this.artifactId, this.version, this.groupId, this.additionalPackages, this.transitiveDependency, this.supportsCustomization, this.requiresLayers, this.replacesDependency);
    }

    public String toString() {
        return "FeaturePackTemplate{artifactId='" + this.artifactId + "', version='" + this.version + "', groupId='" + this.groupId + "', additionalPackages=" + String.valueOf(this.additionalPackages) + ", transitiveDependency='" + this.transitiveDependency + "', supportsCustomization=" + this.supportsCustomization + ", requiresLayers=" + this.requiresLayers + ", replacesDependency='" + this.replacesDependency + "'}";
    }

    public static class Builder {
        private final String artifactId;
        private final String version;
        private final String groupId;
        private List<String> additionalPackages;
        private String transitiveDependency;
        private boolean supportsCustomization;
        private String replacesDependency;
        private boolean requiresLayers;

        public Builder(String groupId, String artifactId, String version) {
            this.artifactId = artifactId;
            this.version = version;
            this.groupId = groupId;
        }

        public FeaturePackTemplate build() {
            return new FeaturePackTemplate(this);
        }

        public Builder addAdditionalPackage(String name) {
            if (this.additionalPackages == null) {
                this.additionalPackages = new ArrayList<String>();
            }
            this.additionalPackages.add(name);
            return this;
        }

        public Builder addTransitiveDependency(String name) {
            this.transitiveDependency = name;
            return this;
        }

        public Builder setSupportsCustomization(boolean supportsCustomization) {
            this.supportsCustomization = supportsCustomization;
            return this;
        }

        public Builder setReplacesDependency(String replacesDependency) {
            this.replacesDependency = replacesDependency;
            return this;
        }

        public Builder setRequiresLayers(boolean requiresLayers) {
            this.requiresLayers = requiresLayers;
            return this;
        }
    }
}

