/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.galleon;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.wildfly.channel.ArtifactCoordinate;
import org.wildfly.channel.Repository;
import org.wildfly.channel.maven.VersionResolverFactory;
import org.wildfly.channel.spi.MavenVersionsResolver;
import org.wildfly.prospero.galleon.ArtifactCache;
import org.wildfly.prospero.galleon.CachedVersionResolver;
import org.wildfly.prospero.metadata.ManifestVersionRecord;

public class CachedVersionResolverFactory
implements MavenVersionsResolver.Factory {
    private final VersionResolverFactory factory;
    private final RepositorySystem system;
    private final DefaultRepositorySystemSession session;
    private final ArtifactCache artifactCache;
    private final Path installDir;

    public CachedVersionResolverFactory(VersionResolverFactory factory, Path installDir, RepositorySystem system, DefaultRepositorySystemSession session) throws IOException {
        this.factory = factory;
        this.system = system;
        this.session = session;
        this.artifactCache = ArtifactCache.getInstance(installDir);
        this.installDir = installDir;
    }

    public MavenVersionsResolver create(Collection<Repository> repositories) {
        return new CachedVersionResolver(this.factory.create(repositories), this.artifactCache, this.system, (RepositorySystemSession)this.session, a -> CachedVersionResolverFactory.getCurrentManifestVersion(a, this.installDir.resolve(".installation").resolve("manifest_version.yaml")));
    }

    private static String getCurrentManifestVersion(ArtifactCoordinate a, Path manifestVersionRecord) {
        String version;
        block3: {
            version = null;
            try {
                Optional read = ManifestVersionRecord.read((Path)manifestVersionRecord);
                if (!read.isPresent()) break block3;
                List manifests = ((ManifestVersionRecord)read.get()).getMavenManifests();
                for (ManifestVersionRecord.MavenManifest manifest : manifests) {
                    if (!manifest.getGroupId().equals(a.getGroupId()) || !manifest.getArtifactId().equals(a.getArtifactId())) continue;
                    version = manifest.getVersion();
                    break;
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return version;
    }
}

