/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.api;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.config.GalleonFeaturePackConfig;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifestCoordinate;
import org.wildfly.channel.ChannelMapper;
import org.wildfly.channel.InvalidChannelMetadataException;
import org.wildfly.channel.Repository;
import org.wildfly.channel.maven.ChannelCoordinate;
import org.wildfly.channel.maven.VersionResolverFactory;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.api.ArtifactUtils;
import org.wildfly.prospero.api.InstallationProfilesManager;
import org.wildfly.prospero.api.RepositoryUtils;
import org.wildfly.prospero.api.TemporaryRepositoriesHandler;
import org.wildfly.prospero.api.exceptions.ChannelDefinitionException;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.NoChannelException;
import org.wildfly.prospero.galleon.FeaturePackLocationParser;
import org.wildfly.prospero.galleon.GalleonUtils;
import org.wildfly.prospero.model.InstallationProfile;

public class ProvisioningDefinition {
    private final String fpl;
    private List<Channel> channels = new ArrayList<Channel>();
    private final List<ChannelCoordinate> channelCoordinates = new ArrayList<ChannelCoordinate>();
    private final List<Repository> overrideRepositories = new ArrayList<Repository>();
    private final URI definition;
    private final String stabilityLevel;
    private final String configStabilityLevel;
    private final String packageStabilityLevel;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ProvisioningDefinition(Builder builder) throws NoChannelException {
        this.overrideRepositories.addAll(builder.overrideRepositories);
        this.channelCoordinates.addAll(builder.channelCoordinates);
        this.stabilityLevel = builder.stabilityLevel;
        this.configStabilityLevel = builder.configStabilityLevel;
        this.packageStabilityLevel = builder.packageStabilityLevel;
        if (StringUtils.isNotEmpty((CharSequence)this.stabilityLevel) && (StringUtils.isNotEmpty((CharSequence)this.packageStabilityLevel) || StringUtils.isNotEmpty((CharSequence)this.configStabilityLevel))) {
            throw new IllegalArgumentException("Provisioning option stabilityLevel cannot be used with packageStabilityLevel or configStabilityLevel");
        }
        if (builder.profile.isPresent()) {
            if (!InstallationProfilesManager.isWellKnownName(builder.profile.get())) {
                throw ProsperoLogger.ROOT_LOGGER.unknownInstallationProfile(builder.profile.get(), String.join((CharSequence)",", InstallationProfilesManager.getNames()));
            }
            InstallationProfile installationProfile = InstallationProfilesManager.getByName(builder.profile.get());
            this.fpl = null;
            this.definition = installationProfile.getGalleonConfiguration();
            if (!this.channelCoordinates.isEmpty()) return;
            if (!builder.manifests.isEmpty()) {
                List<Repository> repositories = ProvisioningDefinition.extractRepositoriesFromChannels(installationProfile.getChannels());
                this.channels = builder.manifests.stream().map(m -> ProvisioningDefinition.composeChannelFromManifest(m, repositories)).collect(Collectors.toList());
                return;
            } else {
                if (installationProfile.getChannels().isEmpty()) throw ProsperoLogger.ROOT_LOGGER.fplDefinitionDoesntContainChannel(builder.profile.get());
                this.channels = installationProfile.getChannels();
            }
            return;
        } else {
            this.fpl = builder.fpl.orElse(null);
            this.definition = builder.definitionFile.orElse(null);
            if (this.channelCoordinates.isEmpty() && builder.manifests.isEmpty()) {
                throw ProsperoLogger.ROOT_LOGGER.predefinedFplOrChannelRequired(String.join((CharSequence)", ", InstallationProfilesManager.getNames()));
            }
            if (builder.manifests.isEmpty()) return;
            if (this.overrideRepositories.isEmpty()) {
                throw ProsperoLogger.ROOT_LOGGER.repositoriesMustBeSetWithManifest();
            }
            this.channels = builder.manifests.stream().map(m -> ProvisioningDefinition.composeChannelFromManifest(m, this.overrideRepositories)).collect(Collectors.toList());
        }
    }

    private List<RemoteRepository> channelResolutionRepositories() {
        if (this.overrideRepositories.isEmpty()) {
            return List.of(new RemoteRepository.Builder("central", "default", "https://repo1.maven.org/maven2").build());
        }
        return this.overrideRepositories.stream().map(RepositoryUtils::toRemoteRepository).collect(Collectors.toList());
    }

    public String getFpl() {
        return this.fpl;
    }

    public URI getDefinition() {
        return this.definition;
    }

    public GalleonProvisioningConfig toProvisioningConfig() throws MetadataException, ProvisioningException {
        if (this.fpl != null) {
            FeaturePackLocation loc = FeaturePackLocationParser.resolveFpl(this.getFpl());
            GalleonFeaturePackConfig.Builder configBuilder = GalleonFeaturePackConfig.builder((FeaturePackLocation)loc);
            GalleonProvisioningConfig.Builder builder = (GalleonProvisioningConfig.Builder)GalleonProvisioningConfig.builder().addFeaturePackDep(configBuilder.build());
            if (this.stabilityLevel != null) {
                builder.addOption("stability-level", this.stabilityLevel);
            }
            if (this.configStabilityLevel != null) {
                builder.addOption("config-stability-level", this.configStabilityLevel);
            }
            if (this.packageStabilityLevel != null) {
                builder.addOption("package-stability-level", this.packageStabilityLevel);
            }
            return builder.build();
        }
        if (this.definition != null) {
            try {
                GalleonProvisioningConfig config = GalleonUtils.loadProvisioningConfig(this.definition);
                GalleonProvisioningConfig.Builder builder = GalleonProvisioningConfig.builder((GalleonProvisioningConfig)config);
                if (StringUtils.isNotEmpty((CharSequence)this.stabilityLevel)) {
                    builder.addOption("stability-level", this.stabilityLevel);
                }
                if (StringUtils.isNotEmpty((CharSequence)this.configStabilityLevel)) {
                    builder.addOption("config-stability-level", this.configStabilityLevel);
                }
                if (StringUtils.isNotEmpty((CharSequence)this.packageStabilityLevel)) {
                    builder.addOption("package-stability-level", this.packageStabilityLevel);
                }
                return builder.build();
            }
            catch (XMLStreamException e) {
                throw ProsperoLogger.ROOT_LOGGER.unableToParseConfigurationUri(this.definition, e);
            }
        }
        throw ProsperoLogger.ROOT_LOGGER.fplNorGalleonConfigWereSet();
    }

    public List<Channel> resolveChannels(VersionResolverFactory versionResolverFactory) throws NoChannelException, ChannelDefinitionException {
        try {
            List<Channel> channels = new ArrayList<Channel>(this.channels);
            List<ChannelCoordinate> urlCoordinates = this.channelCoordinates.stream().filter(c -> c.getUrl() != null).collect(Collectors.toList());
            List gavCoordinates = this.channelCoordinates.stream().filter(c -> c.getUrl() == null).collect(Collectors.toList());
            if (!gavCoordinates.isEmpty()) {
                channels.addAll(versionResolverFactory.resolveChannels(gavCoordinates, this.channelResolutionRepositories()));
            }
            if (!urlCoordinates.isEmpty()) {
                channels.addAll(ProvisioningDefinition.resolveUrlCoordinates(urlCoordinates));
            }
            channels = TemporaryRepositoriesHandler.overrideRepositories(channels, this.overrideRepositories);
            ProvisioningDefinition.validateResolvedChannels(channels);
            return channels;
        }
        catch (InvalidChannelMetadataException e) {
            throw ProsperoLogger.ROOT_LOGGER.invalidChannel(e);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static List<Channel> resolveUrlCoordinates(List<ChannelCoordinate> urlCoordinates) {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        for (ChannelCoordinate coord : urlCoordinates) {
            Objects.requireNonNull(coord.getUrl(), "This method only expects URL coordinates.");
            try {
                InputStream is = coord.getUrl().openStream();
                String yaml = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                channels.addAll(ChannelMapper.fromString((String)yaml));
            }
            catch (IOException e) {
                InvalidChannelMetadataException ice = new InvalidChannelMetadataException("Failed to read channel " + coord.getUrl(), List.of(e.getLocalizedMessage()));
                ice.initCause((Throwable)e);
                throw ice;
            }
        }
        return channels;
    }

    private static void validateResolvedChannels(List<Channel> channels) throws NoChannelException {
        if (channels.isEmpty()) {
            throw ProsperoLogger.ROOT_LOGGER.noChannelReference();
        }
        Optional<Channel> invalidChannel = channels.stream().filter(c -> c.getManifestCoordinate() == null).findFirst();
        if (invalidChannel.isPresent()) {
            throw ProsperoLogger.ROOT_LOGGER.noChannelManifestReference(invalidChannel.get().getName());
        }
    }

    private static List<Repository> extractRepositoriesFromChannels(List<Channel> channels) {
        return channels.stream().flatMap(c -> c.getRepositories().stream()).collect(Collectors.toList());
    }

    private static Channel composeChannelFromManifest(ChannelManifestCoordinate manifestCoordinate, List<Repository> repositories) {
        return new Channel(null, null, null, repositories, manifestCoordinate, null, null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Optional<String> fpl = Optional.empty();
        private Optional<URI> definitionFile = Optional.empty();
        private List<Repository> overrideRepositories = Collections.emptyList();
        private List<ChannelManifestCoordinate> manifests = Collections.emptyList();
        private List<ChannelCoordinate> channelCoordinates = Collections.emptyList();
        private Optional<String> profile = Optional.empty();
        private String stabilityLevel;
        private String packageStabilityLevel;
        private String configStabilityLevel;

        public ProvisioningDefinition build() throws MetadataException, NoChannelException {
            return new ProvisioningDefinition(this);
        }

        public Builder setFpl(String fpl) {
            this.fpl = Optional.ofNullable(fpl);
            return this;
        }

        public Builder setOverrideRepositories(List<Repository> repositories) {
            this.overrideRepositories = repositories;
            return this;
        }

        public Builder setManifest(String manifests) {
            if (manifests != null) {
                this.manifests = List.of(ArtifactUtils.manifestCoordFromString(manifests));
            }
            return this;
        }

        public Builder setManifests(List<String> manifests) {
            if (manifests != null) {
                this.manifests = manifests.stream().map(ArtifactUtils::manifestCoordFromString).collect(Collectors.toList());
            }
            return this;
        }

        public Builder setChannelCoordinates(String channelCoordinate) {
            return this.setChannelCoordinates(List.of(channelCoordinate));
        }

        public Builder setChannelCoordinates(List<String> channelCoordinates) {
            Objects.requireNonNull(channelCoordinates);
            this.channelCoordinates = new ArrayList<ChannelCoordinate>();
            for (String coord : channelCoordinates) {
                this.channelCoordinates.add(ArtifactUtils.channelCoordFromString(coord));
            }
            return this;
        }

        public Builder setDefinitionFile(URI provisionDefinition) {
            this.definitionFile = Optional.ofNullable(provisionDefinition);
            return this;
        }

        public Builder setProfile(String profile) {
            this.profile = Optional.ofNullable(profile);
            return this;
        }

        public Builder setStabilityLevel(String stabilityLevel) {
            this.stabilityLevel = stabilityLevel;
            return this;
        }

        public Builder setPackageStabilityLevel(String packageStabilityLevel) {
            this.packageStabilityLevel = packageStabilityLevel;
            return this;
        }

        public Builder setConfigStabilityLevel(String configStabilityLevel) {
            this.configStabilityLevel = configStabilityLevel;
            return this;
        }
    }
}

