/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.api;

import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class SavedState {
    private Set<Version> manifestVersions = Collections.emptySet();
    private String hash;
    private Instant timestamp;
    private Type type;
    private String msg = "";

    @Deprecated
    public SavedState(String hash, Instant timestamp, Type type, String msg) {
        this.hash = hash;
        this.timestamp = timestamp;
        this.type = type;
        this.msg = msg;
    }

    public SavedState(String hash, Instant timestamp, Type type, String msg, List<Version> manifestVersions) {
        this.hash = hash;
        this.timestamp = timestamp;
        this.type = type;
        this.msg = msg;
        this.manifestVersions = new TreeSet<Version>(manifestVersions);
    }

    public SavedState(String hash) {
        this.hash = hash;
        this.timestamp = null;
        this.type = null;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.hash;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getMsg() {
        return this.msg;
    }

    public Collection<Version> getManifestVersions() {
        return this.manifestVersions;
    }

    public String shortDescription() {
        Object msg;
        if (this.manifestVersions.isEmpty()) {
            msg = this.msg;
        } else {
            String versions = this.manifestVersions.stream().map(Version::getDisplayVersion).collect(Collectors.joining("+"));
            msg = "[" + versions + "]";
        }
        return String.format("[%s] %s - %s %s", this.hash, this.timestamp.toString(), this.type.toString().toLowerCase(Locale.ROOT), msg);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SavedState that = (SavedState)o;
        return Objects.equals(this.manifestVersions, that.manifestVersions) && Objects.equals(this.hash, that.hash) && Objects.equals(this.timestamp, that.timestamp) && this.type == that.type && Objects.equals(this.msg, that.msg);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.manifestVersions, this.hash, this.timestamp, this.type, this.msg});
    }

    public String toString() {
        return "SavedState{manifestVersions=" + this.manifestVersions + ", hash='" + this.hash + "', timestamp=" + this.timestamp + ", type=" + this.type + ", msg='" + this.msg + "'}";
    }

    public static enum Type {
        UPDATE,
        INSTALL,
        ROLLBACK,
        CONFIG_CHANGE,
        FEATURE_PACK,
        INTERNAL_UPDATE,
        UNKNOWN;


        public static Type fromText(String text) {
            for (Type value : Type.values()) {
                if (!value.name().equals(text)) continue;
                return value;
            }
            return UNKNOWN;
        }
    }

    public static class Version
    implements Comparable<Version> {
        public final String physicalVersion;
        public final String logicalVersion;
        private final String identifier;

        public Version(String identifier, String physicalVersion, String logicalVersion) {
            Objects.requireNonNull(identifier);
            Objects.requireNonNull(physicalVersion);
            this.identifier = identifier;
            this.physicalVersion = physicalVersion;
            this.logicalVersion = logicalVersion;
        }

        public String getPhysicalVersion() {
            return this.physicalVersion;
        }

        public String getLogicalVersion() {
            return this.logicalVersion;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getDisplayVersion() {
            if (this.logicalVersion != null) {
                return this.logicalVersion;
            }
            return this.identifier + ":" + this.physicalVersion;
        }

        public String toString() {
            return "Version{physicalVersion='" + this.physicalVersion + "', logicalVersion='" + this.logicalVersion + "', identifier='" + this.identifier + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Version version = (Version)o;
            return Objects.equals(this.physicalVersion, version.physicalVersion) && Objects.equals(this.logicalVersion, version.logicalVersion) && Objects.equals(this.identifier, version.identifier);
        }

        public int hashCode() {
            return Objects.hash(this.physicalVersion, this.logicalVersion, this.identifier);
        }

        @Override
        public int compareTo(Version o) {
            int res = this.identifier.compareTo(o.getIdentifier());
            if (res == 0) {
                res = this.physicalVersion.compareTo(o.getPhysicalVersion());
            }
            if (res == 0 && this.logicalVersion != null && o.getLogicalVersion() != null) {
                res = this.logicalVersion.compareTo(o.getLogicalVersion());
            }
            return res;
        }
    }
}

