/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.installation.git;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.wildfly.channel.ChannelMapper;
import org.wildfly.channel.version.VersionMatcher;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.api.SavedState;
import org.wildfly.prospero.metadata.ManifestVersionRecord;

class SavedStateParser {
    public static final String SCHEMA_VERSION_1_0_0 = "1.0.0";
    private static final String SCHEMA_1_0_0_FILE = "org/wildfly/prospero/savedstate/v1.0.0/schema.json";
    private static final Map<String, JsonSchema> SCHEMAS = new HashMap<String, JsonSchema>();
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper(new JsonFactory());
    private static final JsonSchemaFactory SCHEMA_FACTORY = JsonSchemaFactory.builder((JsonSchemaFactory)JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V201909)).jsonMapper(JSON_MAPPER).build();

    SavedStateParser() {
    }

    String write(SavedState.Type recordType, ManifestVersionRecord currentVersions) throws IOException {
        if (currentVersions == null) {
            return null;
        }
        String header = currentVersions.getSummary();
        return recordType.name() + " " + header + "\n\n" + this.toJson(currentVersions);
    }

    SavedState read(String hash, Instant now, String text) throws IOException {
        String msg;
        SavedState.Type type;
        String originalText = text;
        List<SavedState.Version> versions = Collections.emptyList();
        if (!text.contains(" ")) {
            type = SavedState.Type.fromText(text);
            text = "";
        } else {
            int endOfType = text.indexOf(32);
            type = SavedState.Type.fromText(text.substring(0, endOfType));
            text = text.substring(endOfType + 1);
        }
        if (type == SavedState.Type.UNKNOWN) {
            return new SavedState(hash, now, type, SavedStateParser.shortMessage(originalText), versions);
        }
        if (!text.contains("\n\n")) {
            msg = text;
        } else {
            int endOfShortDesc = text.indexOf("\n\n");
            msg = text.substring(0, endOfShortDesc).trim();
            if (!(text = text.substring(endOfShortDesc).trim()).isEmpty()) {
                try {
                    versions = SavedStateParser.readVersions(text);
                }
                catch (JsonParseException e) {
                    ProsperoLogger.ROOT_LOGGER.error("Unable to parse a history record [" + text + "]", e);
                }
            }
        }
        return new SavedState(hash, now, type, msg, versions);
    }

    private static String shortMessage(String originalText) {
        if ((originalText = originalText.trim()).isEmpty()) {
            return null;
        }
        if (originalText.contains("\n")) {
            return originalText.split("\n")[0].trim();
        }
        return originalText;
    }

    private static List<SavedState.Version> readVersions(String text) throws JsonProcessingException {
        JsonNode node = JSON_MAPPER.readTree(text);
        JsonSchema schema = SavedStateParser.getSchema(node);
        if (schema == null) {
            return Collections.emptyList();
        }
        Set validationMessages = schema.validate(node);
        if (!validationMessages.isEmpty()) {
            for (ValidationMessage validationMessage : validationMessages) {
                ProsperoLogger.ROOT_LOGGER.error("Invalid Saved State in history " + validationMessage);
            }
            return Collections.emptyList();
        }
        ManifestVersionRecord record = (ManifestVersionRecord)JSON_MAPPER.readValue(text, ManifestVersionRecord.class);
        ArrayList<SavedState.Version> versions = new ArrayList<SavedState.Version>();
        record.getMavenManifests().forEach(m -> versions.add(new SavedState.Version(m.getGroupId() + ":" + m.getArtifactId(), m.getVersion(), m.getDescription())));
        record.getUrlManifests().forEach(m -> versions.add(new SavedState.Version(m.getUrl(), m.getHash(), m.getDescription())));
        record.getOpenManifests().forEach(m -> versions.add(new SavedState.Version("unknown", "unknown", m.getSummary())));
        return versions;
    }

    private String toJson(ManifestVersionRecord currentVersions) throws IOException {
        return JSON_MAPPER.writeValueAsString((Object)currentVersions);
    }

    private static JsonSchema getSchema(JsonNode node) {
        JsonNode schemaVersion = node.path("schemaVersion");
        String version = schemaVersion.asText();
        if (version == null || version.isEmpty()) {
            ProsperoLogger.ROOT_LOGGER.error("Invalid Saved State record in history - schema version is not specified");
            return null;
        }
        JsonSchema schema = SCHEMAS.get(version);
        if (schema != null) {
            return schema;
        }
        String[] parts = version.split("\\.");
        StringBuilder versionPattern = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            if (i == 0) {
                versionPattern.append(parts[i]);
                continue;
            }
            if (i == parts.length - 1) {
                versionPattern.append(".*");
                continue;
            }
            versionPattern.append("\\.").append(parts[i]);
        }
        Optional<String> latestCompatibleSchemaVersion = SCHEMAS.keySet().stream().filter(v -> v.matches(versionPattern.toString())).max(VersionMatcher.COMPARATOR);
        return latestCompatibleSchemaVersion.map(SCHEMAS::get).orElseGet(() -> {
            ProsperoLogger.ROOT_LOGGER.error("Invalid Saved State record in history - unknown schema version " + schemaVersion);
            return null;
        });
    }

    static {
        SCHEMAS.put(SCHEMA_VERSION_1_0_0, SCHEMA_FACTORY.getSchema(ChannelMapper.class.getClassLoader().getResourceAsStream(SCHEMA_1_0_0_FILE)));
    }
}

