/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.model;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.aether.repository.RemoteRepository;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelMapper;
import org.wildfly.channel.InvalidChannelMetadataException;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.api.exceptions.MetadataException;

public class ProsperoConfig {
    private final List<Channel> channels;
    private final MavenOptions mavenOptions;

    public ProsperoConfig(List<Channel> channels) {
        this.channels = channels;
        this.mavenOptions = null;
    }

    public ProsperoConfig(List<Channel> channels, MavenOptions mavenOptions) {
        this.channels = channels;
        this.mavenOptions = mavenOptions;
    }

    public List<Channel> getChannels() {
        return this.channels;
    }

    public static ProsperoConfig readConfig(Path path) throws MetadataException {
        String yamlContent;
        MavenOptions opts = null;
        try {
            yamlContent = Files.readString(path.resolve("installer-channels.yaml")).trim();
        }
        catch (IOException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToReadFile(path, e);
        }
        if (Files.exists(path.resolve("maven_opts.yaml"), new LinkOption[0])) {
            try {
                opts = MavenOptions.read(path.resolve("maven_opts.yaml"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (yamlContent.isEmpty()) {
            return new ProsperoConfig(Collections.emptyList(), opts);
        }
        try {
            return new ProsperoConfig(ChannelMapper.fromString((String)yamlContent), opts);
        }
        catch (InvalidChannelMetadataException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToParseConfiguration(path.resolve("installer-channels.yaml"), e.getCause());
        }
    }

    public Collection<RemoteRepository> listAllRepositories() {
        return this.channels.stream().flatMap(c -> c.getRepositories().stream()).map(r -> new RemoteRepository.Builder(r.getId(), "default", r.getUrl()).build()).collect(Collectors.toSet());
    }

    public MavenOptions getMavenOptions() {
        return this.mavenOptions == null ? MavenOptions.DEFAULT_OPTIONS : this.mavenOptions;
    }
}

