/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.updates;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CandidateProperties {
    protected static final String DEFAULT_SCHEMA = "1.0.0";
    private final String schemaVersion;
    private final List<ComponentUpdate> updates;
    @JsonIgnore
    private final Map<String, String> updatesMap = new HashMap<String, String>();

    public CandidateProperties(List<ComponentUpdate> updates) {
        this(DEFAULT_SCHEMA, updates);
    }

    @JsonCreator
    public CandidateProperties(@JsonProperty(required=true, value="schemaVersion") String schemaVersion, @JsonProperty(value="updates") List<ComponentUpdate> updates) {
        this.schemaVersion = schemaVersion;
        this.updates = updates == null ? Collections.emptyList() : updates;
        this.updates.forEach(u -> this.updatesMap.put(u.getGroupId() + ":" + u.getArtifactId(), u.getChannelName()));
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public List<ComponentUpdate> getUpdates() {
        return this.updates;
    }

    public String toString() {
        return "CandidateProperties{schemaVersion='" + this.schemaVersion + "', updates=" + this.updates + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CandidateProperties that = (CandidateProperties)o;
        return Objects.equals(this.schemaVersion, that.schemaVersion) && Objects.equals(this.updates, that.updates);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.updates);
    }

    @JsonIgnore
    public String getUpdateChannel(String key) {
        return this.updatesMap.get(key);
    }

    public static class ComponentUpdate {
        private String groupId;
        private String artifactId;
        private String channelName;

        @JsonCreator
        public ComponentUpdate(@JsonProperty(value="groupId") String groupId, @JsonProperty(value="artifactId") String artifactId, @JsonProperty(value="channelName") String channelName) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.channelName = channelName;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getChannelName() {
            return this.channelName;
        }

        public String toString() {
            return "ComponentUpdate{groupId='" + this.groupId + "', artifactId='" + this.artifactId + "', channelName='" + this.channelName + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComponentUpdate that = (ComponentUpdate)o;
            return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.channelName, that.channelName);
        }

        public int hashCode() {
            return Objects.hash(this.groupId, this.artifactId, this.channelName);
        }
    }
}

