/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ManifestVersionRecord {
    protected static final String SCHEMA_100 = "1.0.0";
    protected static final String DEFAULT_SCHEMA = "1.0.0";
    private String schemaVersion;
    private List<MavenManifest> mavenManifests = new ArrayList<MavenManifest>();
    private List<UrlManifest> urlManifests = new ArrayList<UrlManifest>();
    private List<NoManifest> noManifests = new ArrayList<NoManifest>();

    @JsonCreator
    public ManifestVersionRecord(@JsonProperty(value="schemaVersion") String schemaVersion, @JsonProperty(value="maven") List<MavenManifest> mavenManifests, @JsonProperty(value="url") List<UrlManifest> urlManifests, @JsonProperty(value="open") List<NoManifest> noManifests) {
        this.schemaVersion = schemaVersion;
        this.mavenManifests = mavenManifests == null ? Collections.emptyList() : mavenManifests;
        this.urlManifests = urlManifests == null ? Collections.emptyList() : urlManifests;
        this.noManifests = noManifests == null ? Collections.emptyList() : noManifests;
    }

    public ManifestVersionRecord() {
        this.schemaVersion = "1.0.0";
    }

    @JsonProperty(value="maven")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<MavenManifest> getMavenManifests() {
        return this.mavenManifests;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<UrlManifest> getUrlManifests() {
        return this.urlManifests;
    }

    @JsonProperty(value="open")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<NoManifest> getOpenManifests() {
        return this.noManifests;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public void addManifest(MavenManifest manifest) {
        this.mavenManifests.add(manifest);
    }

    public void addManifest(NoManifest manifest) {
        this.noManifests.add(manifest);
    }

    public void addManifest(UrlManifest manifest) {
        this.urlManifests.add(manifest);
    }

    @JsonIgnore
    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        for (MavenManifest mavenManifest : this.mavenManifests) {
            sb.append(mavenManifest.getSummary());
        }
        for (UrlManifest urlManifest : this.urlManifests) {
            sb.append(urlManifest.getSummary());
        }
        for (NoManifest noManifest : this.noManifests) {
            sb.append(noManifest.getSummary());
        }
        return sb.toString();
    }

    public static Optional<ManifestVersionRecord> read(Path versionsFile) throws IOException {
        if (Files.exists(versionsFile, new LinkOption[0])) {
            return Optional.of(ManifestVersionRecord.fromYaml(Files.readString(versionsFile)));
        }
        return Optional.empty();
    }

    private static ManifestVersionRecord fromYaml(String yaml) throws IOException {
        return (ManifestVersionRecord)new ObjectMapper((JsonFactory)new YAMLFactory()).readValue(yaml, ManifestVersionRecord.class);
    }

    static String toYaml(ManifestVersionRecord manifestVersionRecord) throws IOException {
        StringWriter stringWriter = new StringWriter();
        new ObjectMapper((JsonFactory)new YAMLFactory()).writeValue((Writer)stringWriter, (Object)manifestVersionRecord);
        return stringWriter.toString();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class MavenManifest {
        private final String description;
        private String groupId;
        private String artifactId;
        private String version;

        @Deprecated
        public MavenManifest(String groupId, String artifactId, String version) {
            this(groupId, artifactId, version, null);
        }

        public MavenManifest(@JsonProperty(value="groupId") String groupId, @JsonProperty(value="artifactId") String artifactId, @JsonProperty(value="version") String version, @JsonProperty(value="description", required=false) String description) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.description = description;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public String getDescription() {
            return this.description;
        }

        @JsonIgnore
        public String getSummary() {
            return String.format("[%s:%s::%s]", this.groupId, this.artifactId, this.version);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class UrlManifest {
        private String url;
        private String hash;
        private String description;

        @Deprecated
        public UrlManifest(String url, String hash) {
            this.url = url;
            this.hash = hash;
            this.description = null;
        }

        public UrlManifest(@JsonProperty(value="url") String url, @JsonProperty(value="hash") String hash, @JsonProperty(value="description") String description) {
            this.url = url;
            this.hash = hash;
            this.description = description;
        }

        public String getUrl() {
            return this.url;
        }

        public String getHash() {
            return this.hash;
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public String getDescription() {
            return this.description;
        }

        @JsonIgnore
        public String getSummary() {
            return String.format("[%s::%s]", this.url, this.hash);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class NoManifest {
        private List<String> repos;
        private String strategy;

        @JsonCreator
        public NoManifest(@JsonProperty(value="repos") List<String> repos, @JsonProperty(value="strategy") String strategy) {
            this.repos = repos;
            this.strategy = strategy;
        }

        public List<String> getRepos() {
            return this.repos;
        }

        public String getStrategy() {
            return this.strategy;
        }

        @JsonIgnore
        public String getSummary() {
            return String.format("[%s::%s]", String.join((CharSequence)"+", this.repos), this.strategy);
        }
    }
}

