/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.elytron.AggregateRealmDefinition;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.CoreService;
import org.wildfly.extension.elytron.CustomComponentDefinition;
import org.wildfly.extension.elytron.DomainDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.FileSystemRealmDefinition;
import org.wildfly.extension.elytron.JaasRealmDefinition;
import org.wildfly.extension.elytron.JdbcRealmDefinition;
import org.wildfly.extension.elytron.KeyStoreDefinition;
import org.wildfly.extension.elytron.KeyStoreRealmDefinition;
import org.wildfly.extension.elytron.LdapRealmDefinition;
import org.wildfly.extension.elytron.NameRewriterDefinitions;
import org.wildfly.extension.elytron.PrincipalDecoderDefinitions;
import org.wildfly.extension.elytron.PropertiesRealmDefinition;
import org.wildfly.extension.elytron.ProviderLoaderDefinition;
import org.wildfly.extension.elytron.RealmMapperDefinitions;
import org.wildfly.extension.elytron.RoleDecoderDefinitions;
import org.wildfly.extension.elytron.RoleMapperDefinitions;
import org.wildfly.extension.elytron.SaslServerDefinitions;
import org.wildfly.extension.elytron.SecurityDomainSaslConfigurationDefinition;
import org.wildfly.extension.elytron.SecurityPropertyResourceDefinition;
import org.wildfly.extension.elytron.SecurityPropertyService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.PrincipalDecoder;
import org.wildfly.security.auth.server.RealmMapper;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.PermissionMapper;
import org.wildfly.security.authz.RoleDecoder;
import org.wildfly.security.authz.RoleMapper;

class ElytronDefinition
extends SimpleResourceDefinition {
    public static final ElytronDefinition INSTANCE = new ElytronDefinition();
    private static final OperationContext.AttachmentKey<SecurityPropertyService> SECURITY_PROPERTY_SERVICE_KEY = OperationContext.AttachmentKey.create(SecurityPropertyService.class);

    private ElytronDefinition() {
        super(ElytronExtension.SUBSYSTEM_PATH, (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver(new String[0]), (OperationStepHandler)new ElytronAdd(), (OperationStepHandler)new ElytronRemove());
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)new SecurityPropertyResourceDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new ProviderLoaderDefinition());
        resourceRegistration.registerSubModel(SecurityDomainSaslConfigurationDefinition.create());
        resourceRegistration.registerSubModel((ResourceDefinition)new DomainDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new AggregateRealmDefinition());
        resourceRegistration.registerSubModel(new CustomComponentDefinition<SecurityRealm>(SecurityRealm.class, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY, "custom-realm"));
        resourceRegistration.registerSubModel((ResourceDefinition)new JaasRealmDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new JdbcRealmDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new KeyStoreRealmDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new PropertiesRealmDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new LdapRealmDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new FileSystemRealmDefinition());
        resourceRegistration.registerSubModel(NameRewriterDefinitions.getAggregateNameRewriterDefinition());
        resourceRegistration.registerSubModel(NameRewriterDefinitions.getChainedNameRewriterDefinition());
        resourceRegistration.registerSubModel(NameRewriterDefinitions.getConstantNameRewriterDefinition());
        resourceRegistration.registerSubModel(new CustomComponentDefinition<NameRewriter>(NameRewriter.class, Capabilities.NAME_REWRITER_RUNTIME_CAPABILITY, "custom-name-rewriter"));
        resourceRegistration.registerSubModel(NameRewriterDefinitions.getRegexNameRewriterDefinition());
        resourceRegistration.registerSubModel(NameRewriterDefinitions.getRegexNameValidatingRewriterDefinition());
        resourceRegistration.registerSubModel(new CustomComponentDefinition<PermissionMapper>(PermissionMapper.class, Capabilities.PERMISSION_MAPPER_RUNTIME_CAPABILITY, "custom-permission-mapper"));
        resourceRegistration.registerSubModel(PrincipalDecoderDefinitions.getAggregatePrincipalDecoderDefinition());
        resourceRegistration.registerSubModel(new CustomComponentDefinition<PrincipalDecoder>(PrincipalDecoder.class, Capabilities.PRINCIPAL_DECODER_RUNTIME_CAPABILITY, "custom-principal-decoder"));
        resourceRegistration.registerSubModel(PrincipalDecoderDefinitions.getX500AttributePrincipalDecoder());
        resourceRegistration.registerSubModel(new CustomComponentDefinition<RealmMapper>(RealmMapper.class, Capabilities.REALM_MAPPER_RUNTIME_CAPABILITY, "custom-realm-mapper"));
        resourceRegistration.registerSubModel(RealmMapperDefinitions.getMappedRegexRealmMapper());
        resourceRegistration.registerSubModel(RealmMapperDefinitions.getSimpleRegexRealmMapperDefinition());
        resourceRegistration.registerSubModel(new CustomComponentDefinition<RoleDecoder>(RoleDecoder.class, Capabilities.ROLE_DECODER_RUNTIME_CAPABILITY, "custom-role-decoder"));
        resourceRegistration.registerSubModel(RoleDecoderDefinitions.getEmptyRoleDecoderDefinition());
        resourceRegistration.registerSubModel(RoleDecoderDefinitions.getSimpleRoleDecoderDefinition());
        resourceRegistration.registerSubModel(RoleMapperDefinitions.getAddSuffixRoleMapperDefinition());
        resourceRegistration.registerSubModel(RoleMapperDefinitions.getAddPrefixRoleMapperDefinition());
        resourceRegistration.registerSubModel(RoleMapperDefinitions.getAggregateRoleMapperDefinition());
        resourceRegistration.registerSubModel(RoleMapperDefinitions.getConstantRoleMapperDefinition());
        resourceRegistration.registerSubModel(new CustomComponentDefinition<RoleMapper>(RoleMapper.class, Capabilities.ROLE_MAPPER_RUNTIME_CAPABILITY, "custom-role-mapper"));
        resourceRegistration.registerSubModel(RoleMapperDefinitions.getLogicalRoleMapperDefinition());
        resourceRegistration.registerSubModel(SaslServerDefinitions.getAggregateSaslServerFactoryDefinition());
        resourceRegistration.registerSubModel(SaslServerDefinitions.getConfigurableSaslServerFactoryDefinition());
        resourceRegistration.registerSubModel(SaslServerDefinitions.getMechanismProviderFilteringSaslServerFactory());
        resourceRegistration.registerSubModel(SaslServerDefinitions.getProviderSaslServerFactoryDefintion());
        resourceRegistration.registerSubModel(SaslServerDefinitions.getServiceLoaderSaslServerFactoryDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new KeyStoreDefinition());
    }

    static ServiceBuilder<?> commonDependencies(ServiceBuilder<?> serviceBuilder) {
        serviceBuilder.addDependencies(new ServiceName[]{SecurityPropertyService.SERVICE_NAME});
        serviceBuilder.addDependencies(new ServiceName[]{CoreService.SERVICE_NAME});
        return serviceBuilder;
    }

    private static void installService(ServiceName serviceName, Service<?> service, ServiceTarget serviceTarget) {
        serviceTarget.addService(serviceName, service).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    private static SecurityPropertyService uninstallSecurityPropertyService(OperationContext context) {
        ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
        ServiceController service = serviceRegistry.getService(SecurityPropertyService.SERVICE_NAME);
        if (service != null) {
            Service serviceImplementation = service.getService();
            context.removeService(service);
            if (serviceImplementation != null && serviceImplementation instanceof SecurityPropertyService) {
                return (SecurityPropertyService)serviceImplementation;
            }
        }
        return null;
    }

    private static class ElytronRemove
    extends AbstractRemoveStepHandler {
        private ElytronRemove() {
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            SecurityPropertyService securityPropertyService = ElytronDefinition.uninstallSecurityPropertyService(context);
            if (securityPropertyService != null) {
                context.attach(SECURITY_PROPERTY_SERVICE_KEY, (Object)securityPropertyService);
            }
            context.removeService(CoreService.SERVICE_NAME);
        }

        protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget target = context.getServiceTarget();
            SecurityPropertyService securityPropertyService = (SecurityPropertyService)context.getAttachment(SECURITY_PROPERTY_SERVICE_KEY);
            if (securityPropertyService != null) {
                ElytronDefinition.installService(SecurityPropertyService.SERVICE_NAME, securityPropertyService, target);
            }
            ElytronDefinition.installService(CoreService.SERVICE_NAME, new CoreService(), target);
        }
    }

    private static class ElytronAdd
    extends AbstractBoottimeAddStepHandler {
        private ElytronAdd() {
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            ElytronSubsystemMessages.ROOT_LOGGER.iAmElytron();
        }

        protected void performBoottime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            ServiceTarget target = context.getServiceTarget();
            ElytronDefinition.installService(SecurityPropertyService.SERVICE_NAME, new SecurityPropertyService(), target);
            ElytronDefinition.installService(CoreService.SERVICE_NAME, new CoreService(), target);
        }

        protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
            ElytronDefinition.uninstallSecurityPropertyService(context);
            context.removeService(CoreService.SERVICE_NAME);
        }
    }
}

