/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.elytron.ElytronSubsystemParser;
import org.wildfly.extension.elytron.NameRewriterDefinitions;
import org.wildfly.extension.elytron.PrincipalDecoderDefinitions;
import org.wildfly.extension.elytron.RealmMapperDefinitions;
import org.wildfly.extension.elytron.RegexAttributeDefinitions;
import org.wildfly.extension.elytron.RoleDecoderDefinitions;
import org.wildfly.extension.elytron.RoleMapperDefinitions;

class MapperParser {
    MapperParser() {
    }

    void readMappers(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block48: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName;
            ElytronSubsystemParser.verifyNamespace(reader);
            switch (localName = reader.getLocalName()) {
                case "aggregate-name-rewriter": {
                    this.readAggregateNameRewriterElement(parentAddress, reader, operations);
                    continue block48;
                }
                case "chained-name-rewriter": {
                    this.readChainedNameRewriterElement(parentAddress, reader, operations);
                    continue block48;
                }
                case "constant-name-rewriter": {
                    this.readConstantRewriterElement(parentAddress, reader, operations);
                    continue block48;
                }
                case "custom-name-rewriter": {
                    ElytronSubsystemParser.readCustomComponent("custom-name-rewriter", parentAddress, reader, operations);
                    continue block48;
                }
                case "regex-name-rewriter": {
                    this.readRegexNameRewriterElement(parentAddress, reader, operations);
                    continue block48;
                }
                case "regex-name-validating-rewriter": {
                    this.readRegexNameValidatingRewriterElement(parentAddress, reader, operations);
                    continue block48;
                }
                case "custom-permission-mapper": {
                    ElytronSubsystemParser.readCustomComponent("custom-permission-mapper", parentAddress, reader, operations);
                    continue block48;
                }
                case "aggregate-principal-decoder": {
                    this.readAggregatePrincipalDecoderElement(parentAddress, reader, operations);
                    continue block48;
                }
                case "custom-principal-decoder": {
                    ElytronSubsystemParser.readCustomComponent("custom-principal-decoder", parentAddress, reader, operations);
                    continue block48;
                }
                case "x500-attribute-principal-decoder": {
                    this.readX500AttributePrincipalDecoderElement(parentAddress, reader, operations);
                    continue block48;
                }
                case "custom-realm-mapper": {
                    ElytronSubsystemParser.readCustomComponent("custom-realm-mapper", parentAddress, reader, operations);
                    continue block48;
                }
                case "simple-regex-realm-mapper": {
                    this.readSimpleRegexRealmMapperElement(parentAddress, reader, operations);
                    continue block48;
                }
                case "mapped-regex-realm-mapper": {
                    this.readMappedRegexRealmMapperElement(parentAddress, reader, operations);
                    continue block48;
                }
                case "custom-role-decoder": {
                    ElytronSubsystemParser.readCustomComponent("custom-role-decoder", parentAddress, reader, operations);
                    continue block48;
                }
                case "empty-role-decoder": {
                    this.readEmptyRoleDecoder(parentAddress, reader, operations);
                    continue block48;
                }
                case "simple-role-decoder": {
                    this.readSimpleRoleDecoder(parentAddress, reader, operations);
                    continue block48;
                }
                case "add-prefix-role-mapper": {
                    this.readAddPrefixRoleMapper(parentAddress, reader, operations);
                    continue block48;
                }
                case "add-suffix-role-mapper": {
                    this.readAddSuffixRoleMapper(parentAddress, reader, operations);
                    continue block48;
                }
                case "aggregate-role-mapper": {
                    this.readAggregateRoleMapperElement(parentAddress, reader, operations);
                    continue block48;
                }
                case "constant-role-mapper": {
                    this.readConstantRoleMapper(parentAddress, reader, operations);
                    continue block48;
                }
                case "custom-role-mapper": {
                    ElytronSubsystemParser.readCustomComponent("custom-role-mapper", parentAddress, reader, operations);
                    continue block48;
                }
                case "logical-role-mapper": {
                    this.readLogicalRoleMapper(parentAddress, reader, operations);
                    continue block48;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readAggregateNameRewriterElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addNameRewriter = new ModelNode();
        addNameRewriter.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "name": {
                    name = value;
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"name"});
        }
        addNameRewriter.get("address").set(parentAddress).add("aggregate-name-rewriter", name);
        operations.add(addNameRewriter);
        ListAttributeDefinition nameRewriters = NameRewriterDefinitions.getAggregateNameRewriterDefinition().getReferencesAttribute();
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if (!"name-rewriter".equals(localName)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
            String nameRewriterName = reader.getAttributeValue(0);
            nameRewriters.parseAndAddParameterElement(nameRewriterName, addNameRewriter, (XMLStreamReader)reader);
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }
    }

    private void readChainedNameRewriterElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addNameRewriter = new ModelNode();
        addNameRewriter.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "name": {
                    name = value;
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"name"});
        }
        addNameRewriter.get("address").set(parentAddress).add("chained-name-rewriter", name);
        operations.add(addNameRewriter);
        ListAttributeDefinition nameRewriters = NameRewriterDefinitions.getAggregateNameRewriterDefinition().getReferencesAttribute();
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if (!"name-rewriter".equals(localName)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
            String nameRewriterName = reader.getAttributeValue(0);
            nameRewriters.parseAndAddParameterElement(nameRewriterName, addNameRewriter, (XMLStreamReader)reader);
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }
    }

    private void readConstantRewriterElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addNameRewriter = new ModelNode();
        addNameRewriter.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "constant"));
        String name = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block8;
                }
                case "constant": {
                    NameRewriterDefinitions.CONSTANT.parseAndSetParameter(value, addNameRewriter, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addNameRewriter.get("address").set(parentAddress).add("constant-name-rewriter", name);
        operations.add(addNameRewriter);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void readRegexNameRewriterElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addNameRewriter = new ModelNode();
        addNameRewriter.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "pattern", "replacement"));
        String name = null;
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block12;
                }
                case "pattern": {
                    RegexAttributeDefinitions.PATTERN.parseAndSetParameter(value, addNameRewriter, (XMLStreamReader)reader);
                    continue block12;
                }
                case "replacement": {
                    NameRewriterDefinitions.REPLACEMENT.parseAndSetParameter(value, addNameRewriter, (XMLStreamReader)reader);
                    continue block12;
                }
                case "replace-all": {
                    NameRewriterDefinitions.REPLACE_ALL.parseAndSetParameter(value, addNameRewriter, (XMLStreamReader)reader);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addNameRewriter.get("address").set(parentAddress).add("regex-name-rewriter", name);
        operations.add(addNameRewriter);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void readRegexNameValidatingRewriterElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addNameRewriter = new ModelNode();
        addNameRewriter.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "pattern"));
        String name = null;
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block10;
                }
                case "pattern": {
                    RegexAttributeDefinitions.PATTERN.parseAndSetParameter(value, addNameRewriter, (XMLStreamReader)reader);
                    continue block10;
                }
                case "match": {
                    NameRewriterDefinitions.MATCH.parseAndSetParameter(value, addNameRewriter, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addNameRewriter.get("address").set(parentAddress).add("regex-name-validating-rewriter", name);
        operations.add(addNameRewriter);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void readAggregatePrincipalDecoderElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addNameRewriter = new ModelNode();
        addNameRewriter.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "name": {
                    name = value;
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"name"});
        }
        addNameRewriter.get("address").set(parentAddress).add("aggregate-principal-decoder", name);
        operations.add(addNameRewriter);
        ListAttributeDefinition principalDecoders = PrincipalDecoderDefinitions.getAggregatePrincipalDecoderDefinition().getReferencesAttribute();
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if (!"principal-decoder".equals(localName)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
            String principalDecoderName = reader.getAttributeValue(0);
            principalDecoders.parseAndAddParameterElement(principalDecoderName, addNameRewriter, (XMLStreamReader)reader);
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }
    }

    private void readX500AttributePrincipalDecoderElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addPrincipalDecoder = new ModelNode();
        addPrincipalDecoder.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "oid"));
        String name = null;
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block12;
                }
                case "oid": {
                    PrincipalDecoderDefinitions.OID.parseAndSetParameter(value, addPrincipalDecoder, (XMLStreamReader)reader);
                    continue block12;
                }
                case "joiner": {
                    PrincipalDecoderDefinitions.JOINER.parseAndSetParameter(value, addPrincipalDecoder, (XMLStreamReader)reader);
                    continue block12;
                }
                case "maximum-segments": {
                    PrincipalDecoderDefinitions.MAXIMUM_SEGMENTS.parseAndSetParameter(value, addPrincipalDecoder, (XMLStreamReader)reader);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addPrincipalDecoder.get("address").set(parentAddress).add("x500-attribute-principal-decoder", name);
        operations.add(addPrincipalDecoder);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void readSimpleRegexRealmMapperElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addRealmMapper = new ModelNode();
        addRealmMapper.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "pattern"));
        String name = null;
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block10;
                }
                case "pattern": {
                    RegexAttributeDefinitions.PATTERN.parseAndSetParameter(value, addRealmMapper, (XMLStreamReader)reader);
                    continue block10;
                }
                case "delegate-realm-mapper": {
                    RealmMapperDefinitions.DELEGATE_REALM_MAPPER.parseAndSetParameter(value, addRealmMapper, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addRealmMapper.get("address").set(parentAddress).add("simple-regex-realm-mapper", name);
        operations.add(addRealmMapper);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void readMappedRegexRealmMapperElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addRealmMapper = new ModelNode();
        addRealmMapper.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "pattern"));
        String name = null;
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block10;
                }
                case "pattern": {
                    RegexAttributeDefinitions.PATTERN.parseAndSetParameter(value, addRealmMapper, (XMLStreamReader)reader);
                    continue block10;
                }
                case "delegate-realm-mapper": {
                    RealmMapperDefinitions.DELEGATE_REALM_MAPPER.parseAndSetParameter(value, addRealmMapper, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addRealmMapper.get("address").set(parentAddress).add("mapped-regex-realm-mapper", name);
        operations.add(addRealmMapper);
        ModelNode realmNameMap = addRealmMapper.get("realm-map");
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if (!"realm-mapping".equals(localName)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            this.readRealmMapping(realmNameMap, reader);
        }
        if (!realmNameMap.isDefined()) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton("realm-mapping"));
        }
    }

    private void readRealmMapping(ModelNode realmNameMap, XMLExtendedStreamReader reader) throws XMLStreamException {
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("from", "to"));
        String from = null;
        String to = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "from": {
                    from = value;
                    continue block8;
                }
                case "to": {
                    to = value;
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        realmNameMap.add(from, to);
    }

    private void readEmptyRoleDecoder(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
        String name = reader.getAttributeValue(0);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        ModelNode addRoleDecoder = new ModelNode();
        addRoleDecoder.get("operation").set("add");
        addRoleDecoder.get("address").set(parentAddress).add("empty-role-decoder", name);
        operations.add(addRoleDecoder);
    }

    private void readSimpleRoleDecoder(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addRoleDecoder = new ModelNode();
        addRoleDecoder.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "attribute"));
        String name = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block8;
                }
                case "attribute": {
                    RoleDecoderDefinitions.ATTRIBUTE.parseAndSetParameter(value, addRoleDecoder, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addRoleDecoder.get("address").set(parentAddress).add("simple-role-decoder", name);
        operations.add(addRoleDecoder);
    }

    private void readAddPrefixRoleMapper(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addRoleMapper = new ModelNode();
        addRoleMapper.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "prefix"));
        String name = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block8;
                }
                case "prefix": {
                    RoleMapperDefinitions.PREFIX.parseAndSetParameter(value, addRoleMapper, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addRoleMapper.get("address").set(parentAddress).add("add-prefix-role-mapper", name);
        operations.add(addRoleMapper);
    }

    private void readAddSuffixRoleMapper(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addRoleMapper = new ModelNode();
        addRoleMapper.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "suffix"));
        String name = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block8;
                }
                case "suffix": {
                    RoleMapperDefinitions.SUFFIX.parseAndSetParameter(value, addRoleMapper, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addRoleMapper.get("address").set(parentAddress).add("add-suffix-role-mapper", name);
        operations.add(addRoleMapper);
    }

    private void readAggregateRoleMapperElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addRoleMapper = new ModelNode();
        addRoleMapper.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "name": {
                    name = value;
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"name"});
        }
        addRoleMapper.get("address").set(parentAddress).add("aggregate-role-mapper", name);
        operations.add(addRoleMapper);
        ListAttributeDefinition roleMappers = RoleMapperDefinitions.getAggregateRoleMapperDefinition().getReferencesAttribute();
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if (!"role-mapper".equals(localName)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
            String roleMapperName = reader.getAttributeValue(0);
            roleMappers.parseAndAddParameterElement(roleMapperName, addRoleMapper, (XMLStreamReader)reader);
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }
    }

    private void readConstantRoleMapper(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addRoleMapper = new ModelNode();
        addRoleMapper.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "roles"));
        String name = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block8;
                }
                case "roles": {
                    for (String role : reader.getListAttributeValue(i)) {
                        RoleMapperDefinitions.ROLES.parseAndAddParameterElement(role, addRoleMapper, (XMLStreamReader)reader);
                    }
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addRoleMapper.get("address").set(parentAddress).add("constant-role-mapper", name);
        operations.add(addRoleMapper);
    }

    private void readLogicalRoleMapper(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addRoleMapper = new ModelNode();
        addRoleMapper.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "logical-operation", "left", "right"));
        String name = null;
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block12;
                }
                case "logical-operation": {
                    RoleMapperDefinitions.LOGICAL_OPERATION.parseAndSetParameter(value, addRoleMapper, (XMLStreamReader)reader);
                    continue block12;
                }
                case "left": {
                    RoleMapperDefinitions.LEFT.parseAndSetParameter(value, addRoleMapper, (XMLStreamReader)reader);
                    continue block12;
                }
                case "right": {
                    RoleMapperDefinitions.RIGHT.parseAndSetParameter(value, addRoleMapper, (XMLStreamReader)reader);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addRoleMapper.get("address").set(parentAddress).add("logical-role-mapper", name);
        operations.add(addRoleMapper);
    }

    private void startMappers(boolean started, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (!started) {
            writer.writeStartElement("mappers");
        }
    }

    private boolean writeAggregateNameRewriters(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("aggregate-name-rewriter")) {
            this.startMappers(started, writer);
            List nameRewriters = subsystem.require("aggregate-name-rewriter").asPropertyList();
            for (Property current : nameRewriters) {
                ModelNode nameRewriter = current.getValue();
                writer.writeStartElement("aggregate-name-rewriter");
                writer.writeAttribute("name", current.getName());
                List nameRewriterReferences = nameRewriter.get("name-rewriters").asList();
                for (ModelNode currentReference : nameRewriterReferences) {
                    writer.writeStartElement("name-rewriter");
                    writer.writeAttribute("name", currentReference.asString());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeChainedNameRewriters(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("chained-name-rewriter")) {
            this.startMappers(started, writer);
            List nameRewriters = subsystem.require("chained-name-rewriter").asPropertyList();
            for (Property current : nameRewriters) {
                ModelNode nameRewriter = current.getValue();
                writer.writeStartElement("chained-name-rewriter");
                writer.writeAttribute("name", current.getName());
                List nameRewriterReferences = nameRewriter.get("name-rewriters").asList();
                for (ModelNode currentReference : nameRewriterReferences) {
                    writer.writeStartElement("name-rewriter");
                    writer.writeAttribute("name", currentReference.asString());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeCustomNameRewriters(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("custom-name-rewriter")) {
            this.startMappers(started, writer);
            List realms = subsystem.require("custom-name-rewriter").asPropertyList();
            for (Property current : realms) {
                ModelNode realm = current.getValue();
                ElytronSubsystemParser.writeCustomComponent("custom-name-rewriter", current.getName(), realm, writer);
            }
            return true;
        }
        return false;
    }

    private boolean writeConstantNameRewriters(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("constant-name-rewriter")) {
            this.startMappers(started, writer);
            List nameRewriters = subsystem.require("constant-name-rewriter").asPropertyList();
            for (Property current : nameRewriters) {
                ModelNode nameRewriter = current.getValue();
                writer.writeStartElement("constant-name-rewriter");
                writer.writeAttribute("name", current.getName());
                NameRewriterDefinitions.CONSTANT.marshallAsAttribute(nameRewriter, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeRegexNameRewriters(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("regex-name-rewriter")) {
            this.startMappers(started, writer);
            List nameRewriters = subsystem.require("regex-name-rewriter").asPropertyList();
            for (Property current : nameRewriters) {
                ModelNode nameRewriter = current.getValue();
                writer.writeStartElement("regex-name-rewriter");
                writer.writeAttribute("name", current.getName());
                RegexAttributeDefinitions.PATTERN.marshallAsAttribute(nameRewriter, (XMLStreamWriter)writer);
                NameRewriterDefinitions.REPLACEMENT.marshallAsAttribute(nameRewriter, (XMLStreamWriter)writer);
                NameRewriterDefinitions.REPLACE_ALL.marshallAsAttribute(nameRewriter, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeRegexNameValidatingRewriters(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("regex-name-validating-rewriter")) {
            this.startMappers(started, writer);
            List nameRewriters = subsystem.require("regex-name-validating-rewriter").asPropertyList();
            for (Property current : nameRewriters) {
                ModelNode nameRewriter = current.getValue();
                writer.writeStartElement("regex-name-validating-rewriter");
                writer.writeAttribute("name", current.getName());
                RegexAttributeDefinitions.PATTERN.marshallAsAttribute(nameRewriter, (XMLStreamWriter)writer);
                NameRewriterDefinitions.MATCH.marshallAsAttribute(nameRewriter, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeCustomPermissionMappers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("custom-permission-mapper")) {
            this.startMappers(started, writer);
            List principalDecoders = subsystem.require("custom-permission-mapper").asPropertyList();
            for (Property current : principalDecoders) {
                ModelNode principalDecoder = current.getValue();
                ElytronSubsystemParser.writeCustomComponent("custom-permission-mapper", current.getName(), principalDecoder, writer);
            }
            return true;
        }
        return false;
    }

    private boolean writeAggregatePrincipalDecoders(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("aggregate-principal-decoder")) {
            this.startMappers(started, writer);
            List principalDecoders = subsystem.require("aggregate-principal-decoder").asPropertyList();
            for (Property current : principalDecoders) {
                ModelNode principalDecoder = current.getValue();
                writer.writeStartElement("aggregate-principal-decoder");
                writer.writeAttribute("name", current.getName());
                List principalDecoderReferences = principalDecoder.get("principal-decoders").asList();
                for (ModelNode currentReference : principalDecoderReferences) {
                    writer.writeStartElement("principal-decoder");
                    writer.writeAttribute("name", currentReference.asString());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeCustomPrincipalDecoders(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("custom-principal-decoder")) {
            this.startMappers(started, writer);
            List principalDecoders = subsystem.require("custom-principal-decoder").asPropertyList();
            for (Property current : principalDecoders) {
                ModelNode principalDecoder = current.getValue();
                ElytronSubsystemParser.writeCustomComponent("custom-principal-decoder", current.getName(), principalDecoder, writer);
            }
            return true;
        }
        return false;
    }

    private boolean writeX500AttributePrincipalDecoders(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("x500-attribute-principal-decoder")) {
            this.startMappers(started, writer);
            List principalDecoders = subsystem.require("x500-attribute-principal-decoder").asPropertyList();
            for (Property current : principalDecoders) {
                ModelNode principalDecoder = current.getValue();
                writer.writeStartElement("x500-attribute-principal-decoder");
                writer.writeAttribute("name", current.getName());
                PrincipalDecoderDefinitions.OID.marshallAsAttribute(principalDecoder, (XMLStreamWriter)writer);
                PrincipalDecoderDefinitions.JOINER.marshallAsAttribute(principalDecoder, (XMLStreamWriter)writer);
                PrincipalDecoderDefinitions.MAXIMUM_SEGMENTS.marshallAsAttribute(principalDecoder, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeCustomRealmMappers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("custom-realm-mapper")) {
            this.startMappers(started, writer);
            List realmMappers = subsystem.require("custom-realm-mapper").asPropertyList();
            for (Property current : realmMappers) {
                ModelNode realmMapper = current.getValue();
                ElytronSubsystemParser.writeCustomComponent("custom-realm-mapper", current.getName(), realmMapper, writer);
            }
            return true;
        }
        return false;
    }

    private boolean writeSimpleRegexRealmMappers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("simple-regex-realm-mapper")) {
            this.startMappers(started, writer);
            List nameRewriters = subsystem.require("simple-regex-realm-mapper").asPropertyList();
            for (Property current : nameRewriters) {
                ModelNode realmMapper = current.getValue();
                writer.writeStartElement("simple-regex-realm-mapper");
                writer.writeAttribute("name", current.getName());
                RegexAttributeDefinitions.PATTERN.marshallAsAttribute(realmMapper, (XMLStreamWriter)writer);
                RealmMapperDefinitions.DELEGATE_REALM_MAPPER.marshallAsAttribute(realmMapper, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeMapRegexRealmMappers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("mapped-regex-realm-mapper")) {
            this.startMappers(started, writer);
            List nameRewriters = subsystem.require("mapped-regex-realm-mapper").asPropertyList();
            for (Property current : nameRewriters) {
                ModelNode realmMapper = current.getValue();
                writer.writeStartElement("mapped-regex-realm-mapper");
                writer.writeAttribute("name", current.getName());
                RegexAttributeDefinitions.PATTERN.marshallAsAttribute(realmMapper, (XMLStreamWriter)writer);
                RealmMapperDefinitions.DELEGATE_REALM_MAPPER.marshallAsAttribute(realmMapper, (XMLStreamWriter)writer);
                RealmMapperDefinitions.REALM_REALM_MAP.marshallAsElement(realmMapper, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeCustomRoleDecoders(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("custom-role-decoder")) {
            this.startMappers(started, writer);
            List roleDecoders = subsystem.require("custom-role-decoder").asPropertyList();
            for (Property current : roleDecoders) {
                ModelNode roleDecoder = current.getValue();
                ElytronSubsystemParser.writeCustomComponent("custom-role-decoder", current.getName(), roleDecoder, writer);
            }
            return true;
        }
        return false;
    }

    private boolean writeEmptyRoleDecoders(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("empty-role-decoder")) {
            this.startMappers(started, writer);
            List roleDecoders = subsystem.require("empty-role-decoder").asPropertyList();
            for (Property current : roleDecoders) {
                writer.writeStartElement("empty-role-decoder");
                writer.writeAttribute("name", current.getName());
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeSimpleRoleDecoders(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("simple-role-decoder")) {
            this.startMappers(started, writer);
            List roleDecoders = subsystem.require("simple-role-decoder").asPropertyList();
            for (Property current : roleDecoders) {
                ModelNode roleDecoder = current.getValue();
                writer.writeStartElement("simple-role-decoder");
                writer.writeAttribute("name", current.getName());
                RoleDecoderDefinitions.ATTRIBUTE.marshallAsAttribute(roleDecoder, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeAddPrefixRoleMappers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("add-prefix-role-mapper")) {
            this.startMappers(started, writer);
            List roleMappers = subsystem.require("add-prefix-role-mapper").asPropertyList();
            for (Property current : roleMappers) {
                ModelNode roleMapper = current.getValue();
                writer.writeStartElement("add-prefix-role-mapper");
                writer.writeAttribute("name", current.getName());
                RoleMapperDefinitions.PREFIX.marshallAsAttribute(roleMapper, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeAddSuffixRoleMappers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("add-suffix-role-mapper")) {
            this.startMappers(started, writer);
            List roleMappers = subsystem.require("add-suffix-role-mapper").asPropertyList();
            for (Property current : roleMappers) {
                ModelNode roleMapper = current.getValue();
                writer.writeStartElement("add-suffix-role-mapper");
                writer.writeAttribute("name", current.getName());
                RoleMapperDefinitions.SUFFIX.marshallAsAttribute(roleMapper, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeAggregateRoleMappers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("aggregate-role-mapper")) {
            this.startMappers(started, writer);
            List roleMappers = subsystem.require("aggregate-role-mapper").asPropertyList();
            for (Property current : roleMappers) {
                ModelNode roleMapper = current.getValue();
                writer.writeStartElement("aggregate-role-mapper");
                writer.writeAttribute("name", current.getName());
                List roleMapperReferences = roleMapper.get("role-mappers").asList();
                for (ModelNode currentReference : roleMapperReferences) {
                    writer.writeStartElement("role-mapper");
                    writer.writeAttribute("name", currentReference.asString());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeConstantRoleMappers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("constant-role-mapper")) {
            this.startMappers(started, writer);
            List roleMappers = subsystem.require("constant-role-mapper").asPropertyList();
            for (Property current : roleMappers) {
                ModelNode roleMapper = current.getValue();
                writer.writeStartElement("constant-role-mapper");
                writer.writeAttribute("name", current.getName());
                RoleMapperDefinitions.ROLES.getAttributeMarshaller().marshallAsAttribute((AttributeDefinition)RoleMapperDefinitions.ROLES, roleMapper, false, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeCustomRoleMappers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("custom-role-mapper")) {
            this.startMappers(started, writer);
            List roleMappers = subsystem.require("custom-role-mapper").asPropertyList();
            for (Property current : roleMappers) {
                ModelNode roleMapper = current.getValue();
                ElytronSubsystemParser.writeCustomComponent("custom-role-mapper", current.getName(), roleMapper, writer);
            }
            return true;
        }
        return false;
    }

    private boolean writeLogicalRoleMappers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("logical-role-mapper")) {
            this.startMappers(started, writer);
            List roleMappers = subsystem.require("logical-role-mapper").asPropertyList();
            for (Property current : roleMappers) {
                ModelNode roleMapper = current.getValue();
                writer.writeStartElement("logical-role-mapper");
                writer.writeAttribute("name", current.getName());
                RoleMapperDefinitions.LOGICAL_OPERATION.marshallAsAttribute(roleMapper, (XMLStreamWriter)writer);
                RoleMapperDefinitions.LEFT.marshallAsAttribute(roleMapper, (XMLStreamWriter)writer);
                RoleMapperDefinitions.RIGHT.marshallAsAttribute(roleMapper, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    void writeMappers(ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        boolean mappersStarted = false;
        mappersStarted |= this.writeAggregateNameRewriters(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeChainedNameRewriters(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeConstantNameRewriters(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeCustomNameRewriters(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeRegexNameRewriters(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeRegexNameValidatingRewriters(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeCustomPermissionMappers(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeAggregatePrincipalDecoders(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeCustomPrincipalDecoders(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeX500AttributePrincipalDecoders(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeCustomRealmMappers(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeSimpleRegexRealmMappers(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeMapRegexRealmMappers(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeCustomRoleDecoders(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeEmptyRoleDecoders(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeSimpleRoleDecoders(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeAddPrefixRoleMappers(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeAddSuffixRoleMappers(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeAggregateRoleMappers(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeConstantRoleMappers(mappersStarted, subsystem, writer);
        mappersStarted |= this.writeCustomRoleMappers(mappersStarted, subsystem, writer);
        if (mappersStarted |= this.writeLogicalRoleMappers(mappersStarted, subsystem, writer)) {
            writer.writeEndElement();
        }
    }
}

