/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.EmptyResourceDefinition;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.security.auth.server.RealmMapper;
import org.wildfly.security.authz.RoleDecoder;

class RoleDecoderDefinitions {
    static final SimpleAttributeDefinition ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("attribute", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();

    RoleDecoderDefinitions() {
    }

    static ResourceDefinition getEmptyRoleDecoderDefinition() {
        return EmptyResourceDefinition.create(RoleDecoder.class, "empty-role-decoder", Capabilities.ROLE_DECODER_RUNTIME_CAPABILITY, () -> RoleDecoder.EMPTY);
    }

    static ResourceDefinition getSimpleRoleDecoderDefinition() {
        return new SimpleRoleDecoderDefinition();
    }

    private static class WriteAttributeHandler
    extends RestartParentWriteAttributeHandler {
        WriteAttributeHandler(String parentName, AttributeDefinition ... attributes) {
            super(parentName, attributes);
        }

        protected ServiceName getParentServiceName(PathAddress pathAddress) {
            return Capabilities.ROLE_DECODER_RUNTIME_CAPABILITY.fromBaseCapability(pathAddress.getLastElement().getValue()).getCapabilityServiceName(RoleDecoder.class);
        }
    }

    private static class RoleDecoderRemoveHandler
    extends ServiceRemoveStepHandler {
        public RoleDecoderRemoveHandler(AbstractAddStepHandler addOperation) {
            super(addOperation, new RuntimeCapability[]{Capabilities.ROLE_DECODER_RUNTIME_CAPABILITY});
        }

        protected ServiceName serviceName(String name) {
            return Capabilities.ROLE_DECODER_RUNTIME_CAPABILITY.fromBaseCapability(name).getCapabilityServiceName(RealmMapper.class);
        }
    }

    private static class SimpleRoleDecoderAddHandler
    extends AbstractAddStepHandler {
        private SimpleRoleDecoderAddHandler() {
            super(Capabilities.ROLE_DECODER_RUNTIME_CAPABILITY, new AttributeDefinition[]{ATTRIBUTE});
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability runtimeCapability = Capabilities.ROLE_DECODER_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName roleDecoderName = runtimeCapability.getCapabilityServiceName(RoleDecoder.class);
            String attribute = ATTRIBUTE.resolveModelAttribute(context, model).asString();
            TrivialService<RoleDecoder> roleDecoderService = new TrivialService<RoleDecoder>(() -> RoleDecoder.simple((String)attribute));
            ServiceBuilder roleDecoderBuilderBuilder = serviceTarget.addService(roleDecoderName, roleDecoderService);
            ElytronDefinition.commonDependencies(roleDecoderBuilderBuilder).setInitialMode(ServiceController.Mode.LAZY).install();
        }
    }

    private static class SimpleRoleDecoderDefinition
    extends SimpleResourceDefinition {
        private static final AbstractAddStepHandler ADD = new SimpleRoleDecoderAddHandler();
        private static final OperationStepHandler REMOVE = new RoleDecoderRemoveHandler(ADD);

        SimpleRoleDecoderDefinition() {
            super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"simple-role-decoder"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("simple-role-decoder")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES));
        }

        public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)ATTRIBUTE, null, (OperationStepHandler)new WriteAttributeHandler("simple-role-decoder", new AttributeDefinition[]{ATTRIBUTE}));
        }
    }
}

