/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import javax.security.sasl.SaslServerFactory;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.SaslFactoryRuntimeResource;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityDomainSaslConfiguration;

class SecurityDomainSaslConfigurationDefinition
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-domain", ModelType.STRING, false).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.security-domain", "org.wildfly.security.security-domain-sasl-configuration", true).build();
    static final SimpleAttributeDefinition SASL_SERVER_FACTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("sasl-server-factory", ModelType.STRING, false).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.sasl-server-factory", "org.wildfly.security.security-domain-sasl-configuration", true).build();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{SECURITY_DOMAIN, SASL_SERVER_FACTORY};
    private static final AbstractAddStepHandler ADD = new AddHandler();
    private static final OperationStepHandler REMOVE = new RemoveHandler(ADD);

    private SecurityDomainSaslConfigurationDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"security-domain-sasl-configuration"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("security-domain-sasl-configuration")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES));
    }

    static ResourceDefinition create() {
        return SaslFactoryRuntimeResource.wrap((ResourceDefinition)new SecurityDomainSaslConfigurationDefinition(), SecurityDomainSaslConfigurationDefinition::getSaslServerFactory);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        WriteAttributeHandler write = new WriteAttributeHandler();
        for (AttributeDefinition current : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)write);
        }
    }

    private static SaslServerFactory getSaslServerFactory(OperationContext context) throws OperationFailedException {
        RuntimeCapability runtimeCapability = Capabilities.SECURITY_DOMAIN_SASL_CONFIGURATION_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
        ServiceName securityDomainSaslConfigurationName = runtimeCapability.getCapabilityServiceName(SecurityDomainSaslConfiguration.class);
        ServiceController serviceContainer = context.getServiceRegistry(false).getRequiredService(securityDomainSaslConfigurationName);
        if (serviceContainer.getState() != ServiceController.State.UP) {
            return null;
        }
        return ((SecurityDomainSaslConfiguration)serviceContainer.getValue()).getSaslServerFactory();
    }

    private static class WriteAttributeHandler
    extends RestartParentWriteAttributeHandler {
        WriteAttributeHandler() {
            super("security-domain-sasl-configuration", ATTRIBUTES);
        }

        protected ServiceName getParentServiceName(PathAddress pathAddress) {
            return Capabilities.SECURITY_DOMAIN_SASL_CONFIGURATION_RUNTIME_CAPABILITY.fromBaseCapability(pathAddress.getLastElement().getValue()).getCapabilityServiceName(SecurityDomainSaslConfiguration.class);
        }
    }

    private static class RemoveHandler
    extends ServiceRemoveStepHandler {
        public RemoveHandler(AbstractAddStepHandler addOperation) {
            super(addOperation, new RuntimeCapability[]{Capabilities.SECURITY_DOMAIN_SASL_CONFIGURATION_RUNTIME_CAPABILITY});
        }

        protected ServiceName serviceName(String name) {
            return Capabilities.SECURITY_DOMAIN_SASL_CONFIGURATION_RUNTIME_CAPABILITY.fromBaseCapability(name).getCapabilityServiceName(SecurityDomainSaslConfiguration.class);
        }
    }

    private static class AddHandler
    extends AbstractAddStepHandler {
        private AddHandler() {
            super(Capabilities.SECURITY_DOMAIN_SASL_CONFIGURATION_RUNTIME_CAPABILITY, ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability runtimeCapability = Capabilities.SECURITY_DOMAIN_SASL_CONFIGURATION_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName serviceName = runtimeCapability.getCapabilityServiceName(SecurityDomainSaslConfiguration.class);
            String securityDomain = SECURITY_DOMAIN.resolveModelAttribute(context, model).asString();
            String saslServerFactory = SASL_SERVER_FACTORY.resolveModelAttribute(context, model).asString();
            InjectedValue securityDomainInjector = new InjectedValue();
            InjectedValue saslServerFactoryInjector = new InjectedValue();
            TrivialService<SecurityDomainSaslConfiguration> serviceInstance = new TrivialService<SecurityDomainSaslConfiguration>(() -> new SecurityDomainSaslConfiguration((SecurityDomain)securityDomainInjector.getValue(), (SaslServerFactory)saslServerFactoryInjector.getValue()));
            ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, serviceInstance);
            serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.security-domain", (String)securityDomain), SecurityDomain.class), SecurityDomain.class, (Injector)securityDomainInjector);
            serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.sasl-server-factory", (String)saslServerFactory), SaslServerFactory.class), SaslServerFactory.class, (Injector)saslServerFactoryInjector);
            ElytronDefinition.commonDependencies(serviceBuilder).setInitialMode(ServiceController.Mode.LAZY).install();
        }
    }
}

