/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.elytron.ElytronSubsystemParser;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.KeyStoreDefinition;

class TlsParser {
    TlsParser() {
    }

    void readKeyStores(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if ("keystore".equals(localName)) {
                this.readKeyStore(parentAddress, reader, operations);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readKeyStore(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode addKeyStore = new ModelNode();
        addKeyStore.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "type"));
        String name = null;
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block14;
                }
                case "type": {
                    KeyStoreDefinition.TYPE.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block14;
                }
                case "provider": {
                    KeyStoreDefinition.PROVIDER.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block14;
                }
                case "provider-loader": {
                    KeyStoreDefinition.PROVIDER_LOADER.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block14;
                }
                case "password": {
                    KeyStoreDefinition.PASSWORD.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block14;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addKeyStore.get("address").set(parentAddress).add("keystore", name);
        list.add(addKeyStore);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if ("file".equals(localName)) {
                this.readFile(addKeyStore, reader, list);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readFile(ModelNode addOp, XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        boolean pathFound = false;
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "relative-to": {
                    FileAttributeDefinitions.RELATIVE_TO.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block10;
                }
                case "path": {
                    pathFound = true;
                    FileAttributeDefinitions.PATH.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block10;
                }
                case "required": {
                    KeyStoreDefinition.REQUIRED.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!pathFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"path"});
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    void writeKeyStore(String name, ModelNode keyStore, XMLExtendedStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("keystore");
        writer.writeAttribute("name", name);
        KeyStoreDefinition.TYPE.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
        KeyStoreDefinition.PROVIDER.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
        KeyStoreDefinition.PROVIDER_LOADER.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
        KeyStoreDefinition.PASSWORD.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
        if (keyStore.hasDefined("path")) {
            writer.writeStartElement("file");
            FileAttributeDefinitions.RELATIVE_TO.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
            FileAttributeDefinitions.PATH.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
            KeyStoreDefinition.REQUIRED.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

