/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.CredentialSecurityFactoryParser;
import org.wildfly.extension.elytron.CredentialStoreParser;
import org.wildfly.extension.elytron.CustomComponentDefinition;
import org.wildfly.extension.elytron.DirContextParser;
import org.wildfly.extension.elytron.DomainParser;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.HttpParser;
import org.wildfly.extension.elytron.MapperParser;
import org.wildfly.extension.elytron.ProviderLoaderParser;
import org.wildfly.extension.elytron.RealmParser;
import org.wildfly.extension.elytron.SaslParser;
import org.wildfly.extension.elytron.SecurityPropertyResourceDefinition;
import org.wildfly.extension.elytron.TlsParser;

class ElytronSubsystemParser
implements XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    private final DomainParser domainParser = new DomainParser();
    private final RealmParser realmParser = new RealmParser();
    private final TlsParser tlsParser = new TlsParser();
    private final ProviderLoaderParser providerLoaderParser = new ProviderLoaderParser();
    private final CredentialSecurityFactoryParser credentialSecurityFactoryParser = new CredentialSecurityFactoryParser();
    private final MapperParser mapperParser = new MapperParser();
    private final SaslParser saslParser = new SaslParser();
    private final HttpParser httpParser = new HttpParser();
    private final CredentialStoreParser credentialStoreParser = new CredentialStoreParser();
    private final DirContextParser dirContextParser = new DirContextParser();

    ElytronSubsystemParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode subsystemAdd = ElytronExtension.createAddSubsystemOperation();
        operations.add(subsystemAdd);
        ModelNode parentAddress = subsystemAdd.get("address");
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        HashSet<String> foundElements = new HashSet<String>();
        block26: while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if (!foundElements.add(localName)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (reader.getLocalName()) {
                case "security-properties": {
                    this.readSecurityProperties(parentAddress, reader, operations);
                    continue block26;
                }
                case "provider-loaders": {
                    this.readProviderLoaders(parentAddress, reader, operations);
                    continue block26;
                }
                case "security-domains": {
                    this.readDomains(parentAddress, reader, operations);
                    continue block26;
                }
                case "security-realms": {
                    this.realmParser.readRealms(parentAddress, reader, operations);
                    continue block26;
                }
                case "credential-security-factories": {
                    this.credentialSecurityFactoryParser.readCredentialSecurityFactories(parentAddress, reader, operations);
                    continue block26;
                }
                case "mappers": {
                    this.mapperParser.readMappers(parentAddress, reader, operations);
                    continue block26;
                }
                case "http": {
                    this.httpParser.readHttp(parentAddress, reader, operations);
                    continue block26;
                }
                case "sasl": {
                    this.saslParser.readSasl(parentAddress, reader, operations);
                    continue block26;
                }
                case "tls": {
                    this.tlsParser.readTls(parentAddress, reader, operations);
                    continue block26;
                }
                case "credential-stores": {
                    this.credentialStoreParser.readCredentialStores(parentAddress, reader, operations);
                    continue block26;
                }
                case "dir-contexts": {
                    this.dirContextParser.readDirContexts(parentAddress, reader, operations);
                    continue block26;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    public void readSecurityProperties(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if ("security-property".equals(localName)) {
                ModelNode operation = new ModelNode();
                operation.get("operation").set("add");
                HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("key", "value"));
                String name = null;
                int count = reader.getAttributeCount();
                block9: for (int i = 0; i < count; ++i) {
                    String value = reader.getAttributeValue(i);
                    if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    String attribute = reader.getAttributeLocalName(i);
                    requiredAttributes.remove(attribute);
                    switch (attribute) {
                        case "key": {
                            name = value;
                            continue block9;
                        }
                        case "value": {
                            SecurityPropertyResourceDefinition.VALUE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            continue block9;
                        }
                        default: {
                            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                        }
                    }
                }
                if (!requiredAttributes.isEmpty()) {
                    throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
                }
                operation.get("address").set(parentAddress).add("security-property", name);
                operations.add(operation);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    public void readProviderLoaders(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if ("provider-loader".equals(localName)) {
                this.providerLoaderParser.readProviderLoader(parentAddress, reader, operations);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readDomains(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if ("security-domain".equals(localName)) {
                this.domainParser.readDomain(parentAddress, reader, operations);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void readCustomComponent(String componentType, ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addComponent = new ModelNode();
        addComponent.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "class-name"));
        String name = null;
        int count = reader.getAttributeCount();
        block16: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block16;
                }
                case "module": {
                    ClassLoadingAttributeDefinitions.MODULE.parseAndSetParameter(value, addComponent, (XMLStreamReader)reader);
                    continue block16;
                }
                case "class-name": {
                    ClassLoadingAttributeDefinitions.CLASS_NAME.parseAndSetParameter(value, addComponent, (XMLStreamReader)reader);
                    continue block16;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addComponent.get("address").set(parentAddress).add(componentType, name);
        block17: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName;
            ElytronSubsystemParser.verifyNamespace(reader);
            switch (localName = reader.getLocalName()) {
                case "configuration": {
                    ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
                    ElytronSubsystemParser.parseConfiguration(addComponent, reader);
                    continue block17;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(addComponent);
    }

    private static void parseConfiguration(ModelNode addOperation, XMLExtendedStreamReader reader) throws XMLStreamException {
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName;
            ElytronSubsystemParser.verifyNamespace(reader);
            switch (localName = reader.getLocalName()) {
                case "property": {
                    ElytronSubsystemParser.parsePropertyElement(addOperation, reader);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parsePropertyElement(ModelNode addOperation, XMLExtendedStreamReader reader) throws XMLStreamException {
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("key", "value"));
        String key = null;
        String value = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String attributeValue = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "key": {
                    key = attributeValue;
                    continue block8;
                }
                case "value": {
                    value = attributeValue;
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addOperation.get("configuration").add(key, new ModelNode(value));
    }

    static void writeCustomComponent(String elementName, String componentName, ModelNode component, XMLExtendedStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(elementName);
        writer.writeAttribute("name", componentName);
        ClassLoadingAttributeDefinitions.MODULE.marshallAsAttribute(component, (XMLStreamWriter)writer);
        ClassLoadingAttributeDefinitions.CLASS_NAME.marshallAsAttribute(component, (XMLStreamWriter)writer);
        CustomComponentDefinition.CONFIGURATION.marshallAsElement(component, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement("urn:wildfly:elytron:1.0", false);
        ModelNode model = context.getModelNode();
        if (model.hasDefined("security-property")) {
            writer.writeStartElement("security-properties");
            ModelNode securityProperties = model.require("security-property");
            for (String name : securityProperties.keys()) {
                writer.writeEmptyElement("security-property");
                writer.writeAttribute("key", name);
                SecurityPropertyResourceDefinition.VALUE.marshallAsAttribute(securityProperties.require(name), (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        }
        if (model.hasDefined("provider-loader")) {
            writer.writeStartElement("provider-loaders");
            ModelNode providerLoaders = model.require("provider-loader");
            for (String name : providerLoaders.keys()) {
                ModelNode providerLoader = providerLoaders.require(name);
                this.providerLoaderParser.writeProviderLoader(name, providerLoader, writer);
            }
            writer.writeEndElement();
        }
        if (model.hasDefined("security-domain")) {
            writer.writeStartElement("security-domains");
            ModelNode securityDomains = model.require("security-domain");
            for (String name : securityDomains.keys()) {
                ModelNode domain = securityDomains.require(name);
                this.domainParser.writeDomain(name, domain, writer);
            }
            writer.writeEndElement();
        }
        this.realmParser.writeRealms(model, writer);
        this.credentialSecurityFactoryParser.writeCredentialSecurityFactories(model, writer);
        this.mapperParser.writeMappers(model, writer);
        this.httpParser.writeHttp(model, writer);
        this.saslParser.writeSasl(model, writer);
        this.tlsParser.writeTLS(model, writer);
        this.credentialStoreParser.writeCredentialStores(model, writer);
        this.dirContextParser.writeDirContexts(model, writer);
        writer.writeEndElement();
    }

    static void verifyNamespace(XMLExtendedStreamReader reader) throws XMLStreamException {
        if (!"urn:wildfly:elytron:1.0".equals(reader.getNamespaceURI())) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }
}

