/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.nio.file.Path;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.security.auth.realm.FileSystemSecurityRealm;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.SecurityRealm;

class FileSystemRealmDefinition
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("path", FileAttributeDefinitions.PATH).setAttributeGroup("file")).setAllowNull(false)).build();
    static final SimpleAttributeDefinition RELATIVE_TO = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("relative-to", FileAttributeDefinitions.RELATIVE_TO).setAttributeGroup("file")).build();
    static final SimpleAttributeDefinition LEVELS = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("levels", ModelType.INT, true).setDefaultValue(new ModelNode(2))).build();
    static final SimpleAttributeDefinition NAME_REWRITER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name-rewriter", ModelType.STRING).setXmlName("name")).setCapabilityReference("org.wildfly.security.name-rewriter", "org.wildfly.security.security-realm", true)).setAllowNull(true)).build();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{PATH, RELATIVE_TO, LEVELS, NAME_REWRITER};
    private static final AbstractAddStepHandler ADD = new RealmAddHandler();
    private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY);

    FileSystemRealmDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"filesystem-realm"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("filesystem-realm")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        WriteAttributeHandler handler = new WriteAttributeHandler();
        for (AttributeDefinition attr : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)handler);
        }
    }

    private static class WriteAttributeHandler
    extends RestartParentWriteAttributeHandler {
        WriteAttributeHandler() {
            super("filesystem-realm", ATTRIBUTES);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            String name = parentAddress.getLastElement().getValue();
            return Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(name).getCapabilityServiceName();
        }
    }

    private static class RealmAddHandler
    extends BaseAddHandler {
        private RealmAddHandler() {
            super(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY, ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            String address = context.getCurrentAddressValue();
            ServiceName mainServiceName = Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(address).getCapabilityServiceName();
            ServiceName aliasServiceName = Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(address).getCapabilityServiceName();
            String nameRewriter = ElytronExtension.asStringIfDefined(context, NAME_REWRITER, model);
            final int levels = LEVELS.resolveModelAttribute(context, model).asInt();
            final String path = PATH.resolveModelAttribute(context, model).asString();
            final String relativeTo = ElytronExtension.asStringIfDefined(context, RELATIVE_TO, model);
            final InjectedValue pathManagerInjector = new InjectedValue();
            final InjectedValue nameRewriterInjector = new InjectedValue();
            TrivialService<SecurityRealm> fileSystemRealmService = new TrivialService<SecurityRealm>(new TrivialService.ValueSupplier<SecurityRealm>(){
                private FileAttributeDefinitions.PathResolver pathResolver;

                @Override
                public SecurityRealm get() throws StartException {
                    this.pathResolver = FileAttributeDefinitions.pathResolver();
                    Path rootPath = this.pathResolver.path(path).relativeTo(relativeTo, (PathManager)pathManagerInjector.getOptionalValue()).resolve().toPath();
                    NameRewriter nameRewriter = (NameRewriter)nameRewriterInjector.getOptionalValue();
                    return nameRewriter != null ? new FileSystemSecurityRealm(rootPath, nameRewriter, levels) : new FileSystemSecurityRealm(rootPath, levels);
                }

                @Override
                public void dispose() {
                    if (this.pathResolver != null) {
                        this.pathResolver.clear();
                        this.pathResolver = null;
                    }
                }
            });
            ServiceBuilder serviceBuilder = serviceTarget.addService(mainServiceName, fileSystemRealmService).addAliases(new ServiceName[]{aliasServiceName});
            if (relativeTo != null) {
                serviceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, (Injector)pathManagerInjector);
                serviceBuilder.addDependency(FileAttributeDefinitions.pathName(relativeTo));
            }
            if (nameRewriter != null) {
                String nameRewriteCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.name-rewriter", (String)nameRewriter);
                ServiceName nameRewriterServiceName = context.getCapabilityServiceName(nameRewriteCapability, NameRewriter.class);
                serviceBuilder.addDependency(nameRewriterServiceName, NameRewriter.class, (Injector)nameRewriterInjector);
            }
            serviceBuilder.install();
        }
    }
}

